@extends('layouts.default')
@section('title', 'Agreements list')
@section('header-links')
    @include('includes.headers.agreements')
@endsection

@section('new_button')
  <div class="searchBox mr-2">
    {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => 'Search here']) !!}
      <span class="search-icn"><i class="material-icons">search</i></span>
      <span class="form-controlBrd"></span>
  </div>
  <a href="{{ url('/agreements/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Aggrement"><i class="material-icons left">add</i> Create Agreement</a>
@endsection

@section('content')
  <div class="table-responsive">
    <table id="example" class="table table-show table-bordered table-filter">
      <thead>
        <tr>
          <th>Title</th>
          <th>No.Of Pages</th>
          <th>Sent Count</th>
          <th>File</th>
          <th>Created On</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        @foreach($list as $agreement)
        <tr>
          <td>{{ ucwords($agreement->name) }}</td>
          <td>{{ $agreement->pages }}</td>
          <td>{{ $agreement->sent }}</td>
          <td><a href="/download/{{ $agreement->filename }}" class="btn btn34 btn-default btn-circle-iconic waves-effect waves-blue" target="_blank"><span class="icon24 icon-Attachments"></span></a></td>
          <td>{{ \Carbon\Carbon::parse($agreement->created_at)->format(env('APP_DATE')) }}</td>
          <td><a href="{{ url('/agreements') }}/{{ $agreement->id }}/edit" class="btn btn34 btn-outline-info btn-circle-iconic waves-effect waves-blue" title="Edit"><i class="material-icons">create</i></a></td>
        </tr>
        @endforeach
        @if(count($list) == 0)
        <tr>
          <td colspan="6" class="text-center">No Data</td>
        </tr>
        @endif
      </tbody>
    </table>
  </div>
@stop