<!DOCTYPE html>
<html>
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css"
    integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"
    integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous">
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"
    integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous">
</script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"
    integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous">
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.25/webcam.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css" />

<head>
    <title>Digital Agreement</title>
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <style type="text/css">
        @import url('https://fonts.googleapis.com/css?family=Josefin+Sans:100,300,400,600,700');

        .login {
            font-family: 'Josefin Sans', sans-serif;
            background: #fbfbfb;
            padding: 40px 0px;
        }

        label {
            font-weight: 400;
            font-size: 15px;
        }

        .login-box {
            -webkit-box-shadow: 0px 0px 14px 0px rgba(0, 0, 0, 0.24);
            -moz-box-shadow: 0px 0px 14px 0px rgba(0, 0, 0, 0.24);
            box-shadow: 0px 0px 14px 0px rgba(0, 0, 0, 0.24);
            padding: 0px;
            background: #78d46e;
            margin-top: 2%;
        }

        .left-box {
            padding: 20px;
            color: #FFF;
        }

        .left-box h1 {
            font-weight: 400;
            font-family: 'Josefin Sans', sans-serif;
            text-transform: capitalize;
            color: #FFF;
            font-size: 32px;
        }

        .right-box {
            background: #FFF;
            min-height: 520px;
        }

        .right-box h1 {
            font-weight: 400;
            font-family: 'Josefin Sans', sans-serif;
            color: #444;
            font-size: 32px;
            padding: 20px;
        }

        .form {
            padding: 20px 30px;
        }

        .form-control {
            box-shadow: none;
            border-radius: 0px;
            border-bottom: 1px solid #2196f3;
            border-top: 1px;
            border-left: none;
            border-right: none;
        }

        .btn {
            font-weight: 700;
            font-size: 15px;
            color: #FFF;
            border-radius: 0;
            background: #78d46e;
            padding: 12px 30px;
            margin-top: 40px;
        }

        .btn:hover {
            border: 2px solid #78d46e;
            background: #FFF;
        }

        input[type=text],
        input[type=password],
        input[type=email] {
            background-color: transparent;
            border: none;
            border-bottom: 1px solid #d2d2d2;
            border-radius: 0;
            margin-bottom: 50px;
            box-shadow: none;
        }

        input[type=text]:focus,
        input[type=password]:focus,
        input[type=email]:focus {
            box-shadow: none;
            border-bottom: 1px solid #78d46e;
        }

        .form2 {
            padding: 30px 0px;
        }

        .white-btn {
            background: #FFF;
            color: #78d46e;
        }

        /******* CSS *********/
        .previous-tab,
        .next-tab{
        display: inline-block;
        border: 1px solid #444348;
        border-radius: 3px;
        margin: 5px;
        color: #444348;
        font-size: 14px;
        padding: 10px 15px;
        cursor: pointer;
        }
    </style>
</head>

<body>
    <div class="login">
        <div class="container">
            <h1 class="text-center" style="text-align: center;">Employee Digital Agreement</h1> <br>
            <div class="row">         
                {!! Form::open(['url'=>'save_agreement_return', 'files'=>true], ['method'=>'POST']) !!}
                {{ Form::hidden('cand_id', $consultant->id)}}
                {{ Form::hidden('agreement_id', $agreement_id)}}
                {{ Form::hidden('login_id', $login_id)}}
                <div class="row mt-3">
                    <div class="col-md-12" id="tab1">
                        <div class="row">
                            <p> Employment Agreement is effective this <u>10</u> day of <u>10</u> 2021. By and between
                            <b>R10 Network, Inc.</b>, Suite 500, 9761 Crosspoint Blvd, Indianapolis, IN 46256, USA (The company) and <u>{{ isset($student->first_name)?ucwords($student->first_name):'' }}</u> (Name of the Employee) having SSN# <u>{{ isset($student->ssn)?ucwords($student->ssn):'' }}</u>,
                            residing at (Address) <u>{{ isset($student->address)?ucwords($student->address):'' }}</u> (collectively, the “Parties”).</p>

                            <p>If we cannot provide Job within two months of signing this agreement, this agreement remains void.</P>
                            <p>WHEREAS, the Company is in the business of providing software consulting services;</P>
                            <p>WHEREAS, the Employee desires to provide software consulting services to the Company; and</P>
                            <p>WHEREAS, the Company desires to employ the Employee only upon the terms and conditions set forth herein, and the Employee agrees to accept such employment.</P>
                            <p>NOW THEREFORE, in consideration of the mutual premises and agreements contained in this Agreement and intending to be legally bound there by the Company and Employee hereby agrees as follows.</P>
                        </div>
                        <input type="checkbox" name="checkbox1" id="checkbox1" required> I have read and understood above terms and conditions.

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="button1" onclick="showTab(1)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab2">
                        <h3 class="text-center">Article 1</h3>
                        <p style="text-decoration: underline;" class="text-center">Engagement</p>
                        <div class="row">
                            <p>The Employee represents that the Employee is not in any way restricted from entering into this Agreement, including by prior or existing agreement with any other person or entity and hereby agrees to indemnify, defend (Including paying the Company reasonable attorney’s fees, and all other foreseeable costs) and hold the Company harmless with respect to all claims and suits because of any such prior or existing agreement. The Company hereby retains the Employee to provide computer consulting services for clients, vendors or end-clients (collectively referred to as “Clients”). The Employee agrees to the best of the Employee’s ability to perform and render such services including, but not limited to, providing software consulting services for Clients. The Employee shall devote all the Employee’s working time to such services and duties. The Employee shall discharge the Employee’s responsibilities pursuant to this Agreement competently, carefully and faithfully. In performance of the Employee’s duties, the Employee shall comply with all the Company’s policies, rules, procedures, as well as all applicable local, state and federal laws, rules, regulations, statutes, ordinances and other provisions of law, and shall maintain a standard of professional conduct that is acceptable to the Company. The Employee agrees to provide status reports and timesheets to the company on a periodic basis as required by the Company.</p>
                        </div>
                        <input type="checkbox" name="checkbox2" id="checkbox2" required> I have read and understood above terms and conditions.

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev1" onclick="showPrevTab(1)">Previous</button>
                            <button class="btn btn-sm btn-light" id="button2" onclick="showTab(2)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab3">
                        <h3 class="text-center">Article 2</h3>
                        <p style="text-decoration: underline;" class="text-center">TERM and TERMINATION</p>
                        <div class="row">
                            <p><u>2.01</u> Term and Termination. Employee shall undergo technical training as referenced in Article 1 for such period as may be determined by Company in Company’s discretion for a period not to exceed three (3) months (the “TrainingPeriod”). Upon completion of the Training Period, Employee will participate in a career preparation program and may be required to attend interviews and take such other actions as may be determined by Company, in Company’s discretion, to facilitate the placement of Employee with a Client for a period not to exceed three (3) months (the “Marketing Period”). Upon Employee’s placement with a Client, Employee shall perform services on behalf of Company for that Client and/or such other Client(s) as Company may direct for a period of at least Twelve (12) months. The Training Period, Marketing Period, and the 12-month period beginning on the date of Employee’s first placement with a Client collectively shall constitute the “Term.” This Agreement may be terminated by the Company at any time with or without cause and with no advance written or oral notice to the Employee. Upon termination of this Agreement by the Company, the Company shall not be obligated to make payment of any compensation to the Employee other than earned but unpaid salary through the date of termination. Upon payment of such salary, the Company shall have no further obligation to Employee under this Agreement. The Employee may terminate this Agreement after the Term by providing thirty (30) days advance written notice to the Company, or at the end of the Marketing Period by providing thirty (30) days advance written notice to the Company if the Company and the Employee have not located an assignment for the Employee.</p>

                            <p><u>2.02</u> Remedies. Other than as specifically provided herein, Employee shall remain employed by the Company for the duration of the Term. Employee acknowledges the time, effort and resources that the Company will expend in training and marketing Employee, and the damage that will result in the Company’s business in the event that Employee fails to appear at the outset of the Term or terminates this Agreement prior to the end of the Term. Accordingly, in the event that Employee fails to appear at the outset of the Term, or if Employee terminates Employee’s employment by the Company prior to the end of the Term, in addition to any other obligation that Employee may have to the Company under this Agreement, Employee shall be liable to Company for liquidated damages in the amount of ten thousand dollars ($10,000.00) for each remaining month of the term (which amount shall be prorated for any partial remaining months), which amount represents a fair and just allocation of lost profits that cannot be calculated with mathematical certainty, as well as the training and marketing costs incurred by the Company.</p>
                        </div>
                        <input type="checkbox" name="checkbox3" id="checkbox3" required> I have read and understood above terms and conditions.

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev2" onclick="showPrevTab(2)">Previous</button>
                            <button class="btn btn-sm btn-light" id="button3" onclick="showTab(3)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab4">
                        <h3 class="text-center">Article 3</h3>
                        <p style="text-decoration: underline;" class="text-center">Compensation</p>
                        <div class="row">
                            <p><u>3.01</u> Salary and Benefits. During the term of this Agreement and for the services rendered by Employee pursuant to this Agreement, the Company shall pay the Employee annual salary as per below details. Any salary revisions will be as set forth in Addendum to Offer letter (Attachment A). The wages shall be paid monthly or in accordance with the Company’s regular payroll practice as may exist from time to time. The Employee shall have all hours worked approved by the Employee’s project manager. During the period in which the Employee performs services under this Agreement, the Employee shall become eligible to participate in any applicable medical insurance coverage and other benefits as Employee is entitled to in accordance with the Company’s policies and procedures. However, the Company reserves the right to modify or terminate any such benefits at any time and for any or no reason.</p>
                            <p><b>Base Salary:</b> R10 networks Inc. Offers you salary as below hours (Salary will be calculated based on hours only);</p>
                            <p>1 Hrs – 1000 Hrs (Approximately 1st Month to 6th Month) = (Approximately $65000 Per Annum)</p>
                            <p>1001 Hrs – 2000 Hrs (Approx 7th Month to 12th Month Onwards) = 70%-30% (Consultant 70% - Company 30%)</p>
                            <p>2001 Hrs – 3000 Hrs (Approx 12th Month to 18th Month Onwards) = 75%-25% (Consultant 75% - Company 25%)</p>
                            <p>From 3001 Hrs (Approximately from 18th Month Onwards) = 80%-20% forever (Consultant 80% - Company 20%)</p>

                            <p><b>Note:</b> During Bench Period, the salary calculation will be on HOLD and will resume only when the consultant takes the next client project.</p>
                            <p><b>Note:</b> If the client project completes in between the salary change, then prior salary will continue during that period.</p>
                            <p><b>Note:</b> The salary is based on anticipation that the employee will be billable for 40 hours each week during each calendar year, except for paid holidays and paid vacation. If the employee is not employed for 40 hours each week, employee stays non-billable, then the salary we will be adjusted accordingly.</p>
                            <p>Miscellaneous terms and conditions of this project assignment: This project assignment is back-to-back tied with R10 Networks Inc client engagement. It automatically ends on termination of 1 year from enrolling in R10 Networks Inc Payroll System. Employee acknowledged that they hold a copy of valid US Citizenship of the employee on their Company and will maintain the valid US work authorization at all times.</p>
                            <p><b>Payment terms:</b> Pay-check will be issued based on Net-30 terms after employee enrolled in Payroll after successful
                            training and selection by client Employee can’t be paid during bench period and salary will be renewed after next
                            assignment.</p>
                            <p>As a contractor, Employee salaries are based on Vendor payments. Employee will receive the salary on Net-30 terms where the reference date is the first invoice date and continue to receive a check for every month. Payroll date will be 3rd of every month as long as the work assignment is active with the client. Employee joined in between the month, will follow Net-30 terms only</p>
                            <p><b>Time Sheets:</b> Employee to log client approved weekly time with R10 networks Inc A/P every Friday. Employee can start the engagement after satisfactory background and drug screening reports.</p>
                            <p>One Month advance written notice required by Employee to early terminate agreement.</p>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <p>By: R10 Networks, Inc.</p>
                                <p>Name: Swetha Narla</p>
                                <p>Title: Director</p>
                            </div>
                            <div class="col-sm-6">
                                <p>By: Employee</p>
                                <p style="display: inline-flex;">Signature: <input type="text" name="name1" class="form-control mb-0" required placeholder="Name" id="name1"> </p>
                                <p>Name: {{ isset($student->first_name)?ucwords($student->first_name):"" }}</p>
                            </div>
                        </div>
                        <input type="checkbox" name="checkbox4" id="checkbox4" required> I have read and understood above terms and conditions.

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev3" onclick="showPrevTab(3)">Previous</button>
                            <button class="btn btn-sm btn-light" id="button4" onclick="showTab(4)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab5">
                        <h3 class="text-center">Article 4</h3>
                        <p style="text-decoration: underline;" class="text-center">Duties, Responsibilities and Outside Activities</p>
                        <div class="row">
                            <p>The Employee agrees that, during the Term of this Agreement, Employee shall not, directly or indirectly, own, operate, be employed by, be a director of, act as a consultant for, be associated with, be a partner of, or have a proprietary interest in, any enterprise, partnership, association, corporation, joint venture or other entity, which is competitive with the business of the Company, is in the business of computer consulting services, or is determined by the Company to be detrimental to the Company. Employee shall render such services as are assigned by the Company to or on behalf of the Company’s Clients. The Company shall have the right to determine the hours during which the Employee shall perform the Employee’s duties. The Employee acknowledges and agrees to work anywhere in the United States as assigned by the Company and agrees to reasonably cooperate in executing all documents and instructions about obtaining such assignments. The Employee may not use the Company’s (or Client’s) name, facilities, resources or equipment for purposes other than about Employee’s obligations pursuant to this Agreement.</p>
                        </div>
                        <input type="checkbox" name="checkbox5" id="checkbox5" required> I have read and understood above terms and conditions.

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev4" onclick="showPrevTab(4)">Previous</button>
                            <button class="btn btn-sm btn-light" id="button5" onclick="showTab(5)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab6">
                        <h3 class="text-center">Article 5</h3>
                        <p style="text-decoration: underline;" class="text-center">Non-Competition and Non- Solicitation</p>
                        <div class="row">
                            <p><b><u>5.01</u></b> Non-Competition. The Employee agrees that during the Term of this Agreement and for a period of one (1) year
                            thereafter, the Employee shall not directly or indirectly, on behalf of any individual or entity, be employed or engaged
                            by any Company Client, vendor, end-client, any entity introduced to the Employee by the Company or any entity to
                            which the Employee provided services in accordance with Employee’s obligations under thisAgreement.</p>

                            <p><b><u>5.02</u></b> Non-Solicitation. The Employee agrees that during the Term of this Agreement, except to provide services on behalf of the Company, and for a period of Two (2) year thereafter, the Employee shall not, directly or indirectly, solicit, accept, engage, divert or otherwise take away from the Company any business and/or consulting contracts, or contact any Company client, customer, vendor, end-client, supplier, employee, consultant, candidate or prospect for employment or engagement. Employee further agrees that during the Term of the Agreement and for a period of one (1) year thereafter, Employee shall not, directly or indirectly, induce or attempt to influence any Company client, end-client, customer, employee, consultant, contractor, vendor, supplier, candidate or prospect of the Company to terminate his or her employment, contract or business relationship with the Company, or, directly or indirectly, solicit or divert from the Company any such individual.</p>

                            <p><b><u>5.03</u></b> Remedies and Damages. In the event of a breach of Articles 5.01 and/or 5.02, the Employee agrees that the Company will be irreparably harmed, entitling the Company to injunctive relief in addition to any monetarydamages as allowed by law. Employee consents to the entry of an injunction in the event of a breach of this provision, prohibiting a continued breach.</p>
                            <p><b>Notices:</b></p>
                            <p>Any and all notices or other communications required or permitted by this Agreement shall be in writing and shall be deemed delivered when personally delivered to the party to whom it is addressed, or in lieu of such personal service, seventy-two (72) hours after deposit in the United States mail first-class, postage prepaid, addressed to such party at the appropriate address set forth below the signature block of this Agreement. Either party may change its address for the purpose of this paragraph by giving written notice of such change to the other</p>
                            <p><b>Entire Agreement:</b></p>
                            <p>This document constitutes the entire Agreement of the parties and expressly supersedes any oral or written agreements, negotiations, promises or representations between the parties up to and including the date of execution. This Agreement may be modified only in writing; any such modification being signed by authorized representatives of both parties.</p>
                            <p><b>Governing Law:</b></p>
                            <p>This Agreement and its validity, interpretation and performance will take effect and be governed under the laws of the State of Indiana. Venue in any action in law or equity arising from the terms and conditions of this Agreement shall be the court of appropriate jurisdiction in the State of Indiana.</p>
                            <p><b>Attorney’s Fees:</b></p>
                            <p>In any action to enforce this Agreement, the prevailing party shall be entitled to recover all court costs and expenses and reasonable attorney’s fee, in addition to any other relief to which it may be entitled. IN WITNESS WHEREOF, R10 Networks Inc has executed this Agreement on 6/4/2018.</p>
                        </div>
                        <input type="checkbox" name="checkbox6" id="checkbox6" required> I have read and understood above terms and conditions.

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev5" onclick="showPrevTab(5)">Previous</button>
                            <button class="btn btn-sm btn-light" id="button6" onclick="showTab(6)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab7">
                        <h3 class="text-center">Article 6</h3>
                        <p style="text-decoration: underline;" class="text-center">Confidentiality</p>
                        <div class="row">
                            <p><b><u>6.01</u></b> Information Concerning this Agreement. The Employee agrees that the Employee shall not disclose any of the terms or provisions of this Agreement to third parties without the prior written consent of theCompany.</p>
                            <p><b><u>6.02</u></b> Confidential and Proprietary Information. The Employee acknowledges that, during the Employee’s service to the Company, the Employee has and/or will have access to and contact with Confidential Information. As used in this Agreement, the term “Confidential Information” means and includes any and all confidential and proprietary information concerning the business and affairs of the Company and its Clients including, but not limited to, trade secrets, product specifications, design specifications, intellectual property, data, know-how, formulae, compositions, processes, designs, sketches, photographs, graphs, drawings, samples, inventions, ideas, techniques, concepts, research and development, current and planned manufacturing or distribution methods and processes, customer lists, current and anticipated customer requirements, price lists, vendors, suppliers, market studies, business plans, projects, computer software, computer programs and database technologies, systems, structures and architectures (and related processes, formulae, composition, improvements, devices, know-how, inventions, discoveries, concepts, ideas, designs, methods and information), financial records, financial statements, financial projections and budgets, projected sales, capital spending budgets and plans, quality assurance, data and information concerning personnel (including compensation arrangements), personnel training techniques and materials, and any operational information that may provide the Company a competitive advantage, however documented, that has been or may hereafter be provided or shown to the Employee, or is otherwise obtained from review of documents or discussions irrespective of the form of the communication, and also includes all notes, analyses, compilations, studies, summaries and other material prepared by the Employee containing or based, in whole or in part, on any information included in the foregoing. Employee understands that all such Confidential Information is owned by and belongs to Company and/or its Clients. The Employee will not, directly or indirectly, disclose any Confidential Information to others or use such Confidential Information for any purpose unrelated to the business of the Company either during or after the termination of this Agreement. Employee understands that the failure to adhere to this Agreement may subject Employee to disciplinary action, up to an including, immediate termination of employment, as well as civil sanctions and/or criminal penalties. In the event of the Employee’s termination by the Company, the Employee shall
                            return within twenty-four (24) hours of the Employee’s termination all Confidential Information in the Employee’s possession, custody or control. </p>

                            <p><b><u>6.03</u></b> Remedies. In the event of a breach of Articles 6.01 and/or 6.02, Employee agrees that the Company will be irreparably harmed entitling the Company to injunctive relief in addition to any monetary damages, and Employee consents to the entry of an injunction prohibiting a continued breach.</p>
                        </div>
                        <input type="checkbox" name="checkbox7" id="checkbox7" required> I have read and understood above terms and conditions.

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev6" onclick="showPrevTab(6)">Previous</button>
                            <button class="btn btn-sm btn-light" id="button7" onclick="showTab(7)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab8">
                        <h3 class="text-center">Article 7</h3>
                        <p style="text-decoration: underline;" class="text-center">Ownership of Intellectual Property</p>
                        <div class="row">
                            <p><b><u>7.01</u></b> Assignment of Intellectual Property. Employee agrees that Employee will promptly make full written disclosure to the Company and any entity Employee provides services for, directly or indirectly, under this Agreement (collectively referred in this Article as “Company”) and hold in trust for the sole right and benefit of the Company, and hereby assigns to the Company, or its designee, all of Employee’s right, title and interest throughout the world in and to any and all inventions, original works of authorship, developments, concepts, know-how, improvements or trade secrets, whether or not patentable or registrable under copyright or similar laws, which Employee may solely or jointly conceive, develop or reduce to practice, or cause to be conceived, developed or reduced to practice during the employment by the Company that (A) relate at the time of conception or development to the actual or demonstrably proposed business or research and development activities of the Company, (B) result from or relate to any work performed for the Company, whether or not during normal business hours, or (C) are developed through the use of Confidential Information, hereinafter referred to as “Inventions.” Employee further acknowledges that all Inventions, original works of authorship, developments, concepts, know-how, improvements or trade secrets which are made by Employee, solely or jointly with others, within the scope of and during the period of employment by the Company are “works made for hire” (to the greatest extent permitted by applicable law) and are compensated according to the Agreement, unless regulated otherwise by law.</p>
                            <p><b><u>7.02</u></b> Patent and Copyright Rights. Employee agrees to assist the Company, or its designee, at the Company’s expense, in every way to secure the Company’s rights in the Inventions and any copyrights thereto in any and all countries, including the disclosure to the Company of all pertinent information and data with respect thereto, the execution of all applications, specifications, oaths, assignments, recordation’s and all other instruments which the Company shall deem necessary in order to apply for, obtain, maintain and transfer such rights and in order to assign and convey to the Company, its successors, assigns and nominees the sole and exclusive rights, title and interest in and to such Inventions, and any copyrights, patents, mask work rights, or other intellectual property rights relating thereto. Employee further agrees that Employee’s obligation to execute or cause to be executed, when it is in Employee’s power to do so, any such instrument or papers shall continue after the termination of this Agreement until the expiration of the last such intellectual property right to expire in any country of the world. If the Company is unable because of Employee’s mental or physical incapacity, or unavailability for any reason, to secure Employee’s signature which is needed to apply for or to pursue any application for any United States or foreign patents or copyright registrations governing Inventions or original works of authorship assigned to the Company, Employee then hereby irrevocably designates and appoints the Company and its duly authorized officers and agents as the Company’s agent and attorney in fact, to act for and on Employee’s behalf to execute and file any such applications and to do all other lawfully permitted acts to further the application for, prosecution, issuance, maintenance or transfer of letters patent or copyright registrations thereon with the same legal force and effect as if originally executed by Employee. Employee hereby waives and irrevocably quit claims to the Company all claims of any nature whatsoever, which Employee now or hereafter has, for infringement of all proprietary rights assigned to the Company.</p>
                        </div>
                        <input type="checkbox" name="checkbox8" id="checkbox8" required> I have read and understood above terms and conditions.

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev7" onclick="showPrevTab(7)">Previous</button>
                            <button class="btn btn-sm btn-light" id="button8" onclick="showTab(8)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab9">
                        <h3 class="text-center">Article 8</h3>
                        <p style="text-decoration: underline;" class="text-center">Miscellaneous</p>
                        <div class="row">
                            <p><b><u>8.01</u></b> Governing Law / Jurisdiction. This Agreement will be governed, construed and enforced by the laws of the State of Indiana, without regard to its conflicts of laws principles. The parties agree that the State of Indiana shall be the exclusive jurisdiction for all disputes and claims between them</p>
                            <p><b><u>8.02</u></b> Non-Assignability of Agreement. This Agreement is personal to Employee, and the Employee shall not have the right to assign any of the Employee’s rights or delegate any of the Employee’s duties in this Agreement without the express written consent of the Company. Any non-consented to assignment or delegation, whether express or implied or by operation of law, shall be void and shall constitute a breach and a default by theEmployee.</p>
                            <p><b><u>8.03</u></b> Non-Disparagement. Employee agrees that the Employee will not make any written and/or oral statement(s) that has, have or may be expected to have the effect of disparaging the Company or its services</p>
                            <p><b><u>8.04</u></b> Waiver of Breach. Neither the failure nor any delay by any party in exercising any right, power or privilege under this Agreement will operate as a waiver of such right, power or privilege.</p>
                            <p><b><u>8.05</u></b> Attorneys’ Fees & Costs. The Employee agrees that if the Employee is held by any court of competent jurisdiction to be in violation, breach or non-performance of any of the terms of this Agreement, then the Employee shall pay all costs of such action or suit, including reasonable attorneys’ fees, of the Company.</p>
                            <p><b><u>8.06</u></b> Waiver of Jury Trial. EACH PARTY WAIVES ALL RIGHTS IT MAY HAVE TO A TRIAL BY JURY OF ANY ISSUE ARISING OUT OF OR INCONNECTION WITH THIS AGREEMENT AND/OR THE EMPLOYMENT RELATIONSHIP BETWEEN THE PARTIES INCLUDING, BUT NOT LIMITED TO, CLAIMS FOR EMPLOYMENT DISCRIMINATION UNDER THE NEW JERSY LAW AGAINST DISCRIMINATION AND ANY FEDERAL ANTI-DISCRIMINATION LAWS.</p>
                            <p><b><u>8.07</u></b> Confidentiality. Employee agrees to keep the terms of this Agreement confidential and not disclose the same to any third parties other than Employee’s accountants, attorneys and family members, except as required by law or as necessary to bring or defend against a claim for enforcement of the terms hereof. The provisions of this section shall survive termination of this Agreement.</p>
                            <p><b><u>8.08</u></b> Severability. The invalidity or unenforceability of any provision of this Agreement shall not affect the validity or enforceability of any other provisions of this Agreement, which shall remain in full force and effect. If any of the provisions of this Agreement are determined to be unenforceable by reason of its extent, duration, scope or otherwise, then the Parties contemplate that the court making such determination shall reduce such extent, duration, scope or other provision and enforce them in their reduced form for all purposes contemplated by this Agreement.</p>
                            <p><b><u>8.09</u></b> Ambiguities. This Agreement was the subject of review by both Parties with full opportunity to consult counsel. Unless otherwise stated herein, any ambiguities herein shall not be interpreted against the interest of the party that drafted the Agreement or the alleged ambiguous provision.</p>
                            <p><b><u>8.10</u></b> Remedies. In the event of a breach of this Agreement, Employee understands and agrees that the Company will be irreparably harmed. In addition to other relief which may be available, the Company shall be entitled to injunctive and other extraordinary relief in order to enforce the Employee’s obligations under this Agreement. Employee agrees not to commence any lawsuit against the Company in connection with this Agreement without first notifying the Company in writing, specifying the nature and basis of the claim(s), and providing the Company with thirty (30) days from such notice to cure any such deficiencies.</p>
                            <p><b><u>8.11</b></u> Entire Agreement. This Agreement contains the entire understanding between the Parties and supersedes, replaces and takes precedence over any prior understanding or oral or written agreement between the Parties respecting the subject matter of this Agreement. There are no representations, agreements, arrangements or understandings, oral or written, between the Parties hereto relating to the subject matter of this Agreement which are not fully expressed herein. No modification, amendment or waiver shall be binding without the prior written consent of the Parties. Each party represents that it has full power and authority to enter into this Agreement and perform its obligations hereunder.</p>
                            <p><b><u>8.12</b></u> Headings. All headings set forth in this Agreement are intended for convenience only and shall not control or affect the meaning, construction or effect of this Agreement.</p>
                        </div>
                        <input type="checkbox" name="checkbox9" id="checkbox9" required> I have read and understood above terms and conditions.

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev8" onclick="showPrevTab(8)">Previous</button>
                            <button class="btn btn-sm btn-light" id="button9" onclick="showTab(9)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab10">
                        <p><b><input type="checkbox" name="checkbox10" id="checkbox10" required> I have read and understood above terms and conditions. I have read and understood above terms and conditions. I Agree to abide by said terms and conditions set forth herein.</b></p>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <small>Name *</small>
                                <input type="text" id="name2" name="name2" value="{{ old('name')}}" class="form-control" required placeholder="Name">
                            </div>
                            <div class="form-group col-md-12">
                                <small>Email *</small>
                                <input type="text" id="email" name="email" value="{{ old('email')}}" class="form-control" required placeholder="Email">
                            </div>
                            <div class="form-group col-md-12">
                                <small>Phone *</small>
                                <input type="text" id="phone" name="phone" value="{{ old('phone')}}" class="form-control" required placeholder="Phone Number">
                            </div>
                            <div class="form-group col-md-12">
                                <small>Last degits of SSN *</small>
                                <input type="text" id="ssn" name="ssn" value="{{ old('ssn')}}" class="form-control" required placeholder="Last degits of SSN">
                            </div>
                            <div class="form-group col-md-12">
                                <small>Address *</small>
                                <input type="textarea" id="address" name="address" value="{{ old('address')}}" class="form-control" required placeholder="Address">
                            </div>
                        </div>

                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev9" onclick="showPrevTab(9)">Previous</button>
                            <button class="btn btn-sm btn-light" id="button10" onclick="showTab(10)">Next</button>
                        </div>
                    </div>

                    <div class="col-md-12" id="tab11">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">                                    
                                    <div class="col-md-12">
                                        {{ isset($student->first_name)?ucwords($student->first_name):"" }}
                                        Digital Signature
                                        {!! Form::text('dsign', null, ['class'=>'form-control', 'placeholder'=>'Enter Name']) !!}
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div id="my_camera"></div>
                                            <br />
                                            <input type=button value="Take Snapshot" onClick="take_snapshot()">
                                            <input type="hidden" name="image" class="image-tag">
                                        </div>
                                        <div class="col-md-6">
                                            <div id="results">Your captured image will appear here...</div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-12">
                                        <label for="">Photo</label>
                                        <input type="file" class="form-control" name="attachment_file" required id="attachment_file">
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row justify-content-md-center">
                            <button class="btn btn-sm btn-light" id="prev10" onclick="showPrevTab(10)">Previous</button>
                            <button class="btn btn-sm btn-light" type="submit" id="buttonSubmit">Submit</button>
                        </div>
                    </div>
                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
    <script>
        $(function() {
            $("#tab2").hide();
            $("#tab3").hide();
            $("#tab4").hide();
            $("#tab5").hide();
            $("#tab6").hide();
            $("#tab7").hide();
            $("#tab8").hide();
            $("#tab9").hide();
            $("#tab10").hide();
            $("#tab11").hide();
        });

        function showTab(tid) {
            var check = $("#checkbox"+tid).prop('checked');
            var nid = +tid + +1;
            if(tid == 4) {
                var name1 = $("#name1").val();
                if(name1 == null || name1 == '') {
                    alert('Please write down your signature in specified column.');
                    return false;
                }
            }
            if(tid == 10) {
                var name2 = $("#name2").val();
                var email = $("#email").val();
                var phone = $("#phone").val();
                var ssn = $("#ssn").val();
                var address = $("#address").val();
                if(name2 == null || name2 == '') {
                    alert('Please fill the form.');
                    return false;
                }
                if(email == null || email == '') {
                    alert('Please fill the form.');
                    return false;
                }
                if(phone == null || phone == '') {
                    alert('Please fill the form.');
                    return false;
                }
                if(ssn == null || ssn == '') {
                    alert('Please fill the form.');
                    return false;
                }
                if(address == null || address == '') {
                    alert('Please fill the form.');
                    return false;
                }
            }
            if(check == true) {
                for (let tab = 1; tab < 12; tab++) {
                    if(tab != nid) {
                        $("#tab"+tab).hide();
                    } else {
                        $("#tab"+tab).show();
                    }
                }
            }else {
                alert('Please confirm!');
            }
        }

        function showPrevTab(tid) {
            for (let tab = 1; tab < 12; tab++) {
                $("#tab"+tab).hide();
            }
                $("#tab"+tid).show();
        }
        

        Webcam.set({
            width: 490,
            height: 390,
            image_format: 'jpeg',
            jpeg_quality: 90
        });
    
        Webcam.attach( '#my_camera' );
    
        function take_snapshot() {
            Webcam.snap( function(data_uri) {
                $(".image-tag").val(data_uri);
                document.getElementById('results').innerHTML = '<img src="'+data_uri+'"/>';
            } );
        }
    </script>
</body>

</html>