@extends('layouts.default')
@section('title', 'Create agreement')
@section('header-links')
    @include('includes.headers.agreements')
@endsection
@section('new_button')
        <a href="{{ url('/agreements') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">list</i>Agreement list</a>
@endsection
@section('content')
<div class="card">
    {{ Form::open(['url'=>'agreements', 'method'=>'POST', 'data-toggle'=>'validator', 'role'=>'form', 'files'=>'true']) }}
    <div class="row">
        <div class="col-md-6">
            {{ Form::textGroup('name', 'Agreement name', null, ['id'=>'agreement_name', 'required'=>'required']) }}
        </div>
        <div class="col-md-3">
            <label for="">Select PDF</label>
            {{ Form::file('agreement') }}
        </div>
        <div class="col-md-3">
            {{ Form::saveButton('Save') }}
        </div>
    </div>
    {{-- <div class="row m-0">
        <div class="form-group">
            <label for="">Page Header</label>
            <textarea name="header" id="header" rows="10"></textarea>
        </div>
    </div>
    <div class="row m-0">
        <div class="form-group">
            <label for="">Page Footer</label>
            <textarea name="footer" id="footer" rows="10"></textarea>
        </div>
    </div>
    <div class="row m-0">
        <div class="form-group">
            <div class="form-label form-label2">Agreement pages</div>
            @for($i=1; $i < 16; $i++)
            <div class="editor" id="div{{ $i }}">
                <textarea name="pages[]" id="{{ 'page'.$i }}" rows="10"></textarea>
            </div>
            @endfor
        </div>
    </div>
    <div class="row m-0">
        <div class="form-group">
            <h4>Agreement pages</h4>
             <div class="pagination">
            <button type="button" class="page-link waves-effect waves-gray page-btn" value="1" id="btn-first">1</button>
            @for($i=2; $i < 16; $i++)
            <button type="button" class="page-link waves-effect waves-gray page-btn" value="{{ $i }}">{{ $i }}</button>
            @endfor
        </div>
        </div>
    </div> --}}
    {{ Form::close() }}
</div>
{{-- CKEDITOR --}}
<script src="//cdn.ckeditor.com/4.8.0/full-all/ckeditor.js"></script>
<script>
    $(document).ready(function(){
        $(".editor").hide();

        /*Header*/
        CKEDITOR.replace(header, {toolbarGroups: [ { name: 'document', groups: [ 'mode', 'document' ] }, { name: 'clipboard', groups: [ 'clipboard',
        'undo' ] }, { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] }, { name: 'links' } ]});

        CKEDITOR.replace(footer, {toolbarGroups: [ { name: 'document', groups: [ 'mode', 'document' ] }, { name: 'clipboard', groups: [ 'clipboard',
        'undo' ] }, { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] }, { name: 'links' } ]});
    
        for (i = 1; i < 16; i++) {
            var a = "page"+i;
            CKEDITOR.replace(a, {toolbarGroups: [ { name: 'document', groups: [ 'mode', 'document' ] }, { name: 'clipboard', groups: [ 'clipboard', 'undo' ] }, { name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] }, { name: 'links' } ]});
        }
    
        $("#div1").show();
        $("#btn-first").css({"background-color": "#563D7C", "color":"#FFFFFF"});
    });
    
    $(".page-btn").on('click', function(){
        var id = $(this).val();
        var hide_div = 'div'+id;
    
        $(".editor").hide();
        $("#"+hide_div+"").show();
    
        $(".page-btn").css({"background-color": "#DDDDDD", "color":"#2A3F54"});
        $(this).css({"background-color": "#563D7C", "color":"#FFFFFF"});
    });
</script>
@stop