@extends('layouts.default')

@section('title', trans('general.general'))

@section('content')
   
    {!! Form::model($setting, [
            'method' => 'PATCH',
            'url' => ['settings/ac_settings'],
            'class' => 'setting-form',
            'files' => true,
            'role' => 'form'
        ]) !!}

        {{ Form::hidden('company_id', Session::get('company_id')) }}
        <div>
            <div class="pmd-tabs pmd-tabs-bg horizantTabs">
                <ul role="tablist" class="nav nav-tabs secondarySubMeu inner-submenu" id="myTab">
                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray active" data-toggle="tab" href="#company" role="tab">
                         <!--    <span class="hTabsIcon">
                                <i class="material-icons ">star</i></span>  -->
                               {{ trans_choice('general.companies', 1) }}
                        </a>
                    </li>

                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray" data-toggle="tab" href="#localisation" role="tab">
                            <!-- <span class="hTabsIcon"><i class="material-icons ">star</i></span> --> 
                            Date Settings
                        </a> 
                    </li>

                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray" data-toggle="tab" href="#invoice" role="tab">
                            <!-- <span class="hTabsIcon"><i class="material-icons ">star</i></span> --> 
                            {{ trans('settings.invoice.tab') }}
                        </a> 
                    </li>

                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray" data-toggle="tab" href="#default" role="tab">
                            <!-- <span class="hTabsIcon"><i class="material-icons ">star</i></span> --> 
                            {{ trans('settings.default.tab') }}
                        </a> 
                    </li>

                    <li class="nav-item"> 
                        <a class="nav-link waves-effect waves-gray" data-toggle="tab" href="#scheduling" role="tab">
                            <!-- <span class="hTabsIcon"><i class="material-icons ">star</i></span> --> 
                           {{ trans('settings.scheduling.tab') }}
                        </a> 
                    </li>
                </ul>
            </div>
            <div class="pmd-card-body horizantTabsBodyContainer"> 
                <div class="tab-content">
                    <div class="tab-pane tab-margin active" id="company">
                        <div class="row">
                            <div class="col-md-4">
                                {{ Form::textGroup('company_name', trans('settings.company.name'),null) }}
                            </div>
                            <div class="col-md-4">
                                {{ Form::textGroup('company_email', trans('settings.company.email'), null) }}
                            </div>
                            <div class="col-md-4">
                                {{ Form::textGroup('company_phone', trans('settings.company.phone'), null, []) }}
                            </div>
                            <div class="col-md-12">
                                {{ Form::textareaGroup('company_address', trans('settings.company.address'), null) }}
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane tab-margin"  id="localisation">
                        <div class="row">
                            <div class="col-md-4">
                                {{ Form::selectGroup('date_format', trans('settings.localisation.date.format'), $date_formats, null, []) }}
                            </div>
                            <div class="col-md-4">
                                {{ Form::selectGroup('date_separator', trans('settings.localisation.date.separator'), $date_separators, null, []) }}
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane tab-margin" id="invoice">
                        <div class="row">
                            <div class="col-md-4">
                                {{ Form::textGroup('invoice_number_prefix', trans('settings.invoice.prefix'), null, []) }}
                            </div>
                            <div class="col-md-4">
                                {{ Form::textGroup('invoice_number_digit', trans('settings.invoice.digit'), null, []) }}
                            </div>
                            <div class="col-md-4">
                                {{ Form::textGroup('invoice_number_next', trans('settings.invoice.next'), null, []) }}
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane tab-margin" id="default">
                        <div class="row">
                            <div class="col-md-4">
                                {{ Form::selectGroup('default_account', trans('settings.default.account'), $accounts, null, []) }}
                            </div>
                            <div class="col-md-4">
                                {{ Form::selectGroup('default_currency', trans('settings.default.currency'), $currencies, null, []) }}
                            </div>
                            <div class="col-md-4">
                                {{ Form::selectGroup('default_payment_method', trans('settings.default.payment'), $payment_methods, setting('general.default_payment_method'), []) }}
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane tab-margin" id="scheduling">
                        <div class="row">
                            <div class="col-md-3">
                                {{ Form::radioGroup('send_invoice_reminder', trans('settings.scheduling.send_invoice')) }}
                            </div>
                            <div class="col-md-3">
                                {{ Form::textGroup('schedule_invoice_days', trans('settings.scheduling.invoice_days'), null) }}
                            </div>
                            <div class="col-md-3">
                                {{ Form::textGroup('schedule_time', trans('settings.scheduling.schedule_time'), null, []) }}
                            </div>
                            <div class="col-md-3">
                                {{ Form::textGroup('schedule_bill_days', trans('settings.scheduling.bill_days'), null, []) }}
                            </div>
                        </div>
                    </div>

                    <div class="setting-buttons text-center">
                        <div class="col-md-3 form-group no-margin text-right">
                            {!! Form::saveButton('Update') !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>
   {!! Form::close() !!}  

    <script type="text/javascript">
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

    </script>
    <script type="text/javascript">
    $(document).ready(function(){
        $('a[data-toggle="tab"]').on('show.bs.tab', function(e) {
            localStorage.setItem('activeTab', $(e.target).attr('href'));
        });
        var activeTab = localStorage.getItem('activeTab');
        if(activeTab){
            $('#myTab a[href="' + activeTab'"]').tab('show');
        }
    });
    </script>
@endsection
