@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.salesbyproductservicesummary')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
	.red-text {
		color: red;
	}
</style>
<!-- Default box -->
<div class="box box-success">
 <div class="card">
  <div class="box-header">
    
      {!! Form::open(['url'=>'/reports/standard/sales-product-summary']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
	<div class="box-body">
		<div class="col-md-12 col-sm-12 col-xs-12">
			<h3 class="text-center"><strong>{{ trans('reports.standard.salesbyproductservicesummary') }}</strong></h3>
		</div>

		<div class="table-responsive">
			<table class="table table-bordered table-hover">
				<thead>
					<tr>
						<th>PRODUCT/SERVICE</th>
						<th>QUANTITY</th>
						<th>AMOUNT</th>
						<th>% OF SALES</th>
						<th>AVG PRICE</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($list as $li)
						@if($li->quantitysum != 0)
							@php
								$amount = ($li->quantitysum) * $li->sale_price;
							@endphp
							<tr>
								<td>{{ ucwords($li->name) }}</td>
								<td>{{ $li->quantitysum }}</td>
								<td>{{ $amount }}</td>
								<td>{{ ($amount != 0)?round((($amount)/($total))*100):0 }} %</td>
								@if($li->quantitysum != 0)
								<td>{{ $amount / $li->quantitysum }}</td>
								@else
								<td>{{ $amount }}</td>
								@endif
							</tr>
						@endif
					@endforeach
					<tr style="font-weight: bold;">
						<td colspan="2">TOTAL</td>
						<td>@money($total, 'USD', true)</td>
						<td colspan="2">100 %</td>
					</tr>
				</tbody>
			</table>
		</div>
				
	</div>
</div>
  
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection