@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.salesbycustomersummary')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
	.red-text {
		color: red;
	}

	.no-margin{		
		margin-top: 0px;
		margin-bottom: 0px;
	}
	.divPadd {	
	padding-top: 1%;
	padding-bottom: 1%;
	}
	.text-bold {
	font-weight: bold;
	background-color: #ffffff;
	}
</style>
<!-- Default box -->
<div class="box box-success">
  <div class="card">
  <div class="box-header">
   
      {!! Form::open(['url'=>'/reports/standard/sales-customer-summary']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
	<div class="box-body">
		<div class="col-md-12 col-sm-12 col-xs-12">
			<h3 class="text-center">ASAS <strong>{{ trans('reports.standard.salesbycustomersummary') }}</strong></h3>
			
		</div>

		<div class="col-md-12">
			<div class="nav-tabs-custom">
				<div class="tab-content">
					<div class="row">
						<div class="col-md-6"></div>
						<div class="col-md-6"><strong>TOTAL</strong></div>
					</div>
					{{ Tree($items) }}
					
	                @php 
	                  $gtotal = 0;
	                    function Tree($elements, $prefix = 10) {
	                      global $gtotal;
	                      
	                        foreach ($elements as $k=> $element) { 
	                        		if(!empty($element['invoices_total'])){
	                        			$invoiceTotal = $element['invoices_total'][0]['total_amount'];
	                        		}else {
	                        			$invoiceTotal = 0;	                        			
	                        		}
	                              $gtotal = $gtotal + $invoiceTotal;

					@endphp
								<div class="divPadd">
									<div class="row">
										<div class="col-md-6 pull-left" style="padding-left:{{$prefix}}px">{{ $element['name'] }}</div>
										<div class="col-md-6 pull-right">@money($invoiceTotal,'USD', true)</div>
									</div>
								</div>

	                              @if (isset($element['children']))
	                                  @php 
	                                    Tree($element['children'], $prefix+20 );  
	                                  @endphp
	                              @endif
	                        
	                              @if($element['parent_id'] == NULL)
									<hr class="no-margin">
									<div class="divPadd">
										<div class="row text-bold">
											<div class="col-md-6 pull-left">Total {{ $element['name'] }}</div>
											<div class="col-md-6 pull-right">@money($gtotal,'USD', true)</div>
										</div>
        							</div>
                        			<hr class="no-margin">
	                                @php
	                                  $gtotal = 0;
	                                @endphp
	                              @endif
	                @php  
	                        } 

	                    }
	                @endphp
				</div>
			</div>
		</div>
	</div>
</div>
  
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection