@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.productservicelist')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
	.red-text { color: red; }
</style>
<!-- Default box -->
<div class="box box-success">
	<div class="card">
      	<div class="box-header">    
      	{!! Form::open(['url'=>'/reports/standard/product-service']) !!}
      		@include('accounts.reports.standard.date-filter-view')
      	{!! Form::close() !!}
    	</div>
  	</div>
	<div class="box-body">
		<div class="col-md-12 col-sm-12 col-xs-12">
			<h3 class="text-center"><strong>{{ trans('reports.standard.productservicelist') }}</strong></h3>			
		</div>
		<div class="table-responsive">
			<table class="table table-bordered table-hover">
				<thead>
					<tr>
						<th>PRODUCT/SERVICE</th>
						<th>TYPE</th>
						<th>DESCRIPTION</th>
						<th>PRICE</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($list as $li)
						<tr>
							<td>{{ ucwords($li->name) }}</td>
							<td>{{ $sourceTypes[$li->source_type] }}</td>
							<td>{{ ucfirst(Str::limit($li->description, 15)) }}</td>
							<td>@money($li->sale_price, 'USD', true)</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
  
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection