@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.depositdetail')]))

@section('content')
<style>
  .red-text {
    color: red;
  }
  .table-show tbody {
    height: auto !important;
  }
</style>
<!-- Default box -->
<div class="box box-success">
  <div class="card">
    {!! Form::open(['url'=>'/reports/standard/deposit-details']) !!}
    @include('accounts.reports.standard.date-filter-view')
    {!! Form::close() !!}
  </div>
  <div class="box-body">
    <div class="col-md-12 col-sm-12 col-xs-12">
      <h3 class="text-center"><strong>{{ trans('reports.standard.depositdetail') }}</strong></h3>    
    </div>

    <div class="table-responsive">
      <table class="table table-bordered table-hover">
        <thead>
          <tr>
            <th>DATE</th>
            <th>TRANSACTION TYPE</th>
            <th>NUM</th>
            <th>CUSTOMER</th>
            <th>VENDOR</th>
            <th>MEMO/DESCRIPTION</th>
            <th>CLR</th>
            <th>AMOUNT</th>
          </tr>
        </thead>
      </table>

      @foreach($list as $bank)
        @php
          $chats = $bank->chartofhistory;
        @endphp
        @if(count($chats)>0)
        <p><a class="profit-link" data-toggle="collapse" href="#bank{{ $bank->id }}" role="button" aria-expanded="false" aria-controls="bank{{ $bank->id }}"><i class="material-icons">keyboard_arrow_down</i>{{ $bank->name }}</a></p>
        <div class="collapse first-step show" id="bank{{ $bank->id }}">
          <div class="inner-accord">
            <table class="table table-show table-striped table-hover table-bordered " id="">
              <tbody>
                @foreach ($chats as $item)
                <tr>
                  <td>{{ Carbon::parse($item->created_at)->format($date_format) }}</td>
                  <td>Deposite</td>
                  <td>{{ $item->number }}</td>
                  <td>{{ $item->name }}</td>
                  <td></td>
                  <td>{{ $item->description }}</td>
                  <td></td>
                  <td>@money($item->amount, 'USD', true)</td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
        @endif
      @endforeach
      
    </div>
  </div>
</div>
  
  
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection