@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.customercontactlist')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
	.red-text {
		color: red;
	}
</style>
<!-- Default box -->
<div class="box box-success">
 <div class="card">
  <div class="box-header">
   
      {!! Form::open(['url'=>'/reports/standard/customer-contact-list']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
	<div class="box-body">
		<div class="col-md-12 col-sm-12">
			<h3 class="text-center">ASA <strong>{{ trans('reports.standard.customercontactlist') }}</strong></h3>
			
		</div>
               <table class="table table-bordered table-striped">
							<thead>
								<tr>
									<th>CUSTOMER</th>
									<th>PHONE</th>
									<th>EMAIL</th>
									<th>FULL NAME</th>
									<th>BILLING ADDRESS</th>
									<th>SHPPING ADDRESS</th>
								</tr>
							</thead>
							<tbody>
								{{ Tree($items) }}

				                @php 
				                  $gname = '';
				                    function Tree($elements, $prefix = 10) {
				                      global $gname;
				                      
				                        foreach ($elements as $k=> $element) { 
				                        	$gname = ($gname!=NULL)?($gname.':'.$element['name']):$element['name'];
				                @endphp
			                              	<tr>
				                                <td data-toggle="tooltip" title="{{ $gname }}">
				                                  <a href="{{ url('incomes/customers/' . $element['id']) }}">
				                                  {{ Str::limit($gname, 15) }} </a>				                                    
				                                </td>
				                                <td>{{ $element['phone'] }}</td>
				                                <td>{{ $element['customer_email'] }}</td>
				                                <td>{{ '' }}</td>
				                                <td data-toggle="tooltip" title="{{ $element['address'] }}">{{ Str::limit($element['address'], 20) }}</td>
				                                <td data-toggle="tooltip" title="{{ $element['shipping_address'] }}">{{ Str::limit($element['shipping_address'], 20) }}</td>
			                              	</tr>

			                              	@if (isset($element['children']))
			                                  	@php 
			                                    	Tree($element['children'], $prefix+20 );  
			                                  	@endphp
			                                @else
			                                	@php
			                                		$ltstname = explode(':', $gname);
				                        			array_pop($ltstname);
				                        			$gname = implode(':', $ltstname);
			                                	@endphp
			                              	@endif

			                              	@if($element['parent_id'] == NULL)
		                              			@php $gname = ''; @endphp
		                              		@endif
				                @php  
				                        } 

				                        $ltstname = explode(':', $gname);
				                        array_pop($ltstname);
				                        $gname = implode(':', $ltstname);
				                    }
				                @endphp
							</tbody>
						</table>
					</div>
    </div>

@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection