use Carbon\Carbon;
@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.openinvoices')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
  .no-margin {
    margin: 0px;
  }
  .table-show tbody {
  height: auto !important;
  }
</style>
  
<div class="box box-success">
  <div class="card">
  <div class="box-header">
    
      {!! Form::open(['url'=>'/reports/standard/open-invoices']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>

 <div class="box-body">
  <div class="col-md-12 col-sm-12 col-xs-12">
      <h3 class="text-center">ASAS <strong>{{ trans('reports.standard.openinvoices') }}</strong></h3>
      <hr>
  </div>
  <table id="fullFeatures" class="table table-bordered table-striped">
    <thead>
      <tr>
        <th>DATE</th>
        <th>TRANSACTION TYPE</th>
        <th>NUM</th>
        <th>TERMS</th>          
        <th>DUE DATE</th>
        <th>OPEN BALANCE</th>
      </tr>
    </thead>
  </table>
  @foreach ($list as $customer)
    @php
    $invoices = $customer->invoices;
    @endphp
    @if(count($invoices)>0)
    <p><a class="profit-link" data-toggle="collapse" href="#customer{{ $customer->id }}" role="button" aria-expanded="false" aria-controls="customer{{ $customer->id }}"><i class="material-icons">keyboard_arrow_down</i>{{ $customer->name }}</a></p>
    <div class="collapse first-step show" id="customer{{ $customer->id }}">
      <div class="inner-accord">
        <table id="fullFeatures" class="table table-bordered table-striped">
          <tbody>
            @php
                $total = 0;
            @endphp
            @foreach ($invoices as $invoice)
              @php
                  $ptm = $invoice->payments_total;
                  $ptl = isset($ptm->paid_amount)?$ptm->paid_amount:0;
                  $bal = $invoice->amount - $ptl;
                  $total = $total + $bal;
              @endphp
              <tr>
                <td>{{ Carbon\Carbon::parse($invoice->invoiced_at)->format($date_format) }}</td>
                <td>Invoice</td>
                <td>{{ $invoice->invoice_number }}</td>
                <td></td>
                <td>{{ Carbon\Carbon::parse($invoice->due_at)->format($date_format) }}</td>
                <td>@money($bal, 'USD', true)</td>
              </tr>           
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
    {{-- INCOME TOTAL --}}
    <table class="table table-show table-striped table-hover table-bordered table-responsive">
      <tbody>
        <tr>
          <td colspan="5">Income Total</td>
          <td>@money($total, 'USD', true)</td>
        </tr>
      </tbody>
    </table>
    @endif
    @php
        $total = 0;
    @endphp
  @endforeach

</div>
</div>
<!-- /.box -->
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection