@extends('layouts.default')
@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.invoicesandreceivedpayments')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
.text-bold {
  font-weight: bold;
}
</style>
<div class="box box-success">
  <div class="card">
    <div class="box-header">
      {!! Form::open(['url'=>'/reports/standard/invoice-recieve-payments']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
  <div class="box-body">
    <div class="col-md-12 col-sm-12 col-xs-12">
      <h3 class="text-center">ASAS <strong>{{ trans('reports.standard.invoicesandreceivedpayments') }}</strong></h3>
      <hr>
    </div>
    <table id="fullFeatures" class="table table-bordered table-striped">
      <thead>
        <tr>
          <th>DATE</th>
          <th>TRANSACTION TYPE</th>
          <th>MEMO/DESCRIPTION</th>
          <th>NUM</th>
          <th>AMOUNT</th>
        </tr>
      </thead>
    </table>

    @foreach ($list as $customer)
      <p><a class="profit-link" data-toggle="collapse" href="#customer{{ $customer->id }}" role="button" aria-expanded="false"
            aria-controls="customer{{ $customer->id }}"><i class="material-icons">keyboard_arrow_down</i>{{ $customer->name }}</a></p>
      @php
          $invoices = $customer->invoices;
      @endphp
      <div class="collapse first-step show" id="customer{{ $customer->id }}">
        <div class="inner-accord">
          <table id="fullFeatures" class="table table-bordered table-striped">
            <tbody>
              @foreach ($invoices as $invoice)
                @php
                    $payments = $invoice->payments;
                @endphp
                <tr>
                  <td>{{ Carbon\Carbon::parse($invoice->invoiced_at)->format($date_format) }}</td>
                  <td>Invoice</td>
                  <td></td>
                  <td>{{ $invoice->invoice_number }}</td>
                  <td>@money($invoice->amount)</td>
                </tr>
                @foreach ($payments as $payment)
                    <tr class="text-bold">
                      <td>{{ Carbon\Carbon::parse($payment->paid_at)->format($date_format) }}</td>
                      <td>Payment</td>
                      <td>{{ $payment->description }}</td>
                      <td></td>
                      <td>@money($payment->amount)</td>
                    </tr>
                @endforeach              
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    @endforeach
  </div>
</div>
<!-- /.box -->
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection