@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.invoicelist')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
  
<div class="box box-success">
  <div class="card">
  <div class="box-header">
   
      {!! Form::open(['url'=>'/reports/standard/invoice-list']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
  <div class="box-body">
  	<div class="col-md-12">
  		<h3 class="text-center">ASAS  <strong>{{ trans('reports.standard.invoicelist') }}</strong></h3>
  		
  	</div>

    <div class="table-responsive">
      <table class="table table-bordered table-hover">
        <thead>
          <tr>
            <th>DATE</th>
            <th>TRANSACTION TYPE</th>
            <th>NUM</th>
            <th>NAME</th>
            <th>MEMO/DESCRIPTION</th>
            <th>DUE DATE</th>
            <th>AMOUNT</th>
            <th>OPEN BALANCE</th>
          </tr>
        </thead>
        <tbody>
          @foreach($list as $li)
          <tr>
            <td>{{ Date::parse($li->invoiced_at)->format($date_format) }}</td>
            <td>{{ __('Invoice') }}</td>
            <td>{{ $li->invoice_number }}</td>
            <td>{{ ucwords($li->customer_name) }}</td>
            <td>{{ __($li->notes) }}</td>
            <td>{{ Date::parse($li->due_at)->format($date_format) }}</td>
            <td>@money(($li->amount), 'USD', true)</td>
            <td>
              @if(count($li->payments_total) > 0)
                  @php
                      $a = isset($li->payments_total->paid_amount)?$li->payments_total->paid_amount:0;
                  @endphp
                @money(($li->amount - $a), 'USD', true)
              @else
                @money(($li->amount - 0), 'USD', true)
              @endif
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>
    </div>
  </div>
  <div class="box-footer">
    
  </div>
  <!-- /.box-body -->
</div>
<!-- /.box -->
  
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection