@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.customerbalancesummary')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
  
<div class="box box-primary">
  <div class="card">
  <div class="box-header">
   
      {!! Form::open(['url'=>'/reports/standard/customer-balance-summary']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
  <div class="box-body">
      <div class="col-md-12">
        <h3 class="text-center">ASAS <strong>{{ trans('reports.standard.customerbalancesummary') }}</strong></h3>
       
      </div>

      <div class="">
          <table class="table  table-hover" id="tbl-customers">
              <thead>
                  <tr>
                      <th class="col-md-2">@sortablelink('name', trans('general.name'))</th>
                      <th class="col-md-1">@sortablelink('blance', trans_choice('general.balance',2))</th>
                  </tr>
              </thead>
              <tbody>  

                {{ Tree($items) }}

                @php 
                  $gtotal = 0;
                    function Tree($elements, $prefix = 10) {
                      global $gtotal;
                      
                        foreach ($elements as $k=> $element) { 
                              $total_amount = 0;
                              $paid_amount = 0;

                              if( count($element['invoices_total']) > 0){
                                $invoice_amount = ($element['invoices_total'])[0]['total_amount'];
                                $paid_amount    =  isset(($element['payments_total'])[0])?($element['payments_total'])[0]['paid_amount']:0;
                                $total_amount = $invoice_amount - $paid_amount ;
                                $gtotal = $gtotal + $total_amount ;
                              }
                @endphp
                              <tr>
                                <td  style = "padding-left:{{$prefix}}px" >
                                  <a href="{{ url('incomes/customers/' . $element['id']) }}">
                                  {{  $element['name'] }} </a>
                                    
                                </td>
                                <td>@money((($total_amount != '')?$total_amount:0), $element['currency_code'], true)</td>
                              </tr>

                              @if (isset($element['children']))
                                  @php 
                                    Tree($element['children'], $prefix+20 );  
                                  @endphp
                              @endif
                        
                              @if($element['parent_id'] == NULL)
                                <tr style="font-weight: bold;">
                                  <td>Total {{ $element['name'] }}</td>
                                  <td>@money((($gtotal != '')?$gtotal:0), $element['currency_code'], true)</td>
                                </tr>
                                @php
                                  $gtotal = 0;
                                @endphp
                              @endif
                @php  
                        } 

                    }
                @endphp
              </tbody>
          </table>
      </div>
  </div>
</div>
  
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection