@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.collectionsreport')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
	.red-text {
		color: red;
	}
	.table-show tbody {
	height: auto !important;
	}
	.first-step {
		padding-left: 1% !important;
	}
</style>
<!-- Default box -->
<div class="box box-success">
	<div class="card">
  <div class="box-header">
   
      {!! Form::open(['url'=>'/reports/standard/collections-reports']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
   
  </div>
</div>
<div class="box-body">
    <div class="col-md-12 col-sm-12 col-xs-12">
	   <h3 class="text-center"><strong>{{ trans('reports.standard.collectionsreport') }}</strong></h3>
	</div>
    <table id="fullFeatures" class="table table-bordered table-show table-striped">
      <thead>
        <tr>
          <th>DATE</th>
          <th>TRANSACTION TYPE</th>
          <th>NUMBER</th>
          <th>DUE DATE</th>
          <th>DAYS ALMOST/<b class="red-text">OVER</b> DUE</th>
          <th>AMOUNT</th>
        </tr>
      </thead>
	</table>
	
	@php
		$gtotal = 0;
	@endphp
	@foreach($customers as $customer)
		@if(count($customer->invoices) > 0)
			<p><a class="profit-link" data-toggle="collapse" href="#customerInvoices{{ $customer->id }}" role="button" aria-expanded="false" aria-controls="innerIncomes{{ $customer->id }}"><i class="material-icons">keyboard_arrow_down</i>{{ $customer->name }}</a></p>
			<div class="collapse first-step show" id="customerInvoices{{ $customer->id }}">
				<div class="inner-accord">
					<table class="table table-show table-striped table-hover table-bordered table-responsive" id="">
						<tbody>
							@php
								$total = 0;
								$invoices = $customer->invoices;
							@endphp
							@foreach ($invoices as $item)
							@php
								$total = $total + $item->amount;
								$start = Carbon\Carbon::now();
								$end = Carbon\Carbon::parse($item->due_at);
								$diff = $start->diffInDays($end);
							@endphp
							<tr>
								<td>{{ Carbon\Carbon::parse($item->invoiced_at)->format($date_format) }}</td>
								<td>Invoice</td>
								<td>{{ $item->invoice_number }}</td>
								<td>{{ Carbon\Carbon::parse($item->due_at)->format($date_format) }}</td>
								<td>{{ $diff }}</td>
								<td>@money($item->amount, 'USD', true)</td>
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			</div>

			<table class="table table-show table-striped table-hover table-bordered table-responsive" id="">
				<tbody>
					<tr class="first-table">
						<td colspan="4">{{ $customer->name }}</td>
						<td>@money($total, 'USD', true)</td>
					</tr>
				</tbody>
			</table>
			@php
				$gtotal = $gtotal + $total;
				$total = 0;
			@endphp
		@endif
	@endforeach
</div>

@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection