@extends('layouts.default')

@section('title', trans_choice('reports.standard.standardreports', 1))

@section('new_button')
{{-- // --}}
@endsection

@section('content')

<div class="box box-success">
    <div class="card">
        {!! Form::open(['url'=>'/reports/standard/accounts-recievables']) !!}
        @include('accounts.reports.standard.date-filter-view')
        {!! Form::close() !!}
    </div>
    <div class="box-header">
        <h3 class="box-title">{{ trans('reports.standard.accountsrecievables') }} Details</h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body">
        <table id="fullFeatures" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>DATE</th>
                    <th>TRANSACTION TYPE</th>
                    <th>NUM</th>
                    <th>CUSTOMER</th>
                    <th>DUE DATE</th>
                    <th>AMOUNT</th>
                    <th>OPEN BALANCE</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $gtotal = 0;
                    $total = 0;
                @endphp
                @foreach ($invoices as $invoice)
                    @php
                        $balance = $invoice->amount - $invoice->invoice->payment_total;
                        $total = $total + $invoice->amount;
                        $gtotal = $gtotal + $invoice->amount;
                    @endphp
                    <tr>
                        <td>{{ Carbon\Carbon::parse($invoice->invoiced_at)->format($date_format) }}</td>
                        <td>Invoice</td>
                        <td>{{ $invoice->number }}</td>
                        <td>{{ $invoice->name }}</td>
                        <td>{{ Carbon\Carbon::parse($invoice->invoice->due_at)->format($date_format) }}</td>
                        <td>@money($invoice->amount, 'USD', true) </td>
                        <td>@money($balance, 'USD', true) </td>
                    </tr>
                @endforeach
                @foreach ($others as $invoice)
                    @php
                        $balance = $invoice->amount;
                        $total = $total + $invoice->amount;
                        $gtotal = $gtotal + $invoice->amount;
                    @endphp
                    <tr>
                        <td>{{ Carbon\Carbon::parse($invoice->created_at)->format($date_format) }}</td>
                        <td>{{ $invoice->transaction_type }}</td>
                        <td>{{ $invoice->number }}</td>
                        <td>{{ $invoice->name }}</td>
                        <td>{{ Carbon\Carbon::parse($invoice->created_at)->format($date_format) }}</td>
                        <td>@money($balance, 'USD', true) </td>
                        <td>@money($balance, 'USD', true) </td>
                    </tr>
                @endforeach
                <tr class="bg-success">
                    <td colspan="5"> <strong>Totals</strong> </td>
                    <td>@money($total, 'USD', true)</td>
                    <td>@money($gtotal, 'USD', true)</td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="box-footer">
    </div>
    <!-- /.box-body -->
</div>
<!-- /.box -->

@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection