@extends('layouts.default')

@section('title', trans_choice('reports.standard.standardreports', 1))


@section('new_button')
{{-- // --}}
@endsection

@section('content')
  
<div class="box box-success">
  <div class="box-header">
    <h3 class="box-title">{{ trans('reports.standard.accountsrecievablesummary') }} Details</h3>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
    <table id="fullFeatures" class="table table-bordered table-show table-striped">
      <thead>
        <tr>
          <th>NAME</th>
          <th>CURRENT</th>
          <th>1 - 30</th>
          <th>31 - 60</th>
          <th>61 - 90</th>
          <th>91 AND OVER</th>
          <th>TOTAL</th>
        </tr>
      </thead>
      <tbody>
        {{ Tree($items) }}

        @php 
          $gtotal = 0;
          $currentTotal = 0;
          $thirtyTotal = 0;
          $sixtyTotal = 0;
          $nintyTotal = 0;
          $overNintyTotal = 0;
            function Tree($elements, $prefix = 10) {
              global $gtotal;
              global $currentTotal;
              global $thirtyTotal;
              global $sixtyTotal;
              global $nintyTotal;
              global $overNintyTotal;
              
                foreach ($elements as $k=> $element) { 
                      $paid_total = 0;
                      $row_total = $element['currentTotal'] + $element['thirtyTotal'] + $element['sixtyTotal'] + $element['nintyTotal'] + $element['overNintyTotal'];
                      $currentTotal = $currentTotal + $element['currentTotal'];
                      $thirtyTotal = $thirtyTotal + $element['thirtyTotal'];
                      $sixtyTotal = $sixtyTotal + $element['sixtyTotal'];
                      $nintyTotal = $nintyTotal + $element['nintyTotal'];
                      $overNintyTotal = $overNintyTotal + $element['overNintyTotal'];
                      $gtotal = $gtotal + $row_total;

        @endphp
                      <tr>
                        <td  style = "padding-left:{{$prefix}}px" >
                          <a href="{{ url('incomes/customers/' . $element['id']) }}">
                          {{  $element['name'] }} </a>
                            
                        </td>
                        <td>@money($element['currentTotal'], 'USD', true)</td>
                        <td>@money($element['thirtyTotal'], 'USD', true)</td>
                        <td>@money($element['sixtyTotal'], 'USD', true)</td>
                        <td>@money($element['nintyTotal'], 'USD', true)</td>
                        <td>@money($element['overNintyTotal'], 'USD', true)</td>
                        <td>@money($row_total, 'USD', true)</td>
                      </tr>

                      @if (isset($element['children']))
                          @php 
                            Tree($element['children'], $prefix+20 );  
                          @endphp
                      @endif
                
                      @if($element['parent_id'] == NULL)
                        <tr style="font-weight: bold;">
                          <td>Total {{ $element['name'] }}</td>
                          <td>@money($currentTotal, 'USD', true)</td>
                          <td>@money($thirtyTotal, 'USD', true)</td>
                          <td>@money($sixtyTotal, 'USD', true)</td>
                          <td>@money($nintyTotal, 'USD', true)</td>
                          <td>@money($overNintyTotal, 'USD', true)</td>
                          <td>@money($gtotal, 'USD', true)</td>
                        </tr>
                        @php
                          $currentTotal = 0;
                          $thirtyTotal = 0;
                          $sixtyTotal = 0;
                          $nintyTotal = 0;
                          $overNintyTotal = 0;
                          $gtotal = 0;
                        @endphp
                      @endif
        @php  
                } 

            }
        @endphp
      </tbody>
    </table>
  </div>
  <div class="box-footer">
  </div>
  <!-- /.box-body -->
</div>
<!-- /.box -->
@include('includes.datepicker')
@endsection