@extends('layouts.default')

@section('title', trans_choice('reports.standard.standardreports', 1))


@section('new_button')
{{-- // --}}
@endsection
<style>
    input[type=submit] {
        color: black;
    }
    .reports{
        border-bottom: 2px solid #e3e5e8;
        padding: 10px 13px;
        line-height: 20px;
    }
    .reports span a {
        color: black;
    }
   .reports span a:hover {
    color: #0056b3;
    text-decoration: underline;
}
</style>

@section('content')
<!-- Default box -->
<div class="row">
    <!-- /.box-header -->
    {{-- Business Overview --}}
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h3 class="box-title">{{ trans('reports.standard.businessoverview') }}</h3>
            </div>
            <div class="card-body">
               
                    <ul  class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/audit-log') }}">{{ trans('reports.standard.auditlog') }}</a>
                        </span>
                    </ul>
                    <ul class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/balance-sheet') }}">{{ trans('reports.standard.balancesheet') }}
                            </a>
                        </span>
                    </ul>
                    <ul class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/balance-sheet-details') }}">{{ trans('reports.standard.balancesheetdetail') }}</a>
                        </span>
                    </ul>                     
                    <ul class="reports">
                        <span class="text"><a href="{{ url('/reports/standard/profit-loss') }}" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.profitandloss') }}</a></span>
                    </ul>
                    <ul class="reports">
                        <span class="text"><a href="{{ url('/reports/standard/profit-loss-details') }}" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.profitandlossdetails') }}</a></span>
                    </ul>
                    {{-- <ul class="reports">                            
                        <span class="text"><a href="javascript::void(0)" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.statementofcashflows') }}</a></span>
                    </ul> --}}
            </div>
        </div>
    </div>
    {{-- End:Business Overview --}}

    {{-- Who owes you --}}
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h3 class="box-title">{{ trans('reports.standard.whoowesyou') }}</h3>
            </div>
            <div class="card-body">
                    <ul class="reports">
                         <span class="text">
                            <a href="{{ url('/reports/standard/accounts-recievables') }}">{{ trans('reports.standard.accountsrecievables') }}</a>
                        </span>
                    </ul>
                    <ul class="reports">
                         <span class="text">
                            <a href="{{ url('/reports/standard/accounts-recievable-summary') }}">{{ trans('reports.standard.accountsrecievablesummary') }}</a>
                        </span>
                    </ul>
                   <ul class="reports">
                        <span class="text">
                             <a href="{{ url('/reports/standard/collections-reports') }}">{{ trans('reports.standard.collectionsreport') }}</a>
                        </span>
                    </ul>
                   <ul class="reports">
                        <span class="text">
                             <a href="{{ url('/reports/standard/customer-balance-summary') }}">{{ trans('reports.standard.customerbalancesummary') }}</a>
                        </span>
                    </ul>
                    <ul class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/invoice-list') }}">{{ trans('reports.standard.invoicelist') }}</a>
                        </span>
                    </ul>
                   <ul class="reports">
                        <span class="text">
                             <a href="{{ url('/reports/standard/invoice-recieve-payments') }}">{{ trans('reports.standard.invoicesandreceivedpayments') }}</a>
                        </span>
                    </ul>
                   <ul class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/open-invoices') }}">{{ trans('reports.standard.openinvoices') }}</a>
                        </span>
                    </ul>
            </div>
            
        </div>
    </div>
    {{-- End:Who owes you --}}

    {{-- Sales and Customers --}}
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h3 class="box-title">{{ trans('reports.standard.salesandcustomer') }}</h3>   
            </div>
            <div class="card-body">               
                    <ul class="reports">
                        <span class="text">
                             <a href="{{ url('/reports/standard/customer-contact-list') }}">{{ trans('reports.standard.customercontactlist') }}</a>
                        </span>
                    </ul>
                    <ul class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/deposit-details') }}">{{ trans('reports.standard.depositdetail') }}</a>
                        </span>
                    </ul>
                    <ul class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/product-service') }}" >{{ trans('reports.standard.productservicelist') }}</a>
                        </span>
                    </ul>
                    <ul class="reports">
                        <span class="text">
                             <a href="{{ url('/reports/standard/sales-customer-summary') }}" >{{ trans('reports.standard.salesbycustomersummary') }}</a>
                        </span>
                    </ul>
                    <ul class="reports">
                        <span class="text">
                             <a href="{{ url('/reports/standard/sales-customer-summary-detail') }}" >{{ trans('reports.standard.salesbycustomersummarydetails') }}</a>
                        </span>
                    </ul>
                    <ul class="reports">
                        <span class="text">
                             <a href="{{ url('/reports/standard/sales-product-summary') }}" >{{ trans('reports.standard.salesbyproductservicesummary') }}</a>
                        </span>
                    </ul>
                </ul>
            </div>
        </div>
    </div>
    {{-- End:Sales and Customers --}}

    {{-- Expenses and Vendors --}}
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h3 class="box-title">{{ trans('reports.standard.expensesandvendors') }}</h3> 
            </div>
            <div class="card-body">
               
                    <ul class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/check-details') }}" >{{ trans('reports.standard.checkdetail') }}</a>

                        </span>
                    </ul>
                    <ul class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/transaction-vendor') }}" >{{ trans('reports.standard.transactionlistbyvendor') }}</a>
                        </span>
                    </ul>
                     <ul class="reports">
                        <span class="text">
                            <a href="{{ url('/reports/standard/vendor-contact-list') }}" >{{trans('reports.standard.vendorcontactlist') }}</a>
                        </span>
                    </ul>
            </div>
            
        </div>
    </div>
    {{-- End:Expenses and Vendors --}}

    {{-- For my accountant --}}
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h3 class="box-title">{{ trans('reports.standard.formyaccountant') }}</h3> 
            </div>
            <div class="">
                <div>
                   
                        <ul class="reports">
                            <span class="text">
                                 <a href="{{ url('/reports/standard/account-list') }}" >{{trans('reports.standard.accountlist') }}</a>
                            </span>
                        </ul>
                        <ul class="reports">
                            <span class="text">
                                <a href="{{ url('/reports/standard/balance-sheet') }}">{{ trans('reports.standard.balancesheet') }}
                                </a>
                            </span>
                        </ul>
                        <ul class="reports">                            
                            <span class="text">
                                <a href="{{ url('/reports/standard/balance-sheet-details') }}">{{ trans('reports.standard.balancesheetdetail') }}</a>
                            </span>
                        </ul>
                        <ul class="reports">                            
                            <span class="text"><a href="{{ url('/reports/standard/general-ledger') }}" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.generalledger') }}</a></span>
                        </ul>
                        <ul class="reports">                            
                            <span class="text"><a href="{{ url('/reports/standard/journal') }}" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.journal') }}</a></span>
                        </ul>                     
                        <ul class="reports">
                            <span class="text"><a href="{{ url('/reports/standard/profit-loss') }}" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.profitandloss') }}</a></span>
                        </ul>
                        <ul class="reports">
                            <span class="text"><a href="{{ url('/reports/standard/profit-loss-details') }}" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.profitandlossdetails') }}</a></span>
                        </ul>
                        <ul class="reports">                            
                            <span class="text"><a href="{{ url('/banking/reconcile') }}" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.reconciliationreports') }}</a></span>
                        </ul>
                        <ul class="reports">
                            <span class="text">
                                <a href="{{ url('/reports/standard/transaction-date') }}" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.recenttransactions') }}</a>
                            </span>
                        </ul>
                        <ul class="reports">                            
                            <span class="text"><a href="{{ url('/reports/standard/trial-balance') }}" data-toggle="tooltip" title="Coming Soon!.">{{ trans('reports.standard.trialbalance') }}</a></span>
                        </ul>
                </div>
            </div>
        </div>
    </div>
    {{-- End:For my accountant --}}
</div>
<!-- /.box -->
@endsection