@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.vendorcontactlist')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
	.red-text {
		color: red;
	}
</style>
<!-- Default box -->
<div class="box box-success">
<div class="card">
  <div class="box-header">
    
      {!! Form::open(['url'=>'/reports/standard/vendor-contact-list']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
	<div class="box-body">
		<div class="col-md-12 col-sm-12 col-xs-12">
			<h3 class="text-center">ASAS <strong>{{ trans('reports.standard.vendorcontactlist') }}</strong> <span>As of {{ Date::parse(date('y-m-d'))->format($date_format) }}</span></h3>
			
		</div>

		<div class="table-responsive">
			<table class="table table-bordered table-hover">
				<thead>
					<tr>
						<th>VENDOR</th>
						<th>PHONE</th>
						<th>EMAIL</th>
						<th>BILLING ADDRESS</th>
						<th>SHPPING ADDRESS</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($list as $li)
						<tr>
							<td>{{ ucwords($li->name) }}</td>
							<td>{{ $li->phone }}</td>
							<td>{{ $li->vendor_email }}</td>
							<td data-toggle="tooltip" title="{{ $li->address }}">{{ ucfirst(Str::limit($li->address, 15)) }}</td>
							<td data-toggle="tooltip" title="{{ $li->shipping_address }}">{{ ucfirst(Str::limit($li->shipping_address, 15)) }}</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
		
</div>
  
@include('accounts.reports.standard.filter')
@endsection