@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.transactionlistbyvendor')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
	.red-text {
		color: red;
	}
</style>
<!-- Default box -->
<div class="box box-success">
 <div class="card">
  <div class="box-header">
   
      {!! Form::open(['url'=>'/reports/standard/transaction-vendor']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
	<div class="box-body">
		<div class="col-md-12">
			<h3 class="text-center">ASAS <strong>{{ trans('reports.standard.transactionlistbyvendor') }}</strong> <span>As of {{ Date::parse(date('y-m-d'))->format($date_format) }}</span></h3>
		
		</div>

		
					<div class="table-responsive">
						<table class="table table-bordered table-hover">
							<thead>
								<tr>
									<th>NAME</th>
									<th>TRANSACTION TYPE</th>
									<th>NUM</th>
									<th>DESCRIPTION</th>
									<th>AMOUNT</th>
								</tr>
							</thead>
							<tbody>
								@foreach ($list as $li)
									@if(count($li->transactions) > 0)
										<tr>
											<th colspan="5">{{ $li->name }}</th>
										</tr>
										@php 
											$gtotal = 0;
										@endphp
										@foreach ($li->transactions as $record)
											@php
												$gtotal = $gtotal + $record->amount;
											@endphp
											<tr>
												<td>{{ Date::parse($record->created_at)->format($date_format) }}</td>
												<td>{{ $record->transaction_type }}</td>
												<td>{{ $record->number }}</td>
												<td>{{ str_limit($record->description, 20) }}</td>
												<td>@money($record->amount, 'USD', true)</td>
											</tr>
										@endforeach	
										<tr>
											<th colspan="4">TOTAL</th>
											<th>@money($gtotal, 'USD', true)</th>
										</tr>	
										@php
											$gtotal = 0;
										@endphp							
									@endif
								@endforeach
							</tbody>
						</table>
					</div>
				</div>
		
</div>
  
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection