@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.checkdetail')]))

@section('content')
<style>
  .red-text {
    color: red;
  }
</style>
<!-- Default box -->
<div class="box box-success">
  <div class="card">
  <div class="box-header">
    
      {!! Form::open(['url'=>'/reports/standard/check-details']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
  <div class="box-body">
    <div class="col-md-12 col-sm-12 col-xs-12">
      <h3 class="text-center"><strong>{{ trans('reports.standard.checkdetail') }}</strong></h3>
    </div>

          <table id="fullFeatures" class="table table-bordered table-striped">
            <thead>
              <tr>
                <th>DATE</th>
                <th>TRANSACTION TYPE</th>
                <th>CLR</th>
                <th>AMOUNT</th>
              </tr>
            </thead>
            <tbody>
              @foreach ($list as $li)
                @if(count($li->chartofhistory) > 0)
                  <tr style="font-weight: bold;">
                    <td colspan="8" onclick="close({{ $li->id }})">- {{ ucwords($li->name) }}</td>
                  </tr>
                  @foreach($li->chartofhistory as $l)
                  <tr>
                    <td style="padding-left: 20px;">{{ Date::parse($l->created_at)->format($date_format) }}</td>
                    <td>{{ __('Check') }}</td>
                    <td></td>
                    <td>@money($l->amount, 'USD', true)</td>
                  </tr>
                  @endforeach
                @endif
              @endforeach
            </tbody>
          </table>
        </div>
     
</div>
  
@include('accounts.reports.standard.filter')

<script>
  function close(id) {
    alert(id);
  }
</script>
@include('includes.datepicker')
@endsection