@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' =>
trans('reports.standard.profitandlossdetails')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
    .red-text {
        color: red;
    }

    .text-right {
        text-align: right;
    }

    .table-show tbody {
        height: auto !important;
    }

    .profit-content {
        display: none;
    }

    .profit-link .material-icons {
        position: relative;
        top: 6px;
    }

    .first-step {
        padding-left: 1% !important;
    }

    .second-step {
        padding-left: 2% !important;
    }
</style>
<!-- Default box -->
<div class="box box-success">
    <div class="card">
        {!! Form::open(['url'=>'/reports/standard/profit-loss-details']) !!}
        @include('accounts.reports.standard.date-filter-view')
        {!! Form::close() !!}
    </div>
    <div class="box-body">
        <div class="row m-0">
            <h3><strong>{{ trans('reports.standard.profitandlossdetails') }}</strong></h3>
        </div>
        <table class="table table-show table-striped table-hover table-bordered " id="">
            <thead>
                <tr>
                    <th>ACCOUNT / DATE</th>
                    <th>TRANSACTION TYPE</th>
                    <th>NUM</th>
                    <th>NAME</th>
                    <th>DESCRIPTION</th>
                    <th>AMOUNT</th>
                </tr>
            </thead>
        </table>
        {{-- INCOMES --}}
        <p><a class="profit-link" data-toggle="collapse" href="#incomes" role="button" aria-expanded="false"
                aria-controls="incomes"><i class="material-icons">keyboard_arrow_down</i>Incomes</a></p>
        <div class="collapse first-step" id="incomes">
            <div class="inner-accord">
                @php
                $incometotal = 0;
                @endphp
                @foreach($incomes as $income)
                    @if(count($income->chartofhistory) > 0)
                        <p><a class="profit-link" data-toggle="collapse" href="#innerIncomes{{ $income->id }}" role="button" aria-expanded="false" aria-controls="innerIncomes{{ $income->id }}"><i class="material-icons">keyboard_arrow_down</i>{{ $income->name }}</a></p>
                        <div class="collapse second-step" id="innerIncomes{{ $income->id }}">
                            <div class="inner-accord">
                                <table class="table table-show table-striped table-hover table-bordered " id="">
                                    <tbody>
                                        @php
                                            $total = 0;
                                            $charts = $income->chartofhistory;
                                        @endphp
                                        @foreach ($charts as $item)
                                        @php
                                            if($item->amount_type == 'add') {
                                                $total = $total + $item->amount;
                                            } else {
                                                $total = $total - $item->amount;
                                            }
                                        @endphp
                                        <tr>
                                            <td>{{ Carbon::parse($item->created_at)->format($date_format) }}</td>
                                            <td>{{ $item->transaction_type }}</td>
                                            <td>{{ $item->number }}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>{{ $item->description }}</td>
                                            <td>{{ ($item->amount_type=='add')?'+':'-' }}@money($item->amount, 'USD', true)</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                <tr class="first-table">
                                    <td colspan="5">{{ $income->name }}</td>
                                    <td>@money($total, 'USD', true)</td>
                                </tr>
                            </tbody>
                        </table>
                        @php
                            $incometotal = $incometotal + $total;
                            $total = 0;
                        @endphp
                    @endif
                @endforeach
            </div>
        </div>
        {{-- INCOME TOTAL --}}
        <table class="table table-show table-striped table-hover table-bordered table-responsive">
            <tbody>
                <tr>
                    <td>Income Total</td>
                    <td>@money($incometotal, 'USD', true)</td>
                </tr>
            </tbody>
        </table>

        {{-- EXPENSES --}}
        <p><a class="profit-link" data-toggle="collapse" href="#expenses" role="button" aria-expanded="false"
                aria-controls="expenses"><i class="material-icons">keyboard_arrow_down</i>Expenses</a></p>
        <div class="collapse first-step" id="expenses">
            <div class="inner-accord">
                @php
                $expensetotal = 0;
                @endphp
                @foreach($expenses as $expense)
                    @if(count($expense->chartofhistory) > 0)
                        <p><a class="profit-link" data-toggle="collapse" href="#innerExpense{{ $expense->id }}" role="button" aria-expanded="false" aria-controls="innerExpense{{ $expense->id }}"><i class="material-icons">keyboard_arrow_down</i>{{ $expense->name }}</a></p>
                        <div class="collapse second-step" id="innerExpense{{ $expense->id }}">
                            <div class="inner-accord">
                                <table class="table table-show table-striped table-hover table-bordered " id="">
                                    <tbody>
                                        @php
                                            $etotal = 0;
                                            $charts = $expense->chartofhistory;
                                        @endphp
                                        @foreach ($charts as $item)
                                        @php
                                            if($item->amount_type == 'add') {
                                                $etotal = $etotal + $item->amount;
                                            } else {
                                                $etotal = $etotal - $item->amount;
                                            }
                                        @endphp
                                        <tr>
                                            <td>{{ Carbon::parse($item->created_at)->format($date_format) }}</td>
                                            <td>{{ $item->transaction_type }}</td>
                                            <td>{{ $item->number }}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>{{ $item->description }}</td>
                                            <td>{{ ($item->amount_type=='add')?'+':'-' }}@money($item->amount, 'USD', true)</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                <tr class="first-table">
                                    <td colspan="5">{{ $expense->name }}</td>
                                    <td>@money($etotal, 'USD', true)</td>
                                </tr>
                            </tbody>
                        </table>
                        @php
                            $expensetotal = $expensetotal + $etotal;
                            $etotal = 0;
                        @endphp
                    @endif
                @endforeach
            </div>
        </div>
        {{-- EXPENSE TOTAL --}}
        <table class="table table-show table-striped table-hover table-bordered ">
            <tbody>
                <tr>
                    <td>Expeses Total</td>
                    <td>@money($expensetotal, 'USD', true)</td>
                </tr>
                <tr>
                    <td>NET INCOME</td>
                    <td>@money($incometotal - $expensetotal, 'USD', true)</td>
                </tr>
            </tbody>
        </table>

        <div class="box-footer">
        </div>
        <!-- /.box-body -->
    </div>

    @include('accounts.reports.standard.filter')
    @include('includes.datepicker')
    @endsection