@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' =>
trans('reports.standard.balancesheetdetail')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
    .red-text {
        color: red;
    }

    .text-right {
        text-align: right;
    }

    .table-show tbody {
        height: auto !important;
    }

    .profit-content {
        display: none;
    }

    .profit-link .material-icons {
        position: relative;
        top: 6px;
    }

    .first-step {
        padding-left: 1% !important;
    }

    .second-step {
        padding-left: 2% !important;
    }
</style>
<!-- Default box -->
<div class="box box-success">
    <div class="card">
        {!! Form::open(['url'=>'/reports/standard/balance-sheet']) !!}
        @include('accounts.reports.standard.date-filter-view')
        {!! Form::close() !!}
    </div>
    <div class="box-body">
        <div class="row m-0">
            <h3><strong>{{ trans('reports.standard.balancesheetdetail') }}</strong></h3>
        </div>
        <table class="table table-show table-striped table-hover table-bordered " id="">
            <thead>
                <tr>
                    <th>DATE</th>
                    <th>TRANSACTION TYPE</th>
                    <th>NUM</th>
                    <th>NAME</th>
                    <th>MEMO/DESCRIPTION</th>
                    <th>DEBIT</th>
                    <th>CREDIT</th>
                    <th>AMOUNT</th>
                </tr>
            </thead>
        </table>
        {{-- ASSETS --}}
        <p><a class="profit-link" data-toggle="collapse" href="#assets" role="button" aria-expanded="false"
                aria-controls="assets"><i class="material-icons">keyboard_arrow_down</i>ASSETS</a></p>
        <div class="collapse first-step" id="assets">
            <div class="inner-accord">
                @php
                $assetsTotal = 0;
                @endphp
                @foreach($assets as $asset)
                    @if(count($asset->chartofhistory) > 0)
                        @php
                            $atotal = 0;
                            $charts = $asset->chartofhistory;
                        @endphp
                        @foreach ($charts as $chat)
                          @php
                              if($chat->amount_type == 'add') {
                                  $atotal = $atotal + $chat->amount;
                              } else {
                                  $atotal = $atotal - $chat->amount;
                              }
                          @endphp
                        @endforeach

                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                <tr class="first-table">
                                    <td colspan="7">{{ $asset->name }}</td>
                                    <td>@money($atotal, 'USD', true)</td>
                                </tr>
                            </tbody>
                        </table>
                        @php
                            $assetsTotal = $assetsTotal + $atotal;
                            $atotal = 0;
                        @endphp
                    @endif
                @endforeach
            </div>
        </div>
        {{-- ASSETS TOTAL --}}
        <table class="table table-show table-striped table-hover table-bordered">
          <tbody>
            <tr>
              <td colspan="6">Assets Total</td>
              <td>@money($assetsTotal, 'USD', true)</td>
            </tr>
          </tbody>
        </table>

        {{-- LIABILITIES --}}
        <p><a class="profit-link" data-toggle="collapse" href="#liabilities" role="button" aria-expanded="false"
                aria-controls="liabilities"><i class="material-icons">keyboard_arrow_down</i>LIABILITIES</a></p>
        <div class="collapse first-step" id="liabilities">
            <div class="inner-accord">
                @php
                $liabilitiesTotal = 0;
                @endphp
                @foreach($liabilities as $liability)
                    @if(count($liability->chartofhistory) > 0)
                          @php
                            $ltotal = 0;
                            $charts = $asset->chartofhistory;
                          @endphp
                        @foreach ($charts as $chat)
                          @php
                            if($chat->amount_type == 'add') {
                              $ltotal = $ltotal + $chat->amount;
                            } else {
                              $ltotal = $ltotal - $chat->amount;
                            }
                          @endphp
                        @endforeach

                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                <tr class="first-table">
                                    <td colspan="7">{{ $liability->name }}</td>
                                    <td>@money($ltotal, 'USD', true)</td>
                                </tr>
                            </tbody>
                        </table>
                        @php
                            $liabilitiesTotal = $liabilitiesTotal + $ltotal;
                            $ltotal = 0;
                        @endphp
                    @endif
                @endforeach
            </div>
        </div>
        {{-- LIABILITITES TOTAL --}}
        <table class="table table-show table-striped table-hover table-bordered ">
          <tbody>
            <tr>
              <td colspan="6">Liabilities Total</td>
              <td>@money($liabilitiesTotal, 'USD', true)</td>
            </tr>
          </tbody>
        </table>

        <div class="box-footer">
        </div>
        <!-- /.box-body -->
    </div>

    @include('accounts.reports.standard.filter')
    @include('includes.datepicker')
    @endsection