@extends('layouts.default')

@section('title', trans_choice('reports.standard.standardreports', 1) . ' | ' .trans('reports.standard.auditlog'))


@section('new_button')
{{-- // --}}
@endsection

@section('content')
  
<div class="box box-success">

  <div class="card">
  {!! Form::open(['url'=>'/reports/standard/audit-log']) !!}
    @include('accounts.reports.standard.date-filter-view')
  {!! Form::close() !!}
  </div>
  
  <!-- /.box-header -->
  <div class="box-body">
    <table id="fullFeatures" class="table table-bordered table-show table-striped">
     
      <thead>
        <tr>
          <th width="25%">DATE</th>
          <th width="25%">NAME</th>
          <th width="25%">TRANSACTION TYPE</th>
          <th width="25%">AMOUNT</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($list as $li)
          <tr>
            <td width="25%">{{ Date::parse($li->created_at)->format($date_format) }}</td>
            <td width="25%">{{ ucwords($li->name) }}</td>
            <td width="25%">{{ ucfirst($li->transaction_type) }}</td>
            @if($li->amount_type == 'add')
            <td width="25%">  @money($li->amount, 'USD', true)</td>
            @else
            <td width="25%"> - @money($li->amount, 'USD', true)</td>
            @endif
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
  <div class="box-footer">
  </div>
  <!-- /.box-body -->
</div>
<!-- /.box -->
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection