@extends('layouts.default')

@section('title', trans('reports.standard.trialbalance'))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
	.red-text {
		color: red;
	}
</style>
<!-- Default box -->
<div class="box box-success">
	<div class="box-body">
		<div class="col-md-12 col-sm-12 col-xs-12">
			<h3 class="text-center"><strong>{{ trans('reports.standard.accountlist') }}</strong></h3>			
		</div>		
		<div class="table-responsive">
			<table class="table table-bordered table-hover">
				<thead>
					<tr>
						<th>ACCOUNT</th>
						<th>DEBIT</th>
						<th>CREDIT</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($list as $li)
						@if($li->balance > 0)
						<tr>
							<td>{{ $li->name }}</td>
							<td>@if(in_array($li->account_type_id, $creditTypes)) @money($li->balance, 'USD', true) @endif</td>
							<td>@if(in_array($li->account_type_id, $debitTypes)) @money($li->balance, 'USD', true) @endif</td>
						</tr>
						@endif
					@endforeach
				</tbody>
			</table>
		</div>				
	</div>
</div>
  
@include('accounts.reports.standard.filter')
@endsection