@extends('layouts.default')

@section('title', trans('reports.standard.journal'))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
    .red-text {
        color: red;
    }

    .text-right {
        text-align: right;
    }

    .table-show tbody {
        height: auto !important;
    }

    .profit-content {
        display: none;
    }

    .profit-link .material-icons {
        position: relative;
        top: 6px;
    }

    .first-step {
        padding-left: 1% !important;
    }

    .second-step {
        padding-left: 2% !important;
    }
</style>
<!-- Default box -->
<div class="box box-success">
    <div class="card">
        {!! Form::open(['url'=>'/reports/standard/journal']) !!}
        @include('accounts.reports.standard.date-filter-view')
        {!! Form::close() !!}
    </div>
    <div class="box-body">
        <div class="row m-0">
            <h3><strong>{{ trans('reports.standard.profitandlossdetails') }}</strong></h3>
        </div>
        <table class="table table-show table-striped table-hover table-bordered " id="">
            <thead>
                <tr>
                    <th>DATE</th>
                    <th>TRANSACTION TYPE</th>
                    <th>NUM</th>
                    <th>NAME</th>
                    <th>DESCRIPTION</th>
                    <th>ACCOUNT</th>
                    <th>AMOUNT</th>
                </tr>
            </thead>
            @if(count($lists) == 0)
                <tbody>
                    <tr>
                        <td class="text-center" colspan="6">No Data</td>
                    </tr>
                </tbody>
            @endif
        </table>
        @php
        $incometotal = 0;
        $i = 0;
        @endphp
        @foreach($lists as $key=>$list)
            @if(count($list) > 0)
                <p><a class="profit-link" data-toggle="collapse" href="#trans{{ $i+1 }}" role="button" aria-expanded="false" aria-controls="trans{{ $i+1 }}"><i class="material-icons">keyboard_arrow_down</i>{{ $key }}</a></p>
                <div class="collapse second-step show" id="trans{{ $i+1 }}">
                    <div class="inner-accord">
                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                @php
                                    $total = 0;
                                @endphp
                                @foreach ($list as $item)
                                @php
                                    if($item->amount_type == 'add') {
                                        $total = $total + $item->amount;
                                    } else {
                                        $total = $total - $item->amount;                                        
                                    }
                                    $accnt = $item->account;
                                @endphp
                                <tr>
                                    <td>{{ Carbon\Carbon::parse($item->created_at)->format($date_format) }}</td>
                                    <td>{{ $item->transaction_type }}</td>
                                    <td>{{ $item->number }}</td>
                                    <td>{{ $item->description }}</td>
                                    <td>{{ isset($accnt)?$accnt->name:'' }}</td>
                                    <td>{{ ($item->amount_type=='add')?'+':'-' }} @money($item->amount, 'USD', true)</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <table class="table table-show table-striped table-hover table-bordered" id="">
                    <tbody>
                        <tr class="first-table">
                            <td colspan="5"><strong>{{ $key }} Total</strong></td>
                            <td>@money($total, 'USD', true)</td>
                        </tr>
                    </tbody>
                </table>
                @php
                    $total = 0;
                @endphp
            @endif
        @endforeach
    </div>

    @include('accounts.reports.standard.filter')
    @include('includes.datepicker')
    @endsection