@extends('layouts.default')

@section('title', trans('reports.standard.title.generalledger'))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
    .red-text {
        color: red;
    }

    .text-right {
        text-align: right;
    }

    .table-show tbody {
        height: auto !important;
    }

    .profit-content {
        display: none;
    }

    .profit-link .material-icons {
        position: relative;
        top: 6px;
    }

    .first-step {
        padding-left: 1% !important;
    }

    .second-step {
        padding-left: 2% !important;
    }
</style>
<!-- Default box -->
<div class="box box-success">
    <div class="card">
        {!! Form::open(['url'=>'/reports/standard/general-ledger']) !!}
        @include('accounts.reports.standard.date-filter-view')
        {!! Form::close() !!}
    </div>
    <div class="box-body">
        <div class="row m-0">
            <h3><strong>{{ trans('reports.standard.profitandlossdetails') }}</strong></h3>
        </div>
        <table class="table table-show table-striped table-hover table-bordered " id="">
            <thead>
                <tr>
                    <th>ACCOUNT / DATE</th>
                    <th>TRANSACTION TYPE</th>
                    <th>NUM</th>
                    <th>NAME</th>
                    <th>DESCRIPTION</th>
                    <th>AMOUNT</th>
                </tr>
            </thead>
        </table>
        {{-- INCOMES --}}
        @php
        $incometotal = 0;
        @endphp
        @foreach($lists as $list)
            @if(count($list->chartofhistory) > 0)
                <p><a class="profit-link" data-toggle="collapse" href="#innerIncomes{{ $list->id }}" role="button" aria-expanded="false" aria-controls="innerIncomes{{ $list->id }}"><i class="material-icons">keyboard_arrow_down</i>{{ $list->name }}</a></p>
                <div class="collapse second-step" id="innerIncomes{{ $list->id }}">
                    <div class="inner-accord">
                        <table class="table table-show table-striped table-hover table-bordered " id="">
                            <tbody>
                                @php
                                    $total = 0;
                                    $charts = $list->chartofhistory;
                                @endphp
                                @foreach ($charts as $item)
                                @php
                                    if($item->amount_type == 'add') {
                                        $total = $total + $item->amount;
                                    } else {
                                        $total = $total - $item->amount;
                                    }
                                @endphp
                                <tr>
                                    <td>{{ Carbon\Carbon::parse($item->created_at)->format($date_format) }}</td>
                                    <td>{{ $item->transaction_type }}</td>
                                    <td>{{ $item->number }}</td>
                                    <td>{{ $item->name }}</td>
                                    <td>{{ $item->description }}</td>
                                    <td>{{ ($item->amount_type=='add')?'+':'-' }}@money($item->amount, 'USD', true)</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <table class="table table-show table-striped table-hover table-bordered table-responsive" id="">
                    <tbody>
                        <tr class="first-table">
                            <td colspan="5">{{ $list->name }}</td>
                            <td>@money($total, 'USD', true)</td>
                        </tr>
                    </tbody>
                </table>
                @php
                    $incometotal = $incometotal + $total;
                    $total = 0;
                @endphp
            @endif
        @endforeach
    </div>

    @include('accounts.reports.standard.filter')
    @include('includes.datepicker')
    @endsection