@extends('layouts.default')

@section('title', trans('reports.standard.title.standardreports', ['type' => trans('reports.standard.accountlist')]))

@section('new_button')
{{-- // --}}
@endsection

@section('content')
<style>
	.red-text {
		color: red;
	}
</style>
<!-- Default box -->
<div class="box box-success">
	<div class="card">
  <div class="box-header">
    
      {!! Form::open(['url'=>'/reports/standard/account-list']) !!}
      @include('accounts.reports.standard.date-filter-view')
      {!! Form::close() !!}
    </div>
  </div>
	<div class="box-body">
		<div class="col-md-12 col-sm-12 col-xs-12">
			<h3 class="text-center">ASAS <strong>{{ trans('reports.standard.accountlist') }}</strong> <span>As of {{ Date::parse(date('y-m-d'))->format($date_format) }}</span></h3>
			
		</div>

		
					<div class="table-responsive">
						<table class="table table-bordered table-hover">
							<thead>
								<tr>
									<th>ACCOUNT</th>
									<th>REPRESENTATIVE NAME</th>
									<th>BALANCE</th>
								</tr>
							</thead>
							<tbody>
								@foreach ($list as $li)
									<tr>
										<td>{{ $li->name }}</td>
										<td>{{ $li->bank_name }}</td>
										<td>@money($li->opening_balance, 'USD', true)</td>
									</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				
	</div>
</div>
  
@include('accounts.reports.standard.filter')
@include('includes.datepicker')
@endsection