@extends('layouts.default')

@section('header-links')
@include('accounts.reports.management.selector')
@endsection

@section('title', isset($title)?$title:'')

<link rel="stylesheet" href="{{ ('/acs/reports/style.css') }}">

@section('content')

<div class="container-fluid">
    <div class="col-lg-4">
      
      {!! Form::open(['method' => 'POST', 'url' => '/reports/management/employee-worked-hours', 'class' => 'form-horizontal', 'id'=>'hoursForm']) !!}
        <div class="form-group{{ $errors->has('student_id') ? ' has-error' : '' }}">
            {{-- {!! Form::label('student_id', 'Select Consultant') !!} --}}
            {!! Form::select('student_id', [''=>'Select Consultant']+$students, null, ['id' => 'student_id', 'class' => 'form-control selectpicker', 'required' => 'required', 'onchange'=>'submitForm();', 'style'=>'width: 100%;','data-live-search'=>'true']) !!}
            <small class="text-danger">{{ $errors->first('student_id') }}</small>
        </div>   
      {!! Form::close() !!}
      
    </div>
    <div class="row" id="pageContent">
      <table id="verticleTable" class="table table-striped table-bordered nowrap" style="width:100%">
          <thead>
              <tr>
                  <th>Month</th>
                  <th>Week 1</th>
                  <th>Week 2</th>
                  <th>Week 3</th>
                  <th>Week 4</th>
                  <th>Week 5</th>
                  <th>Week 6</th>
                  <th>Worked Hours</th>
                  <th>OT</th>
                  <th>Approved Hours</th>
                  <th>Paid Hours</th>
              </tr>
          </thead>
          <tbody>
            @php
              $months = config('custom_config.months_names');
            @endphp
            @foreach ($list as $li)
              <tr>
                <td>{{ $months[$li->month_value] }}</td>
                <td>{{ $li->week1 }}</td>
                <td>{{ $li->week2 }}</td>
                <td>{{ $li->week3 }}</td>
                <td>{{ $li->week4 }}</td>
                <td>{{ $li->week5 }}</td>
                <td>{{ $li->week6 }}</td>
                <td>{{ $li->weeks }}</td>
                <td>{{ $li->total_ot_hours }}</td>
                <td>{{ $li->weeks }}</td>
                <td>{{ $li->weeks }}</td>
              </tr>
            @endforeach
          </tbody>
      </table>
    </div>
</div>

<!-- MIS REPORT DATA TABLE JS STARTS -->
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedcolumns/3.2.4/js/dataTables.fixedColumns.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.3/js/dataTables.fixedHeader.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
          var table = $('#horizontalTable').DataTable( {
             // scrollY:        "390px",
              scrollX:        true,
              scrollCollapse: true,
              paging:         true,
              fixedHeader: {
                  header: true
                  // footer: true
              }
          } );
        } );
        $(document).ready(function() {
          var table = $('#verticleTable').DataTable( {
             // scrollY:        "390px",
              scrollX:        true,
              scrollCollapse: true,
              paging:         true,
              fixedHeader: {
                  header: true
                  // footer: true
              }
          } );
        } );
</script>
<!-- MIS REPORT DATA TABLE JS ENDS -->
<script>
  function submitForm() {
      $("#hoursForm").submit();
  }
</script>
@endsection