@extends('layouts.default')
@section('header-links')
@include('accounts.reports.management.selector')
@endsection
@section('title', isset($title)?$title:'')

<link rel="stylesheet" href="{{ ('/acs/reports/style.css') }}">

@section('content')

<div class="container-fluid">
    {!! Form::open(['method' => 'POST', 'url' => '/reports/management/vendor-payments', 'class' =>
    'form-horizontal', 'id'=>'form1']) !!}

    <div class="form-group{{ $errors->has('year') ? ' has-error' : '' }}">
        {!! Form::label('year', 'Select due date', ['class' => 'col-sm-3 control-label']) !!}
        <div class="col-md-4">
            {{ Form::textGroup1('due_date', 'Due date', 'calendar',['id' => 'due_date', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'mm-dd-yyyy\'', 'onchange'=>'document.getElementById("form1").submit();'], $due_date) }}
        </div>
    </div>
    {!! Form::close() !!}
    <div class="row" id="pageContent" style="overflow:auto;overflow-x:scroll;">
        <table class="table table-striped table-bordered nowrap">
            <thead>
                <tr>
                    <th>Customer</th>
                    <th>Consultant</th>
                    <th>Due date</th>
                    <th>Amount</th>
                    <th>Remarks</th>
                </tr>
            </thead>

            <tbody>
                @php
                    $total = 0;
                @endphp
                @foreach($list as $li)
                    @if (count($li->invoices) > 0)
                        @foreach ($li->invoices as $invoice)
                            @php
                                if(isset($invoice->payments_total[0])) {
                                    $payment = $invoice->payments_total[0]->paid_amount;
                                    $res = $invoice->amount - $payment;
                                } else {
                                    $res = $invoice->amount;
                                }
                                    $total = $total + $res;
                            @endphp    
                            <tr>
                                <td>{!! $li->parent->name or '' !!}</td>
                                <td>{!! $li->name !!}</td>
                                <td>
                                    @if($res != 0)
                                        {!! Carbon::parse($invoice->due_at)->format($date_format) !!}
                                    @else
                                        No due as of day
                                    @endif    
                                </td>
                                <td>
                                    @if($res != 0)
                                        @money($invoice->amount, 'USD', 'true')
                                    @endif
                                </td>
                                <td title="{!! str_limit($invoice->description, 15) !!}">{!! str_limit($invoice->description, 15) !!}</td>
                            </tr>                            
                        @endforeach
                    @endif
                @endforeach
                
                @if($total != 0)
                <tr>
                    <td colspan="3"></td>
                    <td>@money($total, 'USD', true)</td>
                    <td></td>
                </tr>
                @else
                    <tr>
                        <td colspan="5" class="text-center">No Data</td>
                    </tr>
                @endif

                @if (count($list) == 0)
                <tr>
                    <td colspan="5" class="text-center">No Data</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>

<script>
    var today = new Date();
    $('#due_date').inputmask('MM-DD-YYYY', { placeholder: 'MM-DD-YYYY' });
    $('#due_date').datepicker({
        format: 'mm-dd-yyyy',
        todayHighlight: true,
        clearBtn: true,
        endDate: today,
    });
</script>
@endsection