@extends('layouts.default')
@section('header-links')
@include('accounts.reports.management.selector')
@endsection
@section('title', isset($title)?$title:'')

<link rel="stylesheet" href="{{ ('/acs/reports/style.css') }}">

@section('content')

<div class="container-fluid">
    {!! Form::open(['method' => 'POST', 'url' => '/reports/management/payroll-summary', 'class' =>
    'form-horizontal', 'id'=>'form1']) !!}

    <div class="form-group{{ $errors->has('year') ? ' has-error' : '' }}">
        <div class="row">
            <div class="col-md-3">
                <small>Select Consultant</small>
                {!! Form::select('customer_id', $employees, null, ['class' => 'selectpicker', 'required' =>
                'required', 'onchange'=>'formSubmit();','data-live-search'=>'true' , 'style'=>'width: 100%;']) !!}
                <small class="text-danger">{{ $errors->first('year') }}</small>
            </div>
            <div class="col-md-3">
                <small>Select Year</small>
                {!! Form::selectYear('year', date('Y') - 6, date('Y')+2, date('Y'), ['class' => 'selectpicker',
                'required' =>'required', 'data-live-search'=>'true', 'onchange'=>'formSubmit();', 'style'=>'width: 100%;']) !!}
                <small class="text-danger">{{ $errors->first('year') }}</small>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
    <div class="row" id="pageContent">

        @php
        $months = config('custom_config.months_names');
        @endphp
        <table id="verticleTable" class="table table-striped table-bordered nowrap" style="width:100%">
            <thead>
                <tr>
                    <th>Month</th>
                    <th>Regular Hrs</th>
                    <th>Extra Hrs</th>
                    <th>Pay Rate</th>
                    <th>Actual Pay</th>
                    <th>Extra Pay</th>
                    <th>Total Pay</th>
                    <th>Paid</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $gregtotal = 0; $extotal = 0; $actpaytotal = 0; $extpaytotal = 0; $gndtotal = 0; $paidtotal = 0;
                @endphp
                @foreach ($list as $li)
                    <tr>
                        <td>{{ config('custom_config.months_names')[$li->month] }}</td>
                        <td>
                            @php
                                $gregtotal = $gregtotal + $li->regular;
                            @endphp
                            {{ $li->regular }}
                        </td>
                        <td>
                            @php
                                $extotal = $extotal + $li->ot;
                            @endphp
                            {{ $li->ot }}
                        </td>
                        <td>50, 40</td>
                        <td>
                            @php
                                $stotal = 0;
                                echo $totalreg = findPayrateAmount($li->regular, $li['payrates'], $wtotal=0);
                                $actpaytotal = $actpaytotal + $totalreg;
                            @endphp
                        </td>
                        <td>
                            @php
                                $stotal = 0;
                                echo $totalot = findPayrateAmount($li->ot, $li['payrates'], $wtotal=0);
                                $extpaytotal = $extpaytotal + $totalot;
                            @endphp
                        </td>
                        <td>
                            @php
                                $gtotal = $totalreg + $totalot;
                                $gndtotal = $gndtotal + $gtotal;
                            @endphp
                            {{ $gtotal }}
                        </td>
                        <td>
                            @php
                                $paidtotal = $paidtotal + 1000;
                            @endphp
                            @money(1000, 'USD', true)
                        </td>
                        <td></td>
                    </tr>
                @endforeach
                @if(count($list) > 0)
                <tr>
                    <td><strong>Totals</strong></td>
                    <td>{{ $gregtotal }}</td>
                    <td>{{ $extotal }}</td>
                    <td>NULL</td>
                    <td>@money($actpaytotal, 'USD', true)</td>
                    <td>@money($extpaytotal, 'USD', true)</td>
                    <td>@money($gndtotal, 'USD', true)</td>
                    <td>@money($paidtotal, 'USD', true)</td>
                    <td></td>
                </tr>
                @else
                <tr>
                    <td colspan="9" class="text-center">No Data</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>

<script>
    function formSubmit() {
      $("#form1").submit();
  }
</script>
@endsection