@extends('layouts.default')
@section('header-links')
@include('accounts.reports.management.selector')
@endsection
@section('title', isset($title)?$title:'')

<link rel="stylesheet" href="{{ ('/acs/reports/style.css') }}">
<style>
 
td a{color:#fff !important;}
.invoice-paid {
    background-color:#43bc40 !important; color:#fff !important;
}
 .invoice-sent{
    background-color:#43bc40 !important; color:#fff !important;
}
 .invoice-partial{
    background-color:#d39e00 !important; color:#fff !important;
}
 .invoice-draft{
   background-color:#03a5ee !important; color:#fff !important;
}
.inv-detl{padding:0px 5px;}
</style>
@section('content')

<div class="container-fluid">
      {!! Form::open(['method' => 'POST', 'url' => '/reports/management/invoioce-payment', 'class' => 'form-horizontal', 'id'=>'form1']) !!}    
          <div class="form-group{{ $errors->has('year') ? ' has-error' : '' }}">
              {!! Form::label('year', 'Select Year', ['class' => 'col-sm-3 control-label']) !!}
              <div class="col-md-4">
                  {!! Form::selectYear('year', date('Y') - 6,date('Y'),$year, ['class' => 'selectpicker', 'required' => 'required', 'onchange'=>'formSubmit();','data-live-search'=>'true', 'style'=>'width: 100%;']) !!}
                  <small class="text-danger">{{ $errors->first('year') }}</small>
              </div>
          </div>      
      {!! Form::close() !!}
    <div class="row" id="pageContent" style="overflow:auto;overflow-x:scroll;">
      @php
        $months = config('custom_config.months_names');
      @endphp
      <table id="verticleTable" class="table table-striped table-bordered nowrap">
          <thead>
              <tr class="text-center"> 
                  <th rowspan="2" style="border-right:1px solid #ccc;">Consultant Name</th>
                  @foreach($months as $month)
                  <th colspan="3" class="text-center bg-gray" style="border-right:1px solid #ccc;">{{ $month  .' - '. $year }} </th>
                  @endforeach 
              </tr>
              <tr>
                @foreach($months as $month)   
                  <th class="text-center">Date</th>
                  <th class="text-center">Invoice</th>
                  <th class="text-center" style="border-right:1px solid #ccc;">Amount</th>
                   @endforeach
              </tr>
          </thead>
          <tbody> 
            @foreach($invoices as $invoice)
            <tr>
              <td style="border-right:1px solid #ccc;white-space: nowrap;">{{ $invoice->customer_name }}</td>
              @foreach($months as $k=> $month)   
                @if($k  == Date::parse($invoice->due_at)->format("n")) 
                <td colspan="3" class="invoice-{{ $invoice->status->code }}" style="white-space:nowrap;border-right:1px solid #ccc;" >
                  <a href="{{ url('incomes/invoices/'.$invoice->id) }}">
                    <span class="inv-detl">{{ Date::parse($invoice->due_at)->format($date_format) }}</span>
                    <span class="inv-detl">{{ $invoice->invoice_number }}  </span>
                    <span class="inv-detl"> @money($invoice->amount,'USD',true) </span>
                  </a>
                </td>
                {{-- <td class="invoice-{{ $invoice->status->code }}" style="white-space:nowrap;">{{ Date::parse($invoice->due_at)->format($date_format) }}</td>
                <td class="invoice-{{ $invoice->status->code }}" style="white-space:nowrap;">{{ $invoice->invoice_number }}</td>
                <td class="invoice-{{ $invoice->status->code }}" style="border-right:1px solid #ccc;">@money($invoice->amount,'USD',true)</td>  --}}
                @else
                <td colspan="3" style="border-right:1px solid #ccc;text-align: center;" >-</td>
                @endif
               @endforeach
            </tr>
            @endforeach
          </tbody>
      </table>
    </div>
</div> 
  
@push('scripts')
<script type="text/javascript">
function formSubmit(e){
  $('#form1').submit();
}
</script>

@endpush
@endsection