@extends('layouts.default')
@section('header-links')
@include('accounts.reports.management.selector')
@endsection
@section('title', isset($title)?$title:'')

<link rel="stylesheet" href="{{ ('/acs/reports/style.css') }}">

@section('content')

<div class="container-fluid">
      {!! Form::open(['method' => 'POST', 'url' => '/reports/management/employee-expenses', 'class' => 'form-horizontal', 'id'=>'form1']) !!}
      
          <div class="form-group{{ $errors->has('year') ? ' has-error' : '' }}">
              {!! Form::label('year', 'Select Year', ['class' => 'col-lg-3 control-label']) !!}
              <div class="col-md-4">
                  {!! Form::selectYear('year', date('Y') - 6, date('Y'), null, ['class' => 'selectpicker', 'required' => 'required', 'onchange'=>'formSubmit();', 'style'=>'width: 100%;']) !!}
                  <small class="text-danger">{{ $errors->first('year') }}</small>
              </div>
          </div>      
      {!! Form::close() !!}
    <div class="row" id="pageContent">

      @php
        $months = config('custom_config.months_names');
      @endphp
      <table id="verticleTable" class="table table-striped table-bordered nowrap" style="width:100%">
          <thead>
              <tr>
                  <th>Customer</th>
                  @foreach($months as $m)
                  <th>{{ $m }}</th>
                  @endforeach
                  <th>Total</th>
              </tr>
          </thead>
          <tbody>
            @php
            $arr1 = []; $arr2 = []; $arr3 = []; $arr4 = []; $arr5 = []; $arr6 = []; $arr7 = []; $arr8 = []; $arr9 = []; $arr10 = []; $arr11 = []; $arr12 = []; $gtotal1 = [];
            @endphp
            @foreach ($list as $li)
              @php
                $gtotal = 0;
              @endphp
              @if(count($li['invoices']) > 0)
              <tr>
                <td>{!! str_limit($li['name'], 15) !!}</td>
                  @for ($j = 1; $j < 13; $j++)
                    <td>
                      @foreach ($li['invoices'] as $record)
                        @if($record['month'] == $j)
                          @php

                            $gtotal = $gtotal + $record['total'];

                            if ($j == 1) {
                              array_push($arr1, $record['total']);
                            } else if($j == 2){
                              array_push($arr2, $record['total']);
                            } else if($j == 3){
                              array_push($arr3, $record['total']);
                            } else if($j == 4){
                              array_push($arr4, $record['total']);
                            } else if($j == 5){
                              array_push($arr5, $record['total']);
                            } else if($j == 6){
                              array_push($arr6, $record['total']);
                            } else if($j == 7){
                              array_push($arr7, $record['total']);
                            } else if($j == 8){
                              array_push($arr8, $record['total']);
                            } else if($j == 9){
                              array_push($arr9, $record['total']);
                            } else if($j == 10){
                              array_push($arr10, $record['total']);
                            } else if($j == 11){
                              array_push($arr11, $record['total']);
                            } else if($j == 12){
                              array_push($arr12, $record['total']);
                            } else {

                            }
                          @endphp
                          @money($record['total'], 'USD', true)
                        @endif
                      @endforeach
                    </td>
                  @endfor
                  @php
                    array_push($gtotal1, $gtotal);
                  @endphp
                <td>@money($gtotal, 'USD', true)</td>
              </tr>
              @endif
            @endforeach
              <tr class="success">
                <td>{!! 'Totals' !!}</td>
                <td>@money(array_sum($arr1), 'USD', true)</td>
                <td>@money(array_sum($arr2), 'USD', true)</td>
                <td>@money(array_sum($arr3), 'USD', true)</td>
                <td>@money(array_sum($arr4), 'USD', true)</td>
                <td>@money(array_sum($arr5), 'USD', true)</td>
                <td>@money(array_sum($arr6), 'USD', true)</td>
                <td>@money(array_sum($arr7), 'USD', true)</td>
                <td>@money(array_sum($arr8), 'USD', true)</td>
                <td>@money(array_sum($arr9), 'USD', true)</td>
                <td>@money(array_sum($arr10), 'USD', true)</td>
                <td>@money(array_sum($arr11), 'USD', true)</td>
                <td>@money(array_sum($arr12), 'USD', true)</td>
                <td>@money(array_sum($gtotal1), 'USD', true)</td>
              </tr>
          </tbody>
      </table>
    </div>
</div>

<!-- MIS REPORT DATA TABLE JS STARTS -->
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedcolumns/3.2.4/js/dataTables.fixedColumns.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.3/js/dataTables.fixedHeader.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
      var table = $('#verticleTable').DataTable( {
         // scrollY:        "390px",
          scrollX:        true,
          scrollCollapse: true,
          paging:         false,
          fixedHeader: {
              header: true
              // footer: true
          }
      } );
    } );
</script>
<!-- MIS REPORT DATA TABLE JS ENDS -->
<script>
  function formSubmit() {
      $("#form1").submit();
  }
</script>
@endsection