@extends('layouts.default')
@section('header-links')
@include('accounts.reports.management.selector')
@endsection
@section('title', isset($title)?$title:'')

<link rel="stylesheet" href="{{ ('/acs/reports/style.css') }}">

@section('content')

<div class="container-fluid">
      {!! Form::open(['method' => 'POST', 'url' => '/reports/management/consultant-vendor-payments', 'class' => 'form-horizontal', 'id'=>'form1']) !!}
      
          <div class="form-group{{ $errors->has('year') ? ' has-error' : '' }}">
              {!! Form::label('year', 'Select Year', ['class' => 'col-sm-3 control-label']) !!}
              <div class="col-md-4">
                  {!! Form::selectYear('year', date('Y') - 6, date('Y'), date('Y'), ['class' => 'selectpicker', 'required' => 'required', 'onchange'=>'formSubmit();', 'style'=>'width: 100%;']) !!}
                  <small class="text-danger">{{ $errors->first('year') }}</small>
              </div>
          </div>      
      {!! Form::close() !!}
    <div class="row" id="pageContent">

      @php
        $months = config('custom_config.months_names');
      @endphp
      <table id="verticleTable" class="table table-striped table-bordered nowrap">
            <thead>
                <tr class="text-center">
                    <th>Vendor</th>
                    <th>Consultant</th>
                    @foreach($months as $m)
                    <th colspan="2" class="text-center">{{ $m }}</th>
                    @endforeach
                    <th colspan="2" class="text-center">Totals</th>
                </tr>
                <tr class="text-center">
                    <th>Vendor</th>
                    <th>Consultant</th>
                    @foreach($months as $m)
                        <th>Vendor Payments</th>
                        <th>Consultant Payrole</th>
                    @endforeach
                    <th>Vendor Payment Total</th>
                    <th>Consultant Payrole Total</th>
                </tr>
            </thead>
          <tbody>
            @php
            $arr1 = []; $arr2 = []; $arr3 = []; $arr4 = []; $arr5 = []; $arr6 = []; $arr7 = []; $arr8 = []; $arr9 = []; $arr10 = []; $arr11 = []; $arr12 = []; $gtotal1 = []; $ttotal1 = [];
            $timearr1 = []; $timearr2 = []; $timearr3 = []; $timearr4 = []; $timearr5 = []; $timearr6 = []; $timearr7 = []; $timearr8 = []; $timearr9 = []; $timearr10 = []; $timearr11 = []; $timearr12 = []; $ttotal1 = [];
            @endphp
            @foreach ($list as $li)
                @php
                    $gtotal = 0;
                    $ttotal = 0;
                @endphp
                @if(count($li['childs']) > 0)
                    @foreach ($li['childs'] as $record)
                    <tr class="text-center">
                        <td>{!! str_limit($li['name'], 15) !!}</td>
                        <td>{!! str_limit($record['name'], 15) !!}</td>
                        @for ($j = 1; $j < 13; $j++)

                            @php 
                                // Timesheet Totals
                                if(isset($record['timetotals'][$j])) {
                                    $timesttl = json_decode($record['timetotals'][$j]);
                                    $timesttl = ($timesttl[0])->regular + ($timesttl[0])->ot;  
                                    $ttotal = $ttotal + $timesttl;
                                } else {
                                    $nttotal = 0;
                                    $timesttl = 0;
                                }

                                $nttotal = $timesttl;
                                $tname = 'timearr'.$j;
                                array_push($$tname, $nttotal);
                                
                                // Vendor Payrates
                                if($record['months']['month'] == $j) {
                                    $ntotal = $record['months']['total'];
                                    $gtotal = $gtotal + $ntotal;
                                } else {
                                    $gtotal = $gtotal + 0;
                                    $ntotal = 0;
                                }

                                $aname = 'arr'.$j;
                                array_push($$aname, $ntotal);
                            @endphp
                                                      
                            <td>@if($ntotal != 0) @money($ntotal, 'USD', true) @endif</td>
                            <td>@if($timesttl != 0) @money($timesttl, 'USD', true) @endif</td>
                            
                        @endfor

                        <td>@if($gtotal != 0) @money($gtotal, 'USD', true) @endif</td>
                        <td>@if($ttotal != 0) @money($ttotal, 'USD', true) @endif</td>

                    </tr>
                        @php
                            array_push($gtotal1, $gtotal);
                            $gtotal = 0;
                            array_push($ttotal1, $ttotal);
                            $ttotal = 0;
                        @endphp
                    @endforeach
                @endif
            @endforeach
              <tr class="success">
                <td>{!! 'Vendor' !!}</td>
                <td>{!! 'Consultant' !!}</td>
                <td>@money(array_sum($arr1), 'USD', true)</td>
                <td>@money(array_sum($timearr1), 'USD', true)</td>
                <td>@money(array_sum($arr2), 'USD', true)</td>
                <td>@money(array_sum($timearr2), 'USD', true)</td>
                <td>@money(array_sum($arr3), 'USD', true)</td>
                <td>@money(array_sum($timearr3), 'USD', true)</td>
                <td>@money(array_sum($arr4), 'USD', true)</td>
                <td>@money(array_sum($timearr4), 'USD', true)</td>
                <td>@money(array_sum($arr5), 'USD', true)</td>
                <td>@money(array_sum($timearr5), 'USD', true)</td>
                <td>@money(array_sum($arr6), 'USD', true)</td>
                <td>@money(array_sum($timearr6), 'USD', true)</td>
                <td>@money(array_sum($arr7), 'USD', true)</td>
                <td>@money(array_sum($timearr7), 'USD', true)</td>
                <td>@money(array_sum($arr8), 'USD', true)</td>
                <td>@money(array_sum($timearr8), 'USD', true)</td>
                <td>@money(array_sum($arr9), 'USD', true)</td>
                <td>@money(array_sum($timearr9), 'USD', true)</td>
                <td>@money(array_sum($arr10), 'USD', true)</td>
                <td>@money(array_sum($timearr10), 'USD', true)</td>
                <td>@money(array_sum($arr11), 'USD', true)</td>
                <td>@money(array_sum($timearr11), 'USD', true)</td>
                <td>@money(array_sum($arr12), 'USD', true)</td>
                <td>@money(array_sum($timearr12), 'USD', true)</td>
                <td>@money(array_sum($gtotal1), 'USD', true)</td>
                <td>@money(array_sum($ttotal1), 'USD', true)</td>
              </tr>
          </tbody>
      </table>
    </div>
</div>

<!-- MIS REPORT DATA TABLE JS STARTS -->
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedcolumns/3.2.4/js/dataTables.fixedColumns.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.3/js/dataTables.fixedHeader.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
      var table = $('#verticleTable').DataTable( {
         // scrollY:        "390px",
          scrollX:        true,
          scrollCollapse: true,
          paging:         false,
          fixedHeader: {
              header: true
              // footer: true
          }
      } );
    } );
</script>
<!-- MIS REPORT DATA TABLE JS ENDS -->
<script>
  function formSubmit() {
      $("#form1").submit();
  }
</script>
@endsection