@extends('layouts.default')
@section('header-links')
@include('accounts.reports.management.selector')
@endsection
@section('title', isset($title)?$title:'')

<link rel="stylesheet" href="{{ ('/acs/reports/style.css') }}">

@section('content')

<div class="container-fluid">
    {!! Form::open(['method' => 'POST', 'url' => '/reports/management/consultant-monthly-hours', 'class' =>
    'form-horizontal', 'id'=>'form1']) !!}

    <div class="form-group{{ $errors->has('year') ? ' has-error' : '' }}">
        <div class="row">
            <div class="col-md-3">
                <small>Select Month</small>
                {!! Form::selectMonth('month', date('m'), ['class' => 'selectpicker', 'required' =>
                'required', 'onchange'=>'formSubmit();', 'style'=>'width: 100%;']) !!}
                <small class="text-danger">{{ $errors->first('year') }}</small>
            </div>
            <div class="col-md-3">
                    <small>Select Year</small>
                    {!! Form::selectYear('year', date('Y') - 6, date('Y')+2, date('Y'), ['class' => 'selectpicker', 'required' =>
                'required', 'onchange'=>'formSubmit();', 'style'=>'width: 100%;']) !!}
                <small class="text-danger">{{ $errors->first('year') }}</small>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
    <div class="row" id="pageContent" style="overflow:auto;overflow-x:scroll;">

        @php
        $months = config('custom_config.months_names');
        @endphp
        <table id="verticleTable" class="table table-striped table-bordered nowrap">
            <thead>
                <tr>
                    <th>Vendor</th>
                    <th>Consultant</th>
                    <th>Previous Hours</th>
                    @foreach($weekDates as $day)
                    <th>{{ date('M-d', strtotime($day['start'])).'-'.date('M-d', strtotime($day['end'])) }}</th>
                    @endforeach
                    <th>Total</th>
                    <th>Payrate</th>
                    <th>Amount</th>
                    <th>Updated Payrates</th>
                </tr>
            </thead>
            <tbody>
            @php
                $week1 = []; $week2 = []; $week3 = []; $week4 = []; $week5 = []; $week6 = [];
                
                $gtotal = [];
                $ttotal = [];
                $ptotal = [];
                
            @endphp
            @foreach ($list as $li)
                @php
                    $total = 0;
                @endphp
                <tr>
                    <td>{!! str_limit($li['parent'], 15) !!}</td>
                    <td>{!! str_limit($li['name'], 15) !!}</td>
                    <td>{{ number_format($li['prev_hours']) }}</td>
                    @for ($j = 1; $j <= count($weekDates); $j++)                            
                            
                        @php
                            if($li['week'.$j]) {
                                $nt = $li[$j];
                                $total = $total + $li[$j];
                            } else {
                                $nt = 0;
                            }

                            $week = 'week'.$j;
                            array_push($$week, $total);
                        @endphp

                        <td>{{ ($nt!=0)?$ny:'' }}</td>
                        
                    @endfor

                    @php
                        $pttotal = $li['prev_total'] + $total;
                    @endphp

                    <td>{{ $total }}</td>
                    <td>{{ 0 }}</td>                        
                    <td>
                        @php
                            if($li['payrate']) {
                                $stotal = 0;
                                echo findPayrateAmount($pttotal, $li['payrate'], $wtotal=0);
                            }
                        @endphp
                    </td>
                    <td>0</td>
                </tr>

                    @php
                        array_push($ptotal, 0);
                        array_push($ttotal, $total);
                        array_push($gtotal, $total * 10);
                        $total = 0;
                    @endphp
            @endforeach
            <tr>
                <td colspan="2">Totals</td>
                <td>0</td>
                @for ($i = 1; $i <= count($weekDates); $i++)
                    @php
                        $wname = 'week'.$i;
                    @endphp
                    <td>{{ number_format(array_sum($$wname)) }}</td>
                @endfor
                <td>{{ number_format(array_sum($ttotal)) }}</td>
                <td>{{ number_format(array_sum($ptotal)) }}</td>
                <td>{{ number_format(array_sum($gtotal)) }}</td>
                <td>{{ number_format(0) }}</td>
            </tr>
            </tbody>
        </table>
    </div>
</div>

<!-- MIS REPORT DATA TABLE JS STARTS -->
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedcolumns/3.2.4/js/dataTables.fixedColumns.min.js">
</script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.3/js/dataTables.fixedHeader.min.js">
</script>
<script type="text/javascript">
    $(document).ready(function() {
      var table = $('#verticleTable').DataTable( {
        scrollY:        "390px",
        scrollX:        true,
        scrollCollapse: true,
        paging:         false,
        fixedHeader: {
            header: true
            // footer: true
        }
      } );
    } );
</script>
<!-- MIS REPORT DATA TABLE JS ENDS -->
<script>
    function formSubmit() {
      $("#form1").submit();
  }
</script>
@endsection