@extends('layouts.default')
@section('title','Timesheet')
@section('content')
<style type="text/css">
  input[type=number]::-webkit-inner-spin-button, 
  input[type=number]::-webkit-outer-spin-button { 
  -webkit-appearance: none; 
  }
  a,
table a {
    cursor: pointer;
}
input[type=number] {
  -moz-appearance: textfield;
  color: #000;
}
input {
    height: 38px;
    line-height: 15px;
    /* width: 100%; */
}
table { width: 3em }

.modal-lg {
    width: 1000px;
}
.table th {
    padding: 10px;
}

.schTbHead-Text {
    margin-bottom: 10px !important;
    top: 10px;
    position: relative;
}
.schTbHead-Text h4 {
    margin: 0 0px;
    position: relative;
    color: #0c6dff;
    top: -7px;
}
</style>

@section('new_button')
<!--<a href="{{ url('payrole/timesheet/index') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"> {{ trans('Back') }}</a>-->
@endsection
<form id="weeks_wise_working_hours" method="POST" action="{{ url('/weeks_wise_working_hours') }}" enctype="multipart/form-data">
<div class="">
  <div class="row"> 
    <div class="col-lg-12 col-md-12 text-center mb-2">
               <div class="schTbHead-Text">
                  <button class="schTbHead-TextBtn" type="button" id="previousWeek">
                      <i class="material-icons">keyboard_arrow_left</i>
                  </button>
                  <h4   class="presentWeek" style="line-height: 50px;"  id="presentWeek" ></h4>
                  
                  <button class="schTbHead-TextBtn pl-0" type="button" id="nextWeek">
                      <i class="material-icons">keyboard_arrow_right</i>
                  </button>

              </div>
              <span id="weekly_timecard_unsaved_msg" style=" display: none;" >
                <strong>You have unsaved changes</strong>
              </span>
              <span id="weekly_timecard_saved_msg" style="display: none;">
                <strong>Changes Saved Successfully</strong>
              </span>
        </div>
    </div>
  <div class="card">
        <div class="card-header">
          {{ Form::selectGroup('employee_id','Select Employee', $customers, $timesheet->emp_id.'-'.$timesheet->person_type,['data-live-search'=>'true','required'=>true]) }}
        </div>
        <div class="table-responsive">
          <table class="mytable table table-bordered table-striped" >
            <thead>
              <tr>
                <th>Day/Date </th>
                <th>
                  <label class="label label-default mylabel">Mon</label>
                  <span id="day1" class="mylabel"  name="day1" ></span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Tue</label>
                  <span id="day2" class="mylabel"  name="day2"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Wed</label>
                  <span id="day3" class="mylabel"  name="day3"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Thu</label>
                  <span id="day4" class="mylabel"  name="day4"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Fri</label>
                  <span id="day5" class="mylabel"  name="day5"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Sat</label>
                  <span id="day6" class="mylabel"  name="day6"> </span>
                </th>
                <th>
                  <label class="label label-default mylabel" >Sun</label>
                  <span id="day7" class="mylabel"  name="day7"></span>
                </th>
                <th class="tablemiddel ">
                  Total <br>
                  Hours
                </th>
              </tr>
            </thead>
            <tbody>
              <tr>

                <td class="tablemiddel">REG Hours </td>
                <td> 
                  <input type="number" class="grid  mylabel ver" placeholder="0" min="00" id="monday" max="24" name="monday"  step="any">
                </td>
                <td > 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="tuesday" id="tuesday"  step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="wednesday" id="wednesday" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="thursday" id="thursday" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="friday" id="friday" step="any" >
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="saturday" id="saturday" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="sunday" id="sunday" step="any">
                </td>
                <td class="text-center tablemiddel editdisable span8" id="total_work_hours"> 
                  00
                </td>
              </tr>
              <tr>

                <td class="tablemiddel"> OT Hours </td>
                <td> 
                  <input type="number" class="grid  mylabel ver" placeholder="0" min="00" max="24" name="monday_ot" id="monday_ot" step="any">
                </td>
                <td > 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="tuesday_ot" id="tuesday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="wednesday_ot" id="wednesday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="thursday_ot" id="thursday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="friday_ot" id="friday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="0" max="24" name="saturday_ot" id="saturday_ot" step="any">
                </td>
                <td> 
                  <input type="number" class="grid  mylabel" placeholder="0" min="00" max="24" name="sunday_ot" id="sunday_ot" step="any">
                </td>
                <td class="text-center tablemiddel editdisable span9" id="total_ot_hours"> 
                  00
                </td>
              </tr>
              <tr class ="span7">
                <td class="tablemiddel"> Total Hours</td>
                <td class="tablemiddel editdisable text-center" id="mon_total"> 00
                </td>
                <td class="tablemiddel editdisable text-center" id="tue_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable text-center" id="wed_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable text-center" id="thu_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable text-center" id="fri_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable text-center" id="sat_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable text-center" id="sun_total"> 
                  00
                </td>
                <td class="tablemiddel editdisable total_hours text-center" id="total_hours" name="total_hours">
                  00
                </td>
              </tr>
            </tbody>
          </table>
        </div>

        <div >
          <div class="form-groupTextArea form-groupTextArea60  ">
            <textarea class="form-ControlTextArea form-ControlTextArea60"  name="work_report" id="work_report"></textarea>
           <label  class="form-label">Summury Of Weekly Work Report (Please Write atleast Two Sentences On The Project Worked)</label>
           <span class="form-controlBrd"></span>
          </div>
        </div>

        <div class="row">
          <div class="labelwidth100">
          {{ Form::fileGroup('client_docs', 'Client Approved Timesheet') }} 
          </div>
          <div class="col-lg-3 col-md-4 col-sm-6 ">
            <div class="form-group">
              <a id="DownloadTimeSheet" >
                <button type="button" class="btn btn-primary waves-effect waves-light" id="client_docs_view" style="display: none"> Download Timesheet</button>
              </a>
              </div>
          </div>
        </div>

        <div class="col-lg-3 col-md-4 col-sm-6 text-right" id="approved_button" style="display: none">
          <img src="https://openclipart.org/download/172030/Merlin2525-Approved-Business-Stamp-1.svg" width="100px" height="100px">
        </div>
        <span id="error_message_in_form" style="display: none;">
          <strong style="color:red"> Please Enter Less Than 24 hrs</strong>
        </span>
        <div class="form-group no-margin text-right" id="submit_button">
          <button type="submit"  class="btn btn-primary waves-effect waves-light" name="raise_time_sheet" value="1" >Submit
          </button>
        </div>

        {{ csrf_field() }}
        <input type="hidden" name="presentWeekNumber" id="presentWeekNumber" value="">
        <input type="hidden" name="presentYear" id="presentYear" value="">
        <input type="hidden" name="actual_week" id="actual_week" value="">
        <input type="hidden" name="actual_year" id="actual_year" value="">
        <input type="hidden" name="employee_payrate_id" id="employee_payrate_id" value=" {{-- $pay_rates->id --}} ">

        <!-- REG HOURS OLD -->
        <input type="hidden" name="get_mon_value_reg" id="get_mon_value_reg" value="">
        <input type="hidden" name="get_tue_value_reg" id="get_tue_value_reg" value="">
        <input type="hidden" name="get_wed_value_reg" id="get_wed_value_reg" value="">
        <input type="hidden" name="get_thu_value_reg" id="get_thu_value_reg" value="">
        <input type="hidden" name="get_fri_value_reg" id="get_fri_value_reg" value="">
        <input type="hidden" name="get_sat_value_reg" id="get_sat_value_reg" value="">
        <input type="hidden" name="get_sun_value_reg" id="get_sun_value_reg" value=""> 
        <!-- OT HOURS OLD -->
        <input type="hidden" name="get_mon_value_ot" id="get_mon_value_ot" value="">
        <input type="hidden" name="get_tue_value_ot" id="get_tue_value_ot" value="">
        <input type="hidden" name="get_wed_value_ot" id="get_wed_value_ot" value="">
        <input type="hidden" name="get_thu_value_ot" id="get_thu_value_ot" value="">
        <input type="hidden" name="get_fri_value_ot" id="get_fri_value_ot" value="">
        <input type="hidden" name="get_sat_value_ot" id="get_sat_value_ot" value="">
        <input type="hidden" name="get_sun_value_ot" id="get_sun_value_ot" value="">
  </div>
</div> 
</form>

<button type="button" id="WeeklyDataModelButton" class="btn btn-primary" data-toggle="modal" data-target="#WeeklyDataModel" style="display:none;">
</button>
 <!-- The Modal -->
<div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="WeeklyDataModel">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title" id="month_year"></h4>
         {{--  <button type="button" class="close" data-dismiss="modal">&times;</button> --}}
      </div> 
      <div class="modal-body">
        <div class="editor-indent">
          <div id="monthly_table">
              
          </div>
          <table class="timesheet" >
            <thead>
              <tr  id="days_list">
               
              </tr>

            </thead>
              <tbody >
                  <tr id="array_list">
                  </tr>
                  <tr id="array_list1">
                  </tr> 
                  <tr id="array_list_total">
                  </tr>
              </tbody>
          </table>
          </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script src="<?php echo url('/'); ?>/js/sortable/moment.js"></script>
<script type="text/javascript">
  $(document).ready(function(){


    $(':input[type="number"]').on('change blur',function(){
      if(!$('#employee_id').val()){
        //alert('Please Select Customer');
      };
    });

    

    
    // Year Display 
    var d = new Date();
    dd = d.getDate();
    var mm = d.getMonth()+1;
    var year = d.getFullYear(); 
    $('#employee_id').on('change',function(){
        var employee_id = $(this).val();
        if($("#actual_week").val() === moment().format('W')){
          var actual = moment().format('W');
        }else{
          var actual = $("#actual_week").val();
        }
        getWeekData(actual,year,employee_id);
    });
    // Current Week Of The Month  Done By Danda Satish
    window.onload = lastdateInit;
    function lastdateInit(){
        var weekNumber_1  = moment().startOf('isoweek').week();
        //document.getElementById("presentWeekNumber").value = weekNumber_1;

        var year = moment().format('YYYY');
        var startOfWeek = moment().startOf('isoweek').toDate();
        var tue = moment(startOfWeek).add(1,'days').toDate(); 
        var wed = moment(startOfWeek).add(2,'days').toDate(); 
        var thu = moment(startOfWeek).add(3,'days').toDate(); 
        var fri = moment(startOfWeek).add(4,'days').toDate(); 
        var sat = moment(startOfWeek).add(5,'days').toDate(); 
        var endOfWeek = moment().endOf('isoweek').toDate();
     
    
        var monDay = moment(startOfWeek).format("DD-MMM-YY");
        var tueDay = moment(tue).format("DD-MMM-YY");
        var wedDay = moment(wed).format("DD-MMM-YY");
        var thuDay = moment(thu).format("DD-MMM-YY");
        var friDay = moment(fri).format("DD-MMM-YY");
        var satDay = moment(sat).format("DD-MMM-YY");
        var sunDay = moment(endOfWeek).format("DD-MMM-YY");
      
        document.getElementById("day1").innerHTML = monDay;
        document.getElementById("day2").innerHTML = tueDay;
        document.getElementById("day3").innerHTML = wedDay;
        document.getElementById("day4").innerHTML = thuDay;
        document.getElementById("day5").innerHTML = friDay;
        document.getElementById("day6").innerHTML = satDay;
        document.getElementById("day7").innerHTML = sunDay;
      
        var actual = moment().format('W');
        var start  = moment(dd, "DD-MM-YY").startOf('isoWeek').format("DD-MMM-YY");
        var end    = moment(dd, "DD-MM-YY").endOf('isoWeek').format("DD-MMM-YY");

        var day1 = document.getElementById("day1").innerHTML;
        var actual_week  = moment(day1, "DD-MMM-YY").startOf('isoWeek').week();
        var actual_year  = moment(day1, "DD-MMM-YY").startOf('isoWeek').year();

        document.getElementById('presentWeek').innerHTML = start +' To '+ end; 
        document.getElementById('presentWeekNumber').value = actual; 
        document.getElementById('presentYear').value = year;
        document.getElementById("actual_week").value = actual_week;
        document.getElementById("actual_year").value = actual_year;
        var employee_id = $('#employee_id').val();
        if(employee_id){
          getWeekData(actual,year,employee_id);
        }
    }
    
    // Previous Week of The Month Done By Danda Satish
    $('#previousWeek').on('click',function(){

        var presentWeekNumber = document.getElementById('presentWeekNumber').value;


        var remove_week = +presentWeekNumber - 1;
       
        var year = moment().format('YYYY');
        var weekNumber = moment(year).add(+remove_week,'weeks').startOf('isoWeek');
       
        var tue = moment(weekNumber).add(1,'days').toDate(); 
        var wed = moment(weekNumber).add(2,'days').toDate(); 
        var thu = moment(weekNumber).add(3,'days').toDate(); 
        var fri = moment(weekNumber).add(4,'days').toDate(); 
        var sat = moment(weekNumber).add(5,'days').toDate();
        var startOfWeekEnd = moment(year).add(+remove_week,'weeks').endOf('isoWeek'); 
    
        var monDay = moment(weekNumber).format("DD-MMM-YY");
        var tueDay = moment(tue).format("DD-MMM-YY");
        var wedDay = moment(wed).format("DD-MMM-YY");
        var thuDay = moment(thu).format("DD-MMM-YY");
        var friDay = moment(fri).format("DD-MMM-YY");
        var satDay = moment(sat).format("DD-MMM-YY");
        var sunDay = moment(startOfWeekEnd).format("DD-MMM-YY");
    
        document.getElementById("day1").innerHTML = monDay;
        document.getElementById("day2").innerHTML = tueDay;
        document.getElementById("day3").innerHTML = wedDay;
        document.getElementById("day4").innerHTML = thuDay;
        document.getElementById("day5").innerHTML = friDay;
        document.getElementById("day6").innerHTML = satDay;
        document.getElementById("day7").innerHTML = sunDay;
        var day1   = document.getElementById("day1").innerHTML;
        var start  = moment(day1, "DD-MMM-YY").startOf('isoWeek').format("DD-MMM-YY");
        var end    = moment(day1, "DD-MMM-YY").endOf('isoWeek').format("DD-MMM-YY");
        
        var actual_week  = moment(day1, "DD-MMM-YY").startOf('isoWeek').week();
        var actual_year  = moment(day1, "DD-MMM-YY").startOf('isoWeek').year();

        document.getElementById('presentWeek').innerHTML = start +' To '+ end; 
        document.getElementById("presentWeekNumber").value = remove_week;
        document.getElementById('presentYear').value = year;
        document.getElementById("actual_week").value = actual_week;
        document.getElementById("actual_year").value = actual_year;
        $("#weekly_timecard_unsaved_msg").css('display','none');
        var employee_id = $('#employee_id').val();
        getWeekData(actual_week,actual_year,employee_id);   

    });
   
    
    // Next Week of The Month Done By Danda Satish
    $('#nextWeek').on('click',function(){

      var presentWeekNumber = document.getElementById('presentWeekNumber').value;

      var presentWeek = moment().startOf('isoweek').week();
       if (presentWeek > presentWeekNumber) { 
        var year = moment().format('YYYY');
        var add_week = +presentWeekNumber + 1;

        var weekNumber = moment(year).add(+add_week, 'weeks').startOf('isoweek');
        var tue = moment(weekNumber).add(1,'days').toDate(); 
        var wed = moment(weekNumber).add(2,'days').toDate(); 
        var thu = moment(weekNumber).add(3,'days').toDate(); 
        var fri = moment(weekNumber).add(4,'days').toDate(); 
        var sat = moment(weekNumber).add(5,'days').toDate();
        var startOfWeekEnd = moment(year).add(+add_week, 'weeks').endOf('isoWeek'); 
    
        var monDay = moment(weekNumber).format("DD-MMM-YY");
        var tueDay = moment(tue).format("DD-MMM-YY");
        var wedDay = moment(wed).format("DD-MMM-YY");
        var thuDay = moment(thu).format("DD-MMM-YY");
        var friDay = moment(fri).format("DD-MMM-YY");
        var satDay = moment(sat).format("DD-MMM-YY");
        var sunDay = moment(startOfWeekEnd).format("DD-MMM-YY");
    
        document.getElementById("day1").innerHTML = monDay;
        document.getElementById("day2").innerHTML = tueDay;
        document.getElementById("day3").innerHTML = wedDay;
        document.getElementById("day4").innerHTML = thuDay;
        document.getElementById("day5").innerHTML = friDay;
        document.getElementById("day6").innerHTML = satDay;
        document.getElementById("day7").innerHTML = sunDay;
    
        var day1 = document.getElementById("day1").innerHTML;
        var start  = moment(day1, "DD-MMM-YY").startOf('isoWeek').format("DD-MMM-YY");
        var end    = moment(day1, "DD-MMM-YY").endOf('isoWeek').format("DD-MMM-YY");

        var actual_week  = moment(day1, "DD-MMM-YY").startOf('isoWeek').week();
        var actual_year  = moment(day1, "DD-MMM-YY").startOf('isoWeek').year();
        

        document.getElementById('presentWeek').innerHTML = start +' To '+ end; 
        document.getElementById("presentWeekNumber").value = add_week;
        document.getElementById('presentYear').value = year;
        document.getElementById("actual_week").value = actual_week;
        document.getElementById("actual_year").value = actual_year;
        $("#weekly_timecard_unsaved_msg").css('display','none');
        var employee_id = $('#employee_id').val();
        getWeekData(actual_week,actual_year,employee_id);

      }else{

        return false;
      }
    });

      
    var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    for (i = new Date().getFullYear() ; i > new Date().getFullYear()-1; i--) {
      $.each(months, function (index, value) {
          $('#month').append($('<option />').val(index+1).html(value + "-" + i));
      });                
    }

     var frm = $('#weeks_wise_working_hours');
         
      frm.submit(function (e) {
          e.preventDefault();
          $('#error_message_in_form').hide();
          var employee_id = $('#employee_id').val();
          if(!employee_id){
            alert('plaese select customer');
            return false;
          }
          if($('#mon_total').html() > '24' || $('#tue_total').html() > '24' || $('#wed_total').html() > '24'|| $('#thu_total').html() > '24' || $('#fri_total').html() > '24'|| $('#sat_total').html() > '24' || $('#sun_total').html() > '24')
          {
            $('#error_message_in_form').show();
            return false; 
          }

          $("#weekly_timecard_unsaved_msg").css('display','none');
          actual_week = document.getElementById("actual_week").value;
          actual_year = document.getElementById("actual_year").value;
          

          var formData = new FormData(this);

          formData.append('day1', document.getElementById("day1").innerHTML);
          formData.append('day2', document.getElementById("day2").innerHTML);
          formData.append('day3', document.getElementById("day3").innerHTML);
          formData.append('day4', document.getElementById("day4").innerHTML);
          formData.append('day5', document.getElementById("day5").innerHTML);
          formData.append('day6', document.getElementById("day6").innerHTML);
          formData.append('day7', document.getElementById("day7").innerHTML);
          formData.append('total_hours', document.getElementById("total_hours").innerHTML);
          formData.append('total_work_hours',document.getElementById("total_work_hours").innerHTML);
          formData.append('total_ot_hours',document.getElementById("total_ot_hours").innerHTML);

          $.ajax({
              type: frm.attr('method'),
              url:  frm.attr('action'),
              data: formData ,
              processData: false,
              contentType: false,
              success: function (data) {
                $('#weekly_timecard_saved_msg').css('display','inline');
                $('#weekly_timecard_saved_msg').delay(3000).fadeOut(800);
                
                getWeekData(actual_week,actual_year,employee_id);
              },
              error: function (data) {
                $("#weekly_timecard_unsaved_msg").css('display','inline');
                 
              },
          });
      });

      

      frm.on("change", ":input:not(#employee_id)", function() {
        $("#weekly_timecard_unsaved_msg").css('display','inline');
      });


      $(".grid").each(function () {
          $(this).keyup(function () {
              calculateSum();
          });
      });

      $("#sum_table tr:not(:first)  td:nth-last-child(1)").text(function(){
          var t = 0;
          $(this).prevAll().each(function(){ 
              t += parseFloat( $(this).text(), 10 ) || 0;
          });
          return t;
      });

    function getWeekData(id,year,employee_id){
      $.ajax({
        url:'<?php echo url('timeheet_weekly_data'); ?>',
        data:'id='+id+"&year="+year+"&employee_id="+employee_id,
        
        success: function(data){
          var data1     = $.parseJSON(data);

          if(data1){
            var approved_hours = $.parseJSON(data1.approved_days);
            var disa  = '';
            var total_wh = 0;
            if(data1.monday === null || typeof(data1.monday) === 'undefined'){
              $('#monday').val('').removeClass('current_cell');
              $('#monday_ot').val('').removeClass('current_cell');
              $('#mon_total').html('00');
              $('#get_mon_value_reg').val('0');
              $('#get_mon_value_ot').val('0');
            }else{
              var monday    = $.parseJSON(data1.monday);
              if(approved_hours.monday === 'approved'){
                disa = 'disabled';
              }else{ disa = ''; }
              $('#monday').val(monday.WH).addClass('current_cell').prop('disabled',disa);
              $('#monday_ot').val(monday.OT).addClass('current_cell').prop('disabled',disa);
              $('#mon_total').html(+monday.WH + +monday.OT);
              $('#get_mon_value_reg').val(monday.WH);
              $('#get_mon_value_ot').val(monday.OT);
            }if(data1.tuesday === null || typeof(data1.tuesday) === 'undefined'){
              $('#tuesday').val('').removeClass('current_cell');
              $('#tuesday_ot').val('').removeClass('current_cell');
              $('#tue_total').html('00');
              $('#get_tue_value_reg').val('0');
              $('#get_tue_value_ot').val('0');
            }else{
              var tuesday   = $.parseJSON(data1.tuesday);
              if(approved_hours.tuesday === 'approved'){
                disa = 'disabled';
              }else{ disa = ''; }
              $('#tuesday').val(tuesday.WH).addClass('current_cell').prop('disabled',disa);
              $('#tuesday_ot').val(tuesday.OT).addClass('current_cell').prop('disabled',disa);
              $('#tue_total').html(+tuesday.WH + +tuesday.OT);
              $('#get_tue_value_reg').val(tuesday.WH);
              $('#get_tue_value_ot').val(tuesday.OT);
            }if(data1.wednesday === null || typeof(data1.wednesday) === 'undefined'){
              $('#wednesday').val('').removeClass('current_cell');
              $('#wednesday_ot').val('').removeClass('current_cell');
              $('#wed_total').html('00');
              $('#get_wed_value_reg').val('0');
              $('#get_wed_value_ot').val('0');
            }else{
              var wednesday = $.parseJSON(data1.wednesday);
              if(approved_hours.wednesday === 'approved'){
                disa = 'disabled';
              }else{ disa = ''; }
              $('#wednesday').val(wednesday.WH).addClass('current_cell').prop('disabled',disa);
              $('#wednesday_ot').val(wednesday.OT).addClass('current_cell').prop('disabled',disa);
              $('#wed_total').html(+wednesday.WH + +wednesday.OT);
              $('#get_wed_value_reg').val(wednesday.WH);
              $('#get_wed_value_ot').val(wednesday.OT);
            }if(data1.thursday === null || typeof(data1.thursday) === 'undefined'){
              $('#thursday').val('').removeClass('current_cell');
              $('#thursday_ot').val('').removeClass('current_cell');
              $('#thu_total').html('00');
              $('#get_thu_value_reg').val('0');
              $('#get_thu_value_ot').val('0');
            }else{
              var thursday  = $.parseJSON(data1.thursday);
              if(approved_hours.thursday === 'approved'){
                disa = 'disabled';
              }else{ disa = ''; }
              $('#thursday').val(thursday.WH).addClass('current_cell').prop('disabled',disa);
              $('#thursday_ot').val(thursday.OT).addClass('current_cell').prop('disabled',disa);
              $('#thu_total').html(+thursday.WH + +thursday.OT);
              $('#get_thu_value_reg').val(thursday.WH);
              $('#get_thu_value_ot').val(thursday.OT);
            }if(data1.friday === null || typeof(data1.friday) === 'undefined'){
              $('#friday').val('').removeClass('current_cell');
              $('#friday_ot').val('').removeClass('current_cell');
              $('#fri_total').html('00');
              $('#get_fri_value_reg').val('0');
              $('#get_fri_value_ot').val('0');
            }else{
              var friday    = $.parseJSON(data1.friday);
              if(approved_hours.friday === 'approved'){
                disa = 'disabled';
              }else{ disa = ''; }
              $('#friday').val(friday.WH).addClass('current_cell').prop('disabled',disa);
              $('#friday_ot').val(friday.OT).addClass('current_cell').prop('disabled',disa);
              $('#fri_total').html(+friday.WH + +friday.OT);
              $('#get_fri_value_reg').val(friday.WH);
              $('#get_fri_value_ot').val(friday.OT);
            }if(data1.saturday === null || typeof(data1.saturday) === 'undefined'){
              $('#saturday').val('').removeClass('current_cell');
              $('#saturday_ot').val('').removeClass('current_cell');
              $('#sat_total').html('00');
              $('#get_sat_value_reg').val('0');
              $('#get_sat_value_ot').val('0');
            }else{
              var saturday  = $.parseJSON(data1.saturday);
               if(approved_hours.saturday === 'approved'){
                disa = 'disabled';
              }else{ disa = ''; }
             $('#saturday').val(saturday.WH).addClass('current_cell').prop('disabled',disa);
             $('#saturday_ot').val(saturday.OT).addClass('current_cell').prop('disabled',disa);
             $('#sat_total').html(+saturday.WH + +saturday.OT);
             $('#get_sat_value_reg').val(saturday.WH);
             $('#get_sat_value_ot').val(saturday.OT);
            }if(data1.sunday === null || typeof(data1.sunday) === 'undefined'){
              $('#sunday').val('').removeClass('current_cell');
              $('#sunday_ot').val('').removeClass('current_cell');
              $('#sun_total').html('00');
              $('#get_sun_value_reg').val('0');
              $('#get_sun_value_ot').val('0');
            }else{
              var sunday    = $.parseJSON(data1.sunday);
              if(approved_hours.sunday === 'approved'){
                disa = 'disabled';
              }else{ disa = ''; }
              $('#sunday').val(sunday.WH).addClass('current_cell').prop('disabled',disa);
              $('#sunday_ot').val(sunday.OT).addClass('current_cell').prop('disabled',disa);
              $('#sun_total').html(+sunday.WH + +sunday.OT);
              $('#get_sun_value_reg').val(sunday.WH);
              $('#get_sun_value_ot').val(sunday.OT);
            }if(data1.total_hours != null){
              $('#total_hours').html(data1.total_hours);
            }if(data1.total_hours == null){
              $('#total_hours').html('00');
            }if(data1.total_work_hours != null){
              $('#total_work_hours').html(data1.total_work_hours);
            }if(data1.total_work_hours == null){
              $('#total_work_hours').html('00');
            }if(data1.total_ot_hours != null){
              $('#total_ot_hours').html(data1.total_ot_hours);
            }if(data1.total_ot_hours == null){
              $('#total_ot_hours').html('00');
            }if(data1.work_report != null){
              $('#work_report').val(data1.work_report);  
            }if(data1.work_report == null){
              $('#work_report').val('');
            }if(data1.client_attachmnet != null ){
              $('#client_docs').hide();
              $('#client_docs_view').show();
              $('#client_docs_view').val(data1.client_attachmnet);
              $("#DownloadTimeSheet").attr('href', '{{ url('downloadClientSheet') }}/'+data1.client_attachmnet);
            }if(data1.client_attachmnet == ""){
              $('#client_docs').show();
              $('#client_docs_view').hide();
            }if(data1.approved_status == 1 || data1.approved_status == 0){
             //  $("input").each(function () {
             //    $(this).attr("disabled","disabled");
             //  });
             // $('#work_report').attr("disabled","disabled");
             // $('#submit_button').hide();
             // $('#approved_button').show();
            }if(data1.approved_status != 1){
             $("input").each(function () {
              $(this).removeAttr("disabled");
              });
              $('#work_report').removeAttr("disabled");
              $('#submit_button').show();
              $('#approved_button').hide();
            }
          }else{
            $('#monday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#tuesday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#wednesday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#thursday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#friday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#saturday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#sunday').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#monday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#tuesday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#wednesday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#thursday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#friday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#saturday_ot').val('').removeAttr('disabled').css('cursor','auto').removeClass('current_cell');
            $('#sunday_ot').val('').removeAttr('disabled').css('cursor','auto')
                            .removeClass('current_cell');
            $('#total_hours').html('00');
            $('#work_report').val('');
            $('#mon_total').html('00');
            $('#tue_total').html('00');
            $('#wed_total').html('00');
            $('#thu_total').html('00');
            $('#fri_total').html('00');
            $('#sat_total').html('00');
            $('#sun_total').html('00');
            $('#get_mon_value_reg').val('0');
            $('#get_tue_value_reg').val('0');
            $('#get_wed_value_reg').val('0');
            $('#get_thu_value_reg').val('0');
            $('#get_fri_value_reg').val('0');
            $('#get_sat_value_reg').val('0');
            $('#get_sun_value_reg').val('0');
            $('#get_mon_value_ot').val('0');
            $('#get_tue_value_ot').val('0');
            $('#get_wed_value_ot').val('0');
            $('#get_thu_value_ot').val('0');
            $('#get_fri_value_ot').val('0');
            $('#get_sat_value_ot').val('0');
            $('#get_sun_value_ot').val('0');
            $('#total_work_hours').html('00');
            $('#total_ot_hours').html('00');
            $('#client_docs').show();
            $('#client_docs_view').hide();
            $('#DownloadTimeSheet').attr('href','#');
            $("input").each(function () {
              $(this).removeAttr("disabled");
            });
            $('#work_report').removeAttr("disabled");
            $('#submit_button').show();
            $('#approved_button').hide();
          }
        },
        error:function(){
          $('#monday').val('');
          $('#tuesday').val('');
          $('#wednesday').val('');
          $('#thursday').val('');
          $('#friday').val('');
          $('#saturday').val('');
          $('#sunday').val('');
          $('#monday_ot').val('');
          $('#tuesday_ot').val('');
          $('#wednesday_ot').val('');
          $('#thursday_ot').val('');
          $('#friday_ot').val('');
          $('#saturday_ot').val('');
          $('#sunday_ot').val('');
          $('#total_hours').html('00');
          $('#work_report').val('');
          $('#mon_total').html('00');
          $('#tue_total').html('00');
          $('#wed_total').html('00');
          $('#thu_total').html('00');
          $('#fri_total').html('00');
          $('#sat_total').html('00');
          $('#sun_total').html('00');
          $('#get_mon_value_reg').val('0');
          $('#get_tue_value_reg').val('0');
          $('#get_wed_value_reg').val('0');
          $('#get_thu_value_reg').val('0');
          $('#get_fri_value_reg').val('0');
          $('#get_sat_value_reg').val('0');
          $('#get_sun_value_reg').val('0');
          $('#get_mon_value_ot').val('0');
          $('#get_tue_value_ot').val('0');
          $('#get_wed_value_ot').val('0');
          $('#get_thu_value_ot').val('0');
          $('#get_fri_value_ot').val('0');
          $('#get_sat_value_ot').val('0');
          $('#get_sun_value_ot').val('0');
          $("input").each(function () {
              $(this).removeAttr("disabled");
          });
          $('#work_report').removeAttr("disabled");
          $('#submit_button').show();
          $('#approved_button').hide();
        },
      });
    }

  });

    $(document).on('keyup', 'input[type="number"]', function () {
        // var _this = $(this);
        // var min = parseInt(_this.attr('min')) || 1; // if min attribute is not defined, 1 is default
        // var max = parseInt(_this.attr('max')) || 24; // if max attribute is not defined, 24 is default
        // var val = parseInt(_this.val()) || (min - 1); // if input char is not a number the value will be (min - 1) so first condition will be true
        // if(val < min)
        //     _this.val( min );
        // if(val > max)
        //     _this.val( max );
    });


  function calculateSum() {
      var sum = 0;
      
      $(".grid").each(function () {
          if (!isNaN(this.value) && this.value.length != 0) {
              sum += parseFloat(this.value);
          }
      });
      
      var sumQ = [];
      for (var i=1; i<=7; i++) {
          sumQ[i] = 0;
          $('td:nth-child('+(i+1)+')').find(".grid").each(function () {
              if (!isNaN(this.value) && this.value.length != 0) {
                  var _this = $(this);
                  var min = parseInt(_this.attr('min')) || 1; 
                  var max = parseInt(_this.attr('max')) || 24;  
                  var val = parseInt(_this.val()) || (min - 1);  
                  if(val < min)
                      _this.val( min );
                  if(val > max)
                      _this.val( max );   
                  sumQ[i] += parseFloat(this.value);
              }
          });
          $(".span7").find('td').eq(i).html(sumQ[i]); 


          if(sumQ[i] > '24'){
            $(".span7").find('td').eq(i).css('color','red');
            console.log('You Can not Enter more than 24 Hrs');
          }else{
             $(".span7").find('td').eq(i).css('color','black');
          };

           calculateRowSum();
      }
      // Total Hours Count
      calculateTotal(); 
  }
  function calculateRowSum(){
    $('.mytable tr:has(td):not(:last)').each(function(){
      var sum = 0; 
      $(this).find('td').each(function(){
         sum += parseFloat($(this).find('.grid').val()) || 0;
      });
      $(this).find('td:last').html(sum);
       
    });
  }
  function calculateTotal(){
    var sumT = [];
        sumT[i] = 0;
        $('td').find('.grid').each(function () {
           var combat = $(this).val();
           if (!isNaN(combat) && combat.length !== 0) {
               sumT[i] += parseFloat(combat);
           }
        });
      $('.total_hours').html(sumT[i]);
  }
  function isNumberKey(evt){
    var charCode = (evt.which) ? evt.which : event.keyCode
    if (charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
  }
</script>

<script type="text/javascript">
 
 function getWeekwiseDataModel(week,month,year){
       $.ajax({
           url: '<?php echo url('/getDataWeekAjaxinMonth');?>',
           data:'week='+week+'&month='+month+'&year='+year,
           success: function(result){
               // $(".bs-example-modal-lg").modal({
               //     backdrop: 'static',
               //     keyboard: false
               // }); 
               $("#WeeklyDataModelButton").trigger('click');
               var d = new Date();
                formattedMonth = moment(result.month, 'MM').format('MMM');
                 var s = new Date(result.start);
                 var l = new Date(result.last);
                 start_date = s.getDate();
                 last_date = l.getDate();
               $('#month_year').html(formattedMonth + '-' + year);
              if (Object.keys(result.arrayName).length) {
                console.log(typeof(result.arrayName));
                var row = $('#days_list');
                var rowData = $('#array_list');
                var rowData1 = $('#array_list1');
                var rowDataTotal = $('#array_list_total');
                row.empty();
                rowData.empty();
                rowData1.empty();
                rowDataTotal.empty();
                $('#monthly_table').empty();
                row.append($('<th>').html(start_date + formattedMonth + '-' + last_date + formattedMonth));
                rowData.append($('<td>').html('REG'));
                rowData1.append($('<td>').html('OT'));
                rowDataTotal.append($('<td>').html('Total'));

                 keys = Object.keys(result.arrayName),
                  i, len = keys.length;

                keys.sort();

                for (i = 0; i < len; i++) {
                  k = keys[i];
                  row.append($('<th>').html(k)); 
                  var values = $.parseJSON(result.arrayName[k]);
                  rowData.append($('<td>').html(values.WH));  
                  rowData1.append($('<td>').html(values.OT));
                  rowDataTotal.append($('<td>').html(+values.WH + +values.OT));
                }

              /*  $.each(result.arrayName, function(key, value) {
               
                  row.append($('<th>').html(key)); 
                  var values = $.parseJSON(value);
                  rowData.append($('<td>').html(values.WH));  
                  rowData1.append($('<td>').html(values.OT));
                  rowDataTotal.append($('<td>').html(+values.WH + +values.OT));
                }); */              
              }
            },
          error:function(result){
            $(".bs-example-modal-lg").modal({
                   backdrop: 'static',
                   keyboard: false
            }); 
            $('#monthly_table').empty();
             var row = $('#days_list');
              var rowData = $('#array_list');
              var rowData1 = $('#array_list1');
              var rowDataTotal = $('#array_list_total');
              row.empty();
              rowData.empty();
              rowData1.empty();
              rowDataTotal.empty();
              rowData.append($('<h1>').html('NO Dates Found'));
          }
       });
   }
   function getMonthwiseDataModel(month,year){
      $('#monthly_table').empty(); 
       $.ajax({
           url: '<?php echo url('/getDataMonthAjaxinMonth');?>',
           data:'&month='+month+'&year='+year,
           success: function(result){
                   $(".bs-example-modal-lg").modal({
                   backdrop: 'static',
                   keyboard: false
            }); 
              var row = $('#days_list');
              var rowData = $('#array_list');
              var rowData1 = $('#array_list1');
              var rowDataTotal = $('#array_list_total');
              row.empty();
              rowData.empty();
              rowData1.empty();
              rowDataTotal.empty();    
              $('#monthly_table').html(result);    
            }
       });
   }
</script>
@stop

