@extends('layouts.default')

@section('title', trans('general.title.new', ['type' => trans_choice('general.setuppayrole', 1)]))
@section('content')
 
<div class="container-fluid">
    {!! Form::open(['method' => 'POST', 'url' => '/payrole/setuppayrole', 'class' =>
    'form-horizontal', 'id'=>'']) !!} 
    <div class="row">
        {{ Form::textGroup('month_from', 'Month From', 'calendar',['id' => 'month_from', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => '' ], Date::now()->startOfMonth()->format($date_format) ) }}

        {{ Form::textGroup('month_to', 'Month To', 'calendar',['id' => 'month_to', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => '' ], Date::now()->endOfMonth()->format($date_format) ) }}

        {{ Form::textGroup('checked_at', "Check Date", 'calendar',['id' => 'checked_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => '' ], Date::now()->format($date_format) ) }}


    </div>  
    <div class="row">
        <table id="verticleTable" class="table tabl-input table-striped table-bordered nowrap" >
            <thead>
                <tr>
                    <th>Consultant Name</th>
                    <th>Vendor Name</th>
                    <th>Payrate Regular</th>
                    <th>Regular Hours</th>
                    <th>Salary Amount</th>
                    <th>Payrate OT</th>
                    <th>OT Hours</th>
                    <th>Misc Amount</th>
                    <th>Final Amount</th>
                    <th>Reimbursement Amount</th>
                </tr>
            </thead>
            <tbody>
            	@foreach($customers as $customer)
            	<tr>
            		<td>{{ $customer->name }}</td>

            		<td>
                        <select class="selectpicker" id="vendor_id" data-live-search="true"> 
                            <option value=""> Select Vendor</option>
                            @foreach($customer->payrates as $vendors)
                                <option  >{{ $vendors->vendor  }}</option>
                            @endforeach
                        </select>
                    </td>
            		<td> {{ Form::textGroup1('payrate_reg', ' ') }} </td>
            		<td> {{ Form::textGroup1('regular_hours', ' ') }} </td>
            		<td> {{ Form::textGroup1('salary_amount', ' ') }} </td>
            		<td> {{ Form::textGroup1('payrate_ot', ' ') }} </td>
            		<td> {{ Form::textGroup1('ot_hours', ' ') }} </td>
            		<td> {{ Form::textGroup1('misc_amount', ' ') }} </td>
            		<td> {{ Form::textGroup1('final_amount', ' ') }} </td>
            		<td> {{ Form::textGroup1('rei_amount', ' ') }} </td>
            	</tr>
            	@endforeach
            </tbody>
        </table>
        <div class="col-md-12 " style="margin-top:12px">
            <div class="form-group no-margin text-right">
                <a href="{{ url('payrole/setuppayrole') }}"
                    class="btn mr-3 btn-default waves-effect waves-gray">Cancel</a>
                <button type="submit" class="btn btn-primary waves-effect waves-light">Save</button>
            </div>
        </div>
        {{ Form::close() }}
    </div>
</div>
<script type="text/javascript">
$(document).ready(function(){

	//Date picker
	$('#checked_at').datepicker({
	    format: '{{ $date_format }}',
	    autoclose: true,
	});
	$('#month_from').datepicker({
	    format: '{{ $date_format }}',
	    autoclose: true,
	});//Date picker
	$('#month_to').datepicker({
	    format: '{{ $date_format }}',
	    autoclose: true,
	});
    $('#vendor_id').on('change',function(){
        alert($(this).val());
    });

});
	
</script>

 
@endsection