@extends('layouts.default')
@section('title', isset($title)?$title:'')

<link rel="stylesheet" href="{{ ('/acs/reports/style.css') }}">

@section('content')
<style>
    .form-group {
        min-height: 25px !important;
        margin-bottom: 0px !important;
    }
</style>
<div class="container-fluid">
    {!! Form::open(['method' => 'POST', 'url' => '/payrole/runpayrole/run_payrole', 'class' =>
    'form-horizontal', 'id'=>'form1']) !!}

    <div class="form-group{{ $errors->has('year') ? ' has-error' : '' }}">
        <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-3">
                <small>Select Month</small>
                {!! Form::selectMonth('month', date('m'), ['class' => 'selectpicker', 'required' =>
                'required', 'onchange'=>'formSubmit();', 'style'=>'width: 100%;']) !!}
                <small class="text-danger">{{ $errors->first('year') }}</small>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-3">
                <small>Select Year</small>
                {!! Form::selectYear('year', date('Y') - 6, date('Y')+2, date('Y'), ['class' => 'selectpicker',
                'required' =>
                'required', 'onchange'=>'formSubmit();', 'style'=>'width: 100%;']) !!}
                <small class="text-danger">{{ $errors->first('year') }}</small>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
    <div class="runpay-role">
    <div class="row" id="pageContent">

        {{Form::open(['url'=>'payrole/runpayrole','role'=>'form', 'autocomplete'=>'off', 'style'=>'width: 100%;'])}}
        {{ Form::hidden('month', null, ['id'=>'monthValue']) }}
        {{ Form::hidden('year', null, ['id'=>'yearValue']) }}
        <table id="verticleTable" class="table table-striped table-bordered nowrap">
            <thead>
                <tr>
                    <th>Vendor</th>
                    <th>Consultant</th>
                    <th>Previous Hours</th>
                    @foreach($weekDates as $day)
                    <th>{{ date('M-d', strtotime($day['start'])).'-'.date('M-d', strtotime($day['end'])) }}</th>
                    @endforeach
                    <th>Total</th>
                    <th>Payrate</th>
                    <th>Amount</th>
                    <th>Updated Payrates</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($list as $li)
                @php
                    $gtotal = [];
                    $ttotal = [];
                    $ptotal = [];
                    $total = 0;
                @endphp
                <tr>
                    <td title="{{ $li['parent'] }}">{!! str_limit($li['parent'], 15) !!}</td>
                    <td title="{{ $li['name'] }}">{!! str_limit($li['name'], 15) !!}</td>
                    <td>{{ Form::textGroup1('prev_hrs[]', ' ') }}</td>
                    @for ($j = 1; $j <= count($weekDates); $j++) 
                    @php $name='week' .$j.'[]'; @endphp 

                        @if($li['week'.$j]) 
                            @php
                                $total = $total + $li[$j];
                            @endphp             
                            <td>{{ Form::textGroup1($name, ' ', null, [], $li[$j]) }}</td>
                        @else
                            @php
                                $total = $total;
                            @endphp
                            <td>{{ Form::textGroup1($name, ' ') }}</td>
                        @endif
                    @endfor

                        <td>{{ Form::textGroup1('total[]', ' ', null, [], $total) }}</td>
                        <td>{{ Form::textGroup1('payrate[]', ' ') }}</td>
                        <td> {{ Form::textGroup1('amount[]', ' ') }} </td>
                        <td>{{ Form::textGroup1('updated[]', ' ') }}</td>
                        <td>{{ Form::textGroup1('notes[]', ' ') }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        <div class="col-md-12 " style="margin-top:12px">
            <div class="form-group no-margin text-right">
                <a href="{{ url('payrole/runpayrole') }}"
                    class="btn mr-3 btn-default waves-effect waves-gray">Cancel</a>
                <button type="submit" class="btn btn-primary waves-effect waves-light">Save</button>
            </div>
        </div>
        {{ Form::close() }}
    </div>
</div>
</div>

<script>
    function formSubmit() {
        $("#month").val();
        $("#month").val();
        $("#form1").submit();
  }
</script>
@endsection