@extends('layouts.default')
@section('header-links')
    @include('accounts.payrole.header')
@endsection
@section('title','Paystubs')

@section('content')

<div class="card">
		{{ Form::open() }}
		<div class="row">

			{{ Form::selectGroup('employee','Employee',null,$employees,null,['required'=>'required','data-live-search'=>'true'],'col-lg-3 col-md-4 col-sm-6') }}

			{{ Form::textGroup('checked_from','Check Date From', 'calendar',['id' => 'checked_from', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => '' ], Date::now()->format($date_format) ) }}

			{{ Form::textGroup('checked_to','Check Date To', 'calendar',['id' => 'checked_to', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => '' ], Date::now()->format($date_format) ) }} 
			
			<div class="col-lg-3 col-md-4 col-sm-6">
			    <div class="form-group">
			        <button type="button" class="btn btn-primary waves-effect waves-light">Find</button>
			    </div>
			</div>
			{{ csrf_field() }}
		</div>
		{{ Form::close() }}
</div>
 <table class="table table-show table-striped table-hover table-bordered" id="tbl-accounts">
                <thead>
                    <tr>
                        <th>Check Date</th>
                        <th>Check Number</th>
                        <th>Total Paid</th>
                        <th>Net Pay</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                    	<td></td>
                    	<td></td>
                    	<td></td>
                    	<td></td>
                    	<td></td>
                    </tr>
                </tbody>
            </table>

<script>
	$(document).ready(function(){
		$('#employee').on('change',function(){

		});

		$('#checked_from').datepicker({
			format: '{{ $date_format }}', 
			autoclose: true
		});
		$('#checked_to').datepicker({
			format: '{{ $date_format }}', 
			autoclose: true
		});
	});

</script>
@endsection