@extends('layouts.default')
@section('header-links')
    @include('accounts.payrole.header')
@endsection
@section('title', trans('payrole.payrole') .' '. trans('payrole.summary'))
@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
	<a href="{{ url('payrole/payrole/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create ADP Payrole"><i class="material-icons left">add</i>{{ trans_choice('general.enterpayrole', 1) }}</a>

@endsection

@section('content')
<div class="card">
<table  class="table table-show table-striped table-filter" id="horizontalTable">
	<thead>
		<tr>
		    <th>{{  trans('payrole.payperiod') }}</th>
		    <th>{{  trans('payrole.paydate') }}</th>
		    <th>Name</th>
		    <th>{{ trans_choice('payrole.hour',2) }}</th>
		    <th>Total Paid</th>
		    <th>Tax Held</th>
		    <th>{{ trans('payrole.deductions') }}</th>
		    <th>{{ trans('payrole.netpay') }}</th>
		    <th>Check</th>
		    <th>Employee Liability</th>
		    <th>Total Expense</th>
		    <th>Actions</th>
		</tr>
	</thead>
	<tbody>
		@php 
			$grosspay = 0; 
			$tax   = 0;
			$netpay = 0;
			$hours  = 0;
		@endphp
		@foreach($payroles as $payrole)

		<tr>
			<td>{{ Date::parse(explode('-',$payrole->payperiod)[0])->format($date_format) .' - '. Date::parse(explode('-',$payrole->payperiod)[1])->format($date_format)  }}</td>
		    <td>{{ Date::parse($payrole->paydate)->format($date_format) }}</td>
		    <td>{{ $payrole->user->name }}</td>
		    <td>{{ $payrole->consultant_hours }}</td>
		    <td>@money($payrole->grosspay,'USD',true)</td>
		    <td>@money(($payrole->emp_tax + $payrole->emper_tax),'USD',true)</td>
		    <td>@money(($payrole->emp_tax + $payrole->emper_tax),'USD',true)</td>
		    <td>@money($payrole->netpay,'USD',true)</td>
		    <td>{{ $payrole->checkstatus }}</td>
		    <td>{{ $payrole->id }}</td>
		    <td>{{ $payrole->id }}</td>
		    <td><a class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('payrole/payrole/'.$payrole->id.'/edit' ) }}"><i class="material-icons">create</i></a></td>
		</tr>
		@php 
			$grosspay += $payrole->grosspay;
			$tax      += $payrole->emp_tax + $payrole->emper_tax;
			$netpay   += $payrole->netpay;
			$hours 	  += $payrole->consultant_hours;
		@endphp
	  @endforeach

	</tbody>
	<tfoot >
		<tr>
			<th >Pay Frequency Totals</th>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<th>{{ $hours }}</th>
			<th>@money($grosspay,'USD',true)</th>
			<th>@money($tax,'USD',true)</th>
			<th>--</th>
			<th>@money($netpay,'USD',true)</th>
			<th>&nbsp</th>
			<th>--</th>
			<th>--</th>
			<th>&nbsp</th>
		</tr>
		
		<tr>
			<th >Company Total</th>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<th>{{ $hours }}</th>
			<th>@money($grosspay,'USD',true)</th>
			<th>@money($tax,'USD',true)</th>
			<th>--</th>
			<th>@money($netpay,'USD',true)</th>
			<th>&nbsp;</th>
			<th>--</th>
			<th>--</th>
			<th>&nbsp</th>
		</tr>
		<tr>
			<th >Total Net Pays for Compan</th>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			
		</tr>
	</tfoot>
</table>
</div>
@endsection
 