@extends('layouts.default')

@section('title', trans('general.title.edit', ['type' => trans_choice('general.enterpayrole', 1)]))

@section('content')

<div class="card">
	{!!  Form::model($payrole,['url'=>['payrole/payrole',$payrole->id],'role'=>'form','method'=>'PATCH'])  !!}
	<div class="row"> 
		{{  Form::hidden('payrole_id',$payrole->id) }}
		{{ Form::selectGroup('employee', 'Consultant', $employees, null, ['required'=>'required']) }}

		{{ Form::textGroup('payperiod',trans('payrole.payperiod'), null, ['id'=>'payperiod']) }}

		{{ Form::textGroup('paydate', trans('payrole.paydate'), Date::now()->format($date_format), ['id'=>'paydate']) }}


		{{ Form::selectGroup('salarytype',trans('payrole.salary_type'), ['salary_based' => 'Salary Based' , 'hourly_based' => 'Hourly Based'], null, ['required' => 'required','id'=>'salarytype']) }}

		{{ Form::textGroup('vendor_payrate',trans('payrole.vendor_payrate'),null,['id'=>'vendor_payrate','required'=>'required']) }}

		{{ Form::textGroup('consultant_payrate', trans('payrole.consultant_payrate'), null, ['id'=>'consultant_payrate','required'=>'required']) }}
		
		{{ Form::textGroup('consultant_hours', trans('payrole.consultant_hours'), null, ['id'=>'consultant_hours','required'=>'required']) }}

		{{ Form::textGroup('adphours', 'ADP'.trans_choice('payrole.hour',2), null, []) }}

		{{ Form::textGroup('invoice_amount',trans('payrole.invoice_amount'), null, ['id'=>'invoice_amount','required'=>'required']) }}
		
		{{-- {{ Form::textGroup('amount',trans('payrole.amount'), null, ['id'=>'amount','required'=>'required']) }} --}}

		{{-- {{ Form::textGroup('adpsalary', 'ADP '.trans('payrole.salary'), null, []) }} --}}

		{{ Form::textGroup('grosspay', trans('payrole.grosspay'), null, ['id'=>'grosspay']) }}

		{{  Form::textGroup('emp_tax', trans('payrole.emp_tax'), null, ['id'=>'emp_tax']) }}

		{{  Form::textGroup('emper_tax', trans('payrole.emper_tax'), null, ['id'=>'emper_tax']) }}	

		{{  Form::textGroup('netpay', trans('payrole.netpay'), null, ['id'=>'netpay']) }}

		{{ Form::selectGroup('payfrequency', trans('payrole.payfrequency'), ['30days'=>'30 Days','15days'=>'15 Days'], null) }}

		{{ Form::selectGroup('check_type', trans('payrole.check'), ['dd'=>'DD','manual'=>'Manual'], null) }}
	
		<div class="col-lg-3 col-md-4 col-sm-6" id="check_div" style="display: none">
			<div class="form-group">
				<input type="text" class="form-control" id="check_num" name="check_num" />
				<label class="form-label">{{ trans('payrole.check_num') }}</label>
				<span class="form-controlBrd"></span>
				<div class="help-block with-errors"></div>
			</div>
		</div>
	
		{{ Form::saveButton('payrole/runpayrole') }}

	</div>
	{!!  Form::close() !!}
</div>

<link rel="stylesheet" type="text/css" href="{{ asset('accounts/css/daterangepicker.css') }}" />
<script type="text/javascript" src="{{ asset('accounts/js/chartjs/Chart.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('accounts/js/moment/moment.js') }}"></script>

<script type="text/javascript" src="{{ asset('accounts/js/daterangepicker/daterangepicker.js') }}"></script>

<script>
	$(document).ready(function(){
		$('#paydate').datepicker({
			format :  '{{ $date_format }}',
		});

		$('#check_type').on('change',function(){
			var check = $(this).val();
			if(check == 'manual'){
				$('#check_div').show();
			}else{
				$('#check_div').hide();
			}
		});


		$('#employee').on('change',function(){
			var employee_id = $(this).val();
			$.ajax({
				url : '{{ url('/payrole/getpayrate/') }}'+'/'+employee_id,

				success :function(data){
					var result = $.parseJSON(data);
					$('#vendor_payrate').val(result.employee_vendor.vendor_pay_rate).addClass('has-value');
					$('#consultant_payrate').val(result.employee_payrates.hourly_payrate).addClass('has-value');
					$('#salarytype').val('hourly_based');
					$('#salarytype').selectpicker('refresh');
					$('#consultant_hours').val(result.employee_hours.total_reg_hours + result.employee_hours.total_ot_hours).addClass('has-value');
					var grosspay  = result.employee_payrates.hourly_payrate * (result.employee_hours.total_reg_hours + result.employee_hours.total_ot_hours);	
					$('#grosspay').val(grosspay).addClass('has-value');
					$('#netpay').val(grosspay).addClass('has-value');
				},
				error: function(data){

				}
			});
		});

		$('#emp_tax').on('keyup',function(){
			var emp_tax = parseInt($(this).val())|| 0;
			var grosspay = parseInt($('#grosspay').val())|| 0;
			var emper_tax = parseInt($('#emper_tax').val())|| 0;
			console.log(emper_tax,grosspay,emp_tax);
			net_pay(emp_tax,grosspay,emper_tax);
		});
		$('#emper_tax').on('keyup',function(){

			var emper_tax = parseInt($(this).val()) || 0;
			var grosspay =  parseInt($('#grosspay').val()) || 0;
			var emp_tax = parseInt($('#emp_tax').val()) || 0;
				console.log(emper_tax,grosspay,emp_tax);
			net_pay(emper_tax,grosspay,emp_tax);
		});
	});

	$(function() {

        var start = moment().subtract(1,'month').startOf('month');
        var end =  moment().subtract(1,'month').endOf('month');

        function cb(start, end) {
            $('#payperiod span').html(start.format('{{ $date_format }}') + ' - ' + end.format('{{ $date_format }}'));
            $('#payperiod').addClass('has-value');
        }

        $('#payperiod').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
            	'This Month' : [moment().startOf('month'), moment().endOf('month')],
            	'Previous Month' :[moment().subtract(1,'month').startOf('month'), moment().subtract(1,'month').endOf('month')],
                '{{ trans("reports.this_year") }}': [moment().startOf('year'), moment().endOf('year')],
                '{{ trans("reports.previous_year") }}': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                '{{ trans("reports.this_quarter") }}': [moment().subtract(2, 'months').startOf('month'), moment().endOf('month')],
                '{{ trans("reports.previous_quarter") }}': [moment().subtract(5, 'months').startOf('month'), moment().subtract(3, 'months').endOf('month')],
                '{{ trans("reports.last_12_months") }}': [moment().subtract(11, 'months').startOf('month'), moment().endOf('month')]
            }
        }, cb);

        cb(start, end);
    });

    function net_pay(tax,grosspay,em_tax){
    	var total_tax = tax + em_tax;
    	$('#netpay').val(parseInt(grosspay) - total_tax).addClass('has-value');
    }

</script>

@endsection