@extends('layouts.default')

@section('title', trans('general.title.new', ['type' => trans_choice('general.runpayrole', 1)]))
<style type="text/css">
	input[type=number]::-webkit-inner-spin-button, 
  input[type=number]::-webkit-outer-spin-button { 
  -webkit-appearance: none; 
  }
</style>
@section('content')
    <!-- Default box -->
    <div class="card">
        {!! Form::open(['url' => '/getMisReport', 'role' => 'form', 'id' => 'getMisReportForm']) !!}

	       <div class="row" >
	       		
	        	{{ Form::selectGroup('', trans_choice('general.year', 1), 'bars', [date("Y") => date("Y"), date("Y",strtotime("-1 year")) => date("Y",strtotime("-1 year")), date("Y",strtotime("-2 year")) => date("Y",strtotime("-2 year"))]) }}


	            {{ Form::selectGroup('', trans_choice('general.month', 1), 'folder-open-o', $months) }}
	    

	            {{ Form::selectGroup('', trans_choice('general.employee', 1), 'folder-open-o', $employee_list) }}
	          

	        </div>
	        <!-- /.box-body -->

	        <div class="text-right">
	        	{{ Form::button('Run Report', array('class' => 'btn btn-primary' , 'style' => 'align-right','id'=>'btn_run_report', 'type'=>"submit")) }}
	        </div>
	        <!-- /.box-footer -->
        {!! Form::close() !!}
    </div>
    <div class="card" id="emplyee_pay_rate_client_details" style="display: none">
  		
          	<div class="row">
                <div class="col-md-4 col-sm-4 col-xs-12">
                  <label class="control-label col-md-5 col-sm-5 col-xs-12">Vendor Name:</label>
                  <div class="col-md-7 col-sm-7 col-xs-12" id="vendor_name"></div>
                </div>
                 <div class="col-md-4 col-sm-4 col-xs-12">
                  <label class="control-label col-md-5 col-sm-5 col-xs-12">Vendor Email:</label>
                  <div class="col-md-7 col-sm-7 col-xs-12" id="vendor_email"></div>
                </div>
                <div class="col-md-4 col-sm-4 col-xs-12">
                  <label class="control-label col-md-5 col-sm-5 col-xs-12">Vendor Mobile:</label>
                  <div class="col-md-7 col-sm-7 col-xs-12" id="vendor_mobile"></div>
                </div>
                <div class="col-md-4 col-sm-4 col-xs-12">
                  <label class="control-label col-md-5 col-sm-5 col-xs-12">Client Name: </label>
                  <div class="col-md-7 col-sm-7 col-xs-12" id="client_name"></div>
                </div>
                <div class="col-md-4 col-sm-4 col-xs-12">
                  <label class="control-label col-md-5 col-sm-5 col-xs-12">Hourly Payrate: </label>
                  <div class="col-md-7 col-sm-7 col-xs-12" id="hourly_payrate"></div>
                </div>
                <div class="col-md-4 col-sm-4 col-xs-12">
                  <label class="control-label col-md-5 col-sm-5 col-xs-12">OT Payrate: </label>
                  <div class="col-md-7 col-sm-7 col-xs-12" id="ot_payrate"></div>
                </div>
          	</div>
  		
	</div>
	<div class="card" id="employee_content" style="display: none">
        {!! Form::open(['url' => 'misindex.store', 'role' => 'form']) !!}

	       
	            {{ Form::textGroupSmall('week1', 'Week 1 ', 'id-card-o') }}
	            {{ Form::textGroupSmall('week2', 'Week 2 ', 'id-card-o') }}
	            {{ Form::textGroupSmall('week3', 'Week 3 ', 'id-card-o') }}
	            {{ Form::textGroupSmall('week4', 'Week 4 ', 'id-card-o') }}
	            {{ Form::textGroupSmall('week5', 'Week 5 ', 'id-card-o') }}
	            {{ Form::textGroupSmall('week6', 'Week 6 ', 'id-card-o') }}
	            {{ Form::textGroupSmall('reg_hours', 'REG ', 'id-card-o') }}
	            {{ Form::textGroupSmall('ot_hours', 'OT ', 'id-card-o') }}
	            {{ Form::textGroupSmall('reg_payrate', 'Pay Rate ', 'id-card-o') }}
	            {{ Form::textGroupSmall('data_ot_payrate', 'OT Pay Rate ', 'id-card-o') }}
	            {{ Form::textGroupSmall('actual_salary', 'Actual Salary ', 'id-card-o') }}

	       

        {!! Form::close() !!}
    </div>

@endsection

@push('scripts')
  <script type="text/javascript">
$(document).ready(function() {
	
   $("#emp_name").select2({
        placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.types', 1)]) }}"
    }); 
   $("#month_name").select2({
        placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.types', 1)]) }}"
    }); 
   $("#year_name").select2({
        placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.types', 1)]) }}"
    });

	$('#btn_run_report').on('click',function(){
		var form = $('#getMisReportForm');
		form.unbind('submit').submit(function (e) {
			$("input").each(function () {
				$(this).empty();
			});
			var month_value=$('#month_name').val();
			var year_value=$('#year_name').val();
			var emp_value=$('#emp_name').val();
        	e.preventDefault();
	        $.ajax({
	            type: form.attr('method'),
	            url:  form.attr('action'),
	            data: form.serialize(), 
	            success: function (data){
	            $('#emplyee_pay_rate_client_details').slideDown("slow").show();
	            $('#employee_content').slideDown("slow").show();
	            	if (data.misreport!=null){
	            		$('#emp_data_name').html(data.misreport.emp_name + ' Report'); 
	            		
	            		if (typeof data.misreport.week1 == "undefined" || data.misreport.week1 == null){
	            			$('#week1').val('0').attr('disabled','disabled');	
	            		}else{$('#week1').val(data.misreport.week1).attr('disabled','disabled');}
	            		if (typeof data.misreport.week2 == "undefined" || data.misreport.week2 == null){
	            			$('#week2').val('0').attr('disabled','disabled');	
	            		}else{$('#week2').val(data.misreport.week2).attr('disabled','disabled');}
	            		if (typeof data.misreport.week3 == "undefined" || data.misreport.week3 == null){
	            			$('#week3').val('0').attr('disabled','disabled');
	            		}else{$('#week3').val(data.misreport.week3).attr('disabled','disabled');}
	            		if (typeof data.misreport.week4 == "undefined" || data.misreport.week4 == null){
	            			$('#week4').val('0').attr('disabled','disabled');	
	            		}else{$('#week4').val(data.misreport.week4).attr('disabled','disabled');}
	            		if (typeof data.misreport.week5 == "undefined" || data.misreport.week5 == null){
	            			$('#week5').val('0').attr('disabled','disabled');	
	            		}else{$('#week5').val(data.misreport.week5).attr('disabled','disabled');}
	            		if (typeof data.misreport.week6 == "undefined" || data.misreport.week6 == null){
	            			$('#week6').val('0').attr('disabled','disabled');	
	            		}else{$('#week6').val(data.misreport.week6).attr('disabled','disabled');}
	            		$('#t_hours').val(+data.misreport.week1 + +data.misreport.week2 + +data.misreport.week3 + +data.misreport.week4 + +data.misreport.week5 + +data.misreport.week6).attr('disabled','disabled');
	            		$('#reg_hours').val(data.misreport.total_reg_hours).attr('disabled','disabled');
	            		$('#ot_hours').val(data.misreport.total_ot_hours).attr('disabled','disabled');
	            		$('#timesheet_week_id').val(data.misreport.id);

	            		$("input").each(function () {
			            	$(this).addClass('mui--is-touched mui--is-dirty mui--is-not-empty');
			            });
	            	}
	            	else{
	            		$('#emp_data_name').html('No Data Found');
						$('#week1').val('0');
						$('#week2').val('0');
						$('#week3').val('0');
						$('#week4').val('0');
						$('#week5').val('0');
						$('#week6').val('0');
						$('#t_hours').val('0');
						$('#reg_hours').val('0');
	            		$('#ot_hours').val('0');
	            		$('#actual_salary').val('0');
	            		$('#data_ot_payrate').val('0');
	            		$('#reg_payrate').val('0');
	            	}
	            	var actual_salary = (data.misreport.total_reg_hours * data.pay_rates.hourly_payrate) + (data.misreport.total_ot_hours * data.pay_rates.ot_payrate);
		            	$('#vendor_name').html(data.pay_rates.vendor_name);
		            	$('#vendor_mobile').html(data.pay_rates.vendor_mobile);
		            	$('#vendor_email').html(data.pay_rates.vendor_email);
		            	$('#client_name').html(data.pay_rates.client_name);
		            	$('#hourly_payrate').html(data.pay_rates.hourly_payrate);
		            	$('#ot_payrate').html(data.pay_rates.ot_payrate);
		            	$('#reg_payrate').val(data.pay_rates.hourly_payrate).attr('disabled','disabled');
		            	$('#data_ot_payrate').val(data.pay_rates.ot_payrate).attr('disabled','disabled');
		            	$('#actual_salary').val(actual_salary).attr('disabled','disabled');
		            	$('#getting_month_value').val(data.month);
						$('#getting_year_value').val(data.year);
						$('#getting_emp_id').val(data.emp_id);
						getSavedMisData(month_value,year_value,emp_value);
	        	},
	            error: function (data) {
	             
	            },
	        });
    	});
	});
	
	$('#mis_report').on('click',function(){
		var employee_mis_report = $('#employee_content_form');
		employee_mis_report.unbind('submit').submit(function (e) {
	        e.preventDefault();
	      	var actual_salary = $('#actual_salary').val();
	      	var reg_hours = $('#reg_hours').val();
	      	var ot_hours = $('#ot_hours').val();
	      	var salary_overpay = $('#salary_overpay').val();

	        $.ajax({
	            type: employee_mis_report.attr('method'),
	            url:  employee_mis_report.attr('action'),
	            data: employee_mis_report.serialize() + '&actual_salary='+actual_salary+ '&reg_hours='+reg_hours+'&ot_hours='+ot_hours+'&salary_overpay='+salary_overpay, 
	            success: function (data) {
	            	
	            },
	            error: function (data) {
	             
	            },
	        });
	    });
	}); 
});

function isNumberKey(evt){
    var charCode = (evt.which) ? evt.which : event.keyCode
    if (charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function getSavedMisData(month,year,emp_id){

	$.ajax({
		url:'<?php echo url('/getSavedMisData');?>',
		data:'&month='+month+'&year='+year+'&emp_id='+emp_id,
		success: function(misReportGetData){
			if(misReportGetData!=null){
				$('#mis_report').hide();
				$('#salary_overpay').val(misReportGetData.salary_overpay);
			}
		},
		error:function(){

		},
	});

}

</script>
@endpush
