@extends('layouts.default')

@section('title', trans('general.title.new', ['type' => trans_choice('general.items', 1)]))

@section('content')
    <!-- Default box -->
   <div class="box box-success">
      {!! Form::open(['url' => 'items/items', 'files' => true, 'role' => 'form']) !!}
      <div class="box-body">
            {{ Form::selectGroup('source_type', trans_choice('general.items', 1), 'money', $productservice, ['required']) }}
            
            {{ Form::textGroup('name', trans('items.name'), 'id-card-o') }}

            {{ Form::textGroup('sku', trans('items.sku'), 'key' ,[], null) }}

            {{-- {{ Form::selectGroup('category_id', trans_choice('general.categories', 1), 'folder-open-o', $categories, null, []) }} --}}
            {{-- 
            <div id="inventory">
            {{ Form::textGroup('initial_quantity', trans('items.initial_quantity'),'key') }}

            {{ Form::textGroup('alert_date', trans('items.date_item'),'calendar',['id' => 'as_date', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => ''],Date::now()->format($date_format)) }} 

            {{ Form::textGroup('alert_msg', trans('items.alert'), 'key') }}
            
            {{ Form::textGroup('quantity', trans_choice('items.quantities', 1), 'cubes', ['required' => 'required'], '1') }} 
            </div> --}}

            {{ Form::textGroup('sale_price', trans('items.sales_price'), 'money') }}

            <div id="income_account_div">
            {{ Form::selectGroup('income_account', trans_choice('general.income_account', 1), 'percent',$income_account, []) }}
            </div>

            {{-- OTHER TYPES --}}
            {{-- <div id="income_non_inventory_div">
            {{ Form::selectGroup('income_account_non_inventory', trans_choice('general.income_account', 1), 'percent', $non_inventory, []) }}
            </div> --}}

            {{ Form::fileGroup('picture', trans('Picture'),[]) }}

            {{ Form::textareaGroup('sales_information', trans('general.sales_information')) }}
            {{-- OTHER TYPES --}}

            {{-- {{ Form::textareaGroup('purchase_information', trans('general.purchase_information')) }}
            
            {{ Form::textGroup('purchase_price', trans('items.purchase_price'), 'money') }}

            <div id="expense_account_div">
            {{ Form::selectGroup('expense_account', trans_choice('general.expense_account', 1), 'percent', $expense_account, []) }}
            </div> --}}

            {{-- OTHER TYPES --}}
           {{--  <div id="purchase_non_inventory_div">
                {{ Form::selectGroup('expense_account_non_inventory', trans_choice('general.expense_account', 1), 'percent', $non_inventory, []) }}
            </div> --}}
            {{-- OTHER TYPES --}}

            {{ Form::radioGroup('enabled', trans('general.enabled')) }}
      </div>
        <!-- /.box-body -->
        <div class="box-footer">
            {{ Form::saveButtons('items/items') }}
        </div>
        <!-- /.box-footer -->

        {!! Form::close() !!}
    </div>
@endsection

@push('js')
    <script src="{{ asset('accounts/js/bootstrap-fancyfile.js') }}"></script>
    <script src="{{ asset('accounts/almasaeed2010/adminlte/plugins/datepicker/bootstrap-datepicker.js') }}"></script>
@endpush

@push('css')
    <link rel="stylesheet" href="{{ asset('accounts/css/bootstrap-fancyfile.css') }}">
      <link rel="stylesheet" href="{{ asset('accounts//almasaeed2010/adminlte/plugins/datepicker/datepicker3.css') }}">
@endpush

@push('scripts')
    <script type="text/javascript">
        var text_yes = '{{ trans('general.yes') }}';
        var text_no = '{{ trans('general.no') }}';

        $(document).ready(function(){
           
           // $('#income_non_inventory_div').hide();    
            //$('#purchase_non_inventory_div').hide();

            /*$('#source_type').on('change',function(){
                let type = $(this).val();
                if(type == 0){
                    $('#income_non_inventory_div').hide();    
                   // $('#purchase_non_inventory_div').hide();
                    $('#income_account_div').show();    
                    $('#expense_account_div').show();
                    $('#inventory').show();
                    $('#initial_quantity').show().prop('required',true);
                    $('#alert_date').show().prop('required',true);
                    $('#alert_msg').show().prop('required',true);
                    $('#quantity').show().prop('required',true);
                    $('#income_non_inventory_div').find('#income_account_non_inventory').removeAttr('required'); 
                   // $('#purchase_non_inventory_div').find('#expense_account_non_inventory').removeAttr('required'); 
                    $('#income_account_div').find('#income_account').attr('required','required');    
                    $('#expense_account_div').find('expense_account').attr('required','required');
                    
                }
                else{
                    $('#income_non_inventory_div').show();    
                    //$('#purchase_non_inventory_div').show();    
                    $('#income_account_div').hide();    
                    $('#expense_account_div').hide();
                    $('#inventory').hide(); 
                    $('#initial_quantity').prop('required',false);
                    $('#alert_date').prop('required',false);
                    $('#alert_msg').prop('required',false);
                    $('#quantity').prop('required',false);
                    $('#income_non_inventory_div').find('#income_account_non_inventory').attr('required'); 
                   // $('#purchase_non_inventory_div').find('#expense_account_non_inventory').attr('required'); 
                    $('#income_account_div').find('#income_account').removeAttr('required');    
                    $('#expense_account_div').find('#expense_account').removeAttr('required');
                }
            });*/
           
            $('#enabled_1').trigger('click');

            $('#name').focus();

            $("#tax_id").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.taxes', 1)]) }}"
            });

            $("#product_services").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) }}"
            });

            $("#category_id").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.categories', 1)]) }}"
            });
            $("#source_type").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) }}"
            });

            $("select[name='income_account']").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.income_account', 1)]) }}"
            });
            $("select[name='expense_account']").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.expense_account', 1)]) }}"
            });
             $("select[name='income_account_non_inventory']").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.income_account', 1)]) }}"
            });
            $("select[name='expense_account_non_inventory']").select2({
                placeholder: "{{ trans('general.form.select.field', ['field' => trans_choice('general.expense_account', 1)]) }}"
            });

           

            $('#picture').fancyfile({
                text  : '{{ trans('general.form.select.file') }}',
                style : 'btn-default',
                placeholder : '{{ trans('general.form.no_file_selected') }}'
            });


        });
    </script>

<script type="text/javascript">
  $(document).ready(function(){
    //Date picker
    $('#as_date').datepicker({
        format: '{{ $date_format }}',
        autoclose: true
    });

  });
</script>

@endpush
