@extends('layouts.default')

@section('title', trans_choice('general.invoices', 1) . ': ' . $invoice->invoice_number)
@section('new_button')
<a href="{{ url('incomes/invoices ')}} " class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.invoices', 1) . ' List' }} </a>

<a href="{{ url('incomes/invoices/' . $invoice->id .'/edit') }}"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">edit</i>Edit</a>
<a href="{{ url('incomes/invoices/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Invoices"><i class="material-icons left">add</i> {{ trans_choice('general.invoices', 2) }}</a>

@endsection
@section('content')
<style>
    .invoice-logo{height:50px;}
    .invoice{padding:15px;}
    .invoice-company{padding-top:10px;}
    .table th{padding:1rem !important;}
    </style>
    <div class="card">
        <section class="invoice">
            <span class="badge {{ $invoice->status->label }} ">{{ $invoice->status->name }}</span>

            <div class="row">
                <div class="col-md-6">
                    <div class="invoice-header">
                    @if (setting('general.invoice_logo'))
                        <img src="{{ Storage::url(setting('general.invoice_logo')) }}" class="invoice-logo" />
                    @elseif (setting('general.company_logo'))
                        <img src="{{ Storage::url(setting('general.company_logo')) }}" class="invoice-logo" />
                    @else
                      {{--   <img src="{{ asset('public/accounts/img/company.png') }}" class="invoice-logo" /> --}}
                    @endif
                </div>
                <div class=" invoice-company">
                    <address>
                        <strong>{{ setting('general.company_name') }}</strong><br>
                        {!! nl2br(setting('general.company_address')) !!}<br>
                        @if (setting('general.company_phone'))
                        {{ setting('general.company_phone') }}<br>
                        @endif
                        {{ setting('general.company_email') }}
                    </address>
                </div>
            </div>
                <div class="col-md-6">
                     <div class="">
                        <table class="table no-border table-striped">
                            <tbody>
                                <tr>
                                    <th>{{ trans('invoices.invoice_number') }}:</th>
                                    <td class="text-right">{{ $invoice->invoice_number }}</td>
                                </tr>
                                @if ($invoice->order_number)
                                <tr>
                                    <th>{{ trans('invoices.order_number') }}:</th>
                                    <td class="text-right">{{ $invoice->order_number }}</td>
                                </tr>
                                @endif
                                <tr>
                                    <th>{{ trans('invoices.invoice_date') }}:</th>
                                    <td class="text-right">{{ Date::parse($invoice->invoiced_at)->format($date_format) }}</td>
                                </tr>
                                <tr>
                                    <th>{{ trans('invoices.payment_due') }}:</th>
                                    <td class="text-right">{{ Date::parse($invoice->due_at)->format($date_format) }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                </div>
            </div>
          
            <div class="row">
                
                <div class="col-md-6">
                   {{ trans('invoices.bill_to') }}
                    <address>
                        <strong>{{ isset($invoice->customer->parent_re->name)?$invoice->customer->parent_re->name:$invoice->customer_name }}</strong><br>
                        {!! isset($invoice->customer->parent_re->address)?nl2br($invoice->customer->parent_re->address):nl2br($invoice->customer_address) !!}<br>   
                        {{ isset($invoice->customer->parent_re->phone)?$invoice->customer->parent_re->phone:$invoice->customer_phone }}<br>  
                        {{ isset($invoice->customer->parent_re->customer_email)?$invoice->customer->parent_re->customer_email:$invoice->customer_email }}
                    </address>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <th>{{ trans('general.description') }}</th>
                                <th class="text-center">{{ trans('invoices.quantity') }}</th>
                                <th class="text-right">{{ trans('invoices.price') }}</th>
                                <th class="text-right">{{ trans('invoices.total') }}</th>
                            </tr>
                            @foreach($invoice->items as $item)
                            <tr>
                                <td>
                                    {{ isset($item->description)?$item->description:$item->name }}
                                </td>
                                <td class="text-center">{{ $item->quantity }}</td>
                                <td class="text-right">@money($item->price, $invoice->currency_code, true)</td>
                                <td class="text-right">@money($item->total, $invoice->currency_code, true)</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                @if ($invoice->notes)
                    <p class="lead">{{ trans_choice('general.notes', 2) }}</p>

                    <p class="text-muted well well-sm no-shadow" style="margin-top: 10px;">
                        {{ $invoice->notes }}
                    </p>
                @endif
                </div>
                <div class="col-md-6">
                    <div class="">
                        <table class="table">
                            <tbody>
                                @foreach($invoice->totals as $total)
                                @if($total->code != 'total')
                                    <tr>
                                        <th>{{ trans($total['name']) }}:</th>
                                        <td class="text-right">@money($total->amount, $invoice->currency_code, true)</td>
                                    </tr>
                                @else
                                    @if ($invoice->paid)
                                        <tr class="text-success">
                                            <th>{{ trans('invoices.paid') }}:</th>
                                            <td class="text-right">- @money($invoice->paid, $invoice->currency_code, true)</td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <th>{{ trans($total['name']) }}:</th>
                                        <td class="text-right">@money($total->amount - $invoice->paid, $invoice->currency_code, true)</td>
                                    </tr>
                                @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="box-footer row no-print">
                <div class="col-md-12">
                    <a href="{{ url('incomes/invoices/' . $invoice->id . '/edit') }}" class="btn btn-primary">
                        <i class="fa fa-pencil-square-o"></i>&nbsp; {{ trans('general.edit') }}
                    </a>
                    <a href="{{ url('incomes/invoices/' . $invoice->id . '/print') }}"  class="btn btn-default">
                        <i class="fa fa-print"></i>&nbsp; {{ trans('general.print') }}
                    </a>
                    <div class="btn-group dropup">
                        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-chevron-circle-up"></i>&nbsp; {{ trans('general.more_actions') }}</button>
                        <ul class="dropdown-menu" role="menu">
                            @if($invoice->status->code != 'paid')
                           
                          
                            @if(empty($invoice->payments()->count()) || (!empty($invoice->payments()->count()) && $invoice->payments()->paid() != $invoice->amount))
                            <li><a href="{{ url('incomes/customers/receivepayment/'.$invoice->customer_id.'/'.$invoice->id) }}" >{{ trans('invoices.add_payment') }}</a></li>
                            @endif
                           
                            @endif
                                                       
                            @if($invoice->customer_email)
                            <li><a href="{{ url('incomes/invoices/' . $invoice->id . '/email') }}">{{ trans('invoices.send_mail') }}</a></li>
                            @else
                            <li><a href="javascript:void(0);" class="green-tooltip disabled" data-toggle="tooltip" data-placement="right" title="{{ trans('invoices.messages.email_required') }}"><span class="text-disabled">{{ trans('invoices.send_mail') }}</span></a></li>
                            @endif
                            
                            <li><a href="{{ url('incomes/invoices/' . $invoice->id . '/pdf') }}">{{ trans('invoices.download_pdf') }}</a></li>
                            
                        </ul>
                    </div>

                    @if($invoice->attachment)
                        <span class="attachment">
                            <a href="{{ url('uploads/' . $invoice->attachment->id . '/download') }}">
                                <span id="download-attachment" class="text-primary">
                                    <i class="fa fa-file-{{ $invoice->attachment->aggregate_type }}-o"></i> {{ $invoice->attachment->basename }}
                                </span>
                            </a>
                            {!! Form::open([
                                'id' => 'attachment-' . $invoice->attachment->id,
                                'method' => 'DELETE',
                                'url' => [url('uploads/' . $invoice->attachment->id)],
                                'style' => 'display:inline'
                            ]) !!}
                            <a id="remove-attachment" href="javascript:void();">
                                <span class="text-danger"><i class="fa fa fa-times"></i></span>
                            </a>
                            {!! Form::close() !!}
                        </span>
                    @endif
                </div>
            </div>
        </section>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="box box-default collapsed-box">
                <div class="box-header with-border">
                    <h3 class="box-title">{{ trans('invoices.histories') }}</h3>

                </div>
                <div class="">
                    <div class="">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>{{ trans('general.created_date') }}</th>
                                <th>{{ trans_choice('general.statuses', 1) }}</th>
                                <th>{{ trans('general.description') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($invoice->histories as $history)
                                <tr>
                                    <td>{{ Date::parse($history->created_at)->format($date_format) }}</td>
                                    <td>{{ $history->status->name }}</td>
                                    <td>{{ $history->description }}</td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="box box-default collapsed-box">
                <div class="box-header with-border">
                    <h3 class="box-title">{{ trans('invoices.payments') }}</h3>

                    <!-- <div class="box-tools pull-right">
                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
                    </div> -->
                    <!-- /.box-tools -->
                </div>
                <div class="">
                    <div class="">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>{{ trans('general.payment_date') }}</th>
                                <th>{{ trans('general.amount') }}</th>
                                <th>{{ trans_choice('general.accounts', 1) }}</th>
                                <th>{{ trans('general.actions') }}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($invoice->payments as $payment)
                                <tr>
                                    <td>{{ Date::parse($payment->paid_at)->format($date_format) }}</td>
                                    <td>@money($payment->amount, $payment->currency_code, true)</td>
                                    <td>{{ isset($payment->account->name_number)?$payment->account->name_number:'Credit Memo' }}</td>
                                    <td>
                                        {{-- <a class="btn btn-outline-info btn-circle-iconic btn34" href="{{ url('/incomes/invoices/payment/'.$payment->id.'/edit') }}"><i class="material-icons">create</i></a> --}}
                                        {{ Form::deleteLinkA($payment,'incomes/invoices/payment','Payments') }}
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@push('scripts')
    <script type="text/javascript">
        $(document).ready(function(){
            
            $(document).on('click', '#button-email', function (e) {
                $('#email-modal').remove();

                var html = '<div class="modal fade" id="email-modal" tabindex="-1" role="dialog" aria-labelledby="emailModalLabel">';
                html += '   <div class="modal-dialog" role="document">';
                html += '       <div class="modal-content">';
                html += '           <div class="modal-header">';
                html += '               <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                html += '               <h4 class="modal-title" id="emailModalLabel">Overflowing text</h4>';
                html += '           </div>';
                html += '           <div class="modal-body">';
                html += '              {{ trans('general.na') }}';
                html += '           </div>';
                html += '           <div class="modal-footer">';
                html += '               <button type="button" class="btn btn-default" data-dismiss="modal">{{ trans('general.cancel') }}</button>';
                html += '               <button type="button" class="btn btn-success">Save changes</button>';
                html += '           </div>';
                html += '       </div>';
                html += '   </div>';
                html += '</div>';

                $('body').append(html);

                $('#email-modal').modal('show');
            });
            @if($invoice->attachment)
            $(document).on('click', '#remove-attachment', function (e) {
                confirmDelete("#attachment-{!! $invoice->attachment->id !!}", "{!! trans('general.attachment') !!}", "{!! trans('general.delete_confirm', ['name' => '<strong>' . $invoice->attachment->basename . '</strong>', 'type' => strtolower(trans('general.attachment'))]) !!}", "{!! trans('general.cancel') !!}", "{!! trans('general.delete')  !!}");
            });
            @endif
        });

        function addPayment() {
            $('.help-block').remove();

            $.ajax({
                url: '{{ url("incomes/invoices/payment") }}',
                type: 'POST',
                dataType: 'JSON',
                data: $('#payment-modal input[type=\'text\'], #payment-modal input[type=\'hidden\'], #payment-modal textarea, #payment-modal select'),
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                beforeSend: function() {
                    $('#payment-modal .modal-content').append('<div id="loading" class="text-center"><i class="fa fa-spinner fa-spin fa-5x checkout-spin"></i></div>');
                },
                complete: function() {
                    $('#loading').remove();
                },
                success: function(json) {
                    if (json['error']) {
                        $('#payment-modal .modal-message').append('<div class="alert alert-danger">' + json['message'] + '</div>');
                        $('div.alert-danger').delay(1000).fadeOut(350);
                    }

                    if (json['success']) {
                        $('#payment-modal .modal-message').before('<div class="alert alert-success">' + json['message'] + '</div>');
                        $('div.alert-success').delay(3000).fadeOut(350);

                        setTimeout(function(){
                            $("#payment-modal").modal('hide');

                            location.reload();
                        }, 3000);
                    }
                },
                error: function(data){
                    var errors = data.responseJSON;

                    if (typeof errors !== 'undefined') {
                        if (errors.paid_at) {
                            $('#payment-modal #paid_at').parent().after('<p class="help-block">' + errors.paid_at + '</p>');
                        }

                        if (errors.amount) {
                            $('#payment-modal #amount').parent().after('<p class="help-block">' + errors.amount + '</p>');
                        }

                        if (errors.account_id) {
                            $('#payment-modal #account_id').parent().after('<p class="help-block">' + errors.account_id + '</p>');
                        }

                        if (errors.currency_code) {
                            $('#payment-modal #currency_code').parent().after('<p class="help-block">' + errors.currency_code + '</p>');
                        }

                        if (errors.category_id) {
                            $('#payment-modal #category_id').parent().after('<p class="help-block">' + errors.category_id + '</p>');
                        }

                        if (errors.payment_method) {
                            $('#payment-modal #payment_method').parent().after('<p class="help-block">' + errors.payment_method + '</p>');
                        }
                    }
                }
            });
        }
    </script>
@endpush
