@extends('layouts.default')

@section('title', trans('invoices.payments')) 
@section('new_button')  
@endsection

@section('content')


<!-- Default box -->
<div class="card">
    {!! Form::open(['url' => 'incomes/invoices/customerpayment', 'files' => true, 'id' =>  'customerpayment','role' => 'form']) !!}

    <div class="row">
        {{ Form::textGroup('name', trans('general.coustomer_name'), 'id-card-o',['disabled' => 'disabled'] ,$customer->name) }}

    	{{ Form::textGroup('paid_at',trans('general.date'), 'calendar',['id' => 'paid_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'mm-dd-yyyy\'', 'data-mask' => ''], Date::now()->format($date_format)) }}

    	{{ Form::selectGroup('payment_method', trans_choice('general.payment_methods', 1), 'credit-card', $payment_methods,isset($customer->payment_method)?$customer->payment_method:config('accounts.payment_method') ) }}


    	{{ Form::selectGroup('account_id', trans_choice('general.depositto', 1), 'university', $accounts, setting('general.default_account'),['data-live-search'=>'true']) }}

        <div class="col-lg-3 col-md-4 col-sm-6" id="payment_sub"></div>

        {{ Form::hidden('account_chart_id',null,['id'=>'account_chart_id']) }}

        {{ Form::hidden('customer_id',isset($customer->id)) }}
       

        {!! Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']) !!}
        
</div>
</div>
    <div class="row m-0">
        <div class="form-group col-md-12">
            <h3 class="item-title">Outstanding Transactions</h3>
            <div class="">
                <table class="table table-bordered table-hover tabl-payment table-striped" id="items">
                    <thead>
                        <tr >
                            
                            <th>{{ trans('general.description') }}</th>
                            <th>{{ trans('invoices.due_date') }}</th>
                            <th>{{ trans('general.totalamount') }}</th>
                            <th>{{ trans('general.recivedamount') }}</th>
                            <th>{{ trans_choice('general.balance', 2) }}</th>
                            <th>{{ 'Discount Account' }}</th>
                            <th>{{ 'Discount' }}</th>
                            <th>{{ trans_choice('general.payments',1) }}</th>
                        </tr>
                    </thead> 
                    <tbody>
                        <?php foreach($payments_lists as $k=> $payments_list){
                           
                                if(!( $payments_list->payments_total->isEmpty() )){
             
                                   $paid_amount = $payments_list->payments_total[0]['paid_amount'];
                                }
                                else{
                                    $paid_amount = 0;
                                }
                        ?>
                        <tr  style="{{ (Carbon::now() > $payments_list->due_at) ? 'color: #f90000' : ''  }}"   >
                           
                        	<td>{{ $payments_list->invoice_number . $payments_list->notes }}</td>
                        	<td>{{ Date::parse($payments_list->due_at)->format($date_format) }}</td>
                            <td> @money($payments_list->amount, $payments_list->currency_code, true) </td>
                        	<td> @money($paid_amount, $payments_list->currency_code, true)</td>
                            <td >@money(($payments_list->amount - $paid_amount),$payments_list->currency_code, true)
                                <input type="hidden" name="balance_hidden[]" id="balance_hidden_{{ $k }}" value="{{ ($payments_list->amount - $paid_amount) }}" >
                            </td>
                            <td>
                                <select name="discount_account[]"  onchange="addChartofAccount(event)" id="disc_acct_select{{ $k }}" class="selectpicker" data-live-search="true">
                                    {!! Cache::get('account_details_option') !!}
                                </select>
                            </td>
                            <td>
                                @php
                                $amt = $payments_list->amount - $paid_amount
                                @endphp
                                {{ Form::textGroup1('discount[]', 'Discount', null, ['id'=>'discount_'.$k, 'min'=>0, 'class'=>'form-control disc', 'max'=>$amt, 'onkeyup,onblur'=>'applyDiscount('.$k.')'], 0) }}
                            </td>
                        	<td>
                                <div class="form-group">                                
                                    <input type="number" name="amount[]"  min="0" max="{{ ($payments_list->amount - $paid_amount) }}" value="" id="amount_{{ $k }}"  class="form-control amount"  step="any"> 
                                    <label class="form-label">Amount</label>
                                    <span class="form-controlBrd"></span>
                                    <input type="hidden" id="invoice_amount_{{ $k }}" value="{{ $payments_list->amount - $paid_amount }}">
                                </div>
                            </td>

                            {!! Form::hidden('invoice_id[]', $payments_list->id, ['id' => 'invoice_id', 'class' => 'form-control', 'required' => 'required']) !!}
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div> 
        </div> 
    </div>

    <div class="row m-0">
        <div class="col-lg-6 col-md-6 col-sm-6">
            {{ Form::textareaGroup('notes', trans_choice('general.notes', 2)) }}
        </div>
         <div class="col-lg-6 col-md-6 col-sm-6 pull-right mrg-top-5">
             <div id="payment_id"></div>
        {{ Form::saveButtons('incomes/invoices') }}
         </div>
    </div>


    </div>
   

    {!! Form::close() !!}

@endsection