    <!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice - #{{ trans('invoices.invoice_number') }}</title>

    <style type="text/css">
        @page {
            margin: 0px;
        }
        body {
            margin: 0px;
        }
        * {
            font-family: Verdana, Arial, sans-serif;
        }
        a {
            color: #000;
            text-decoration: none;
        }
        table {
            font-size: x-small;
        }
        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }
        .invoice table {
            margin: 15px;
        }
        .invoice h3 {
            margin-left: 15px;
        }
        .information {
           /* background-color: #60A7A6;*/
            color: #000;
        }
        .information .logo {
            height: 60px;
        }
        .information table {
            padding: 10px;
        }
    </style>
</head>
<body>

    <div class="information">
        <table width="100%">
            <tr>
                           
                          
                        
                    

                <td align="left" style="width: 40%;">
                    <h3>{{ isset($invoice->customer->parent_re->name)?$invoice->customer->parent_re->name:$invoice->customer_name }}</h3>
                    <address>
                        {!! isset($invoice->customer->parent_re->address)?nl2br($invoice->customer->parent_re->address):nl2br($invoice->customer_address) !!}<br>
                       
                        {{ isset($invoice->customer->parent_re->phone)?$invoice->customer->parent_re->phone:$invoice->customer_phone }}<br>
                       
                        {{ isset($invoice->customer->parent_re->customer_email)?$invoice->customer->parent_re->customer_email:$invoice->customer_email }}
                        <br/>
                        {{ trans('invoices.invoice_number') }} : {{ $invoice->invoice_number }}<br/> 
                        {{ trans('invoices.invoice_date') }} : {{ Date::parse($invoice->invoiced_at)->format($date_format) }}<br/>
                        {{ trans('invoices.payment_due') }} : {{ Date::parse($invoice->due_at)->format($date_format) }} <br/>
                        Status: Paid
                    </address>         
                           </td>
                <td align="center" style="width: 40%;">
                     @if ($logo)
                        <img src="{{ $logo }}" class="invoice-logo"  style="height: 60px" />
                    @endif
                </td>
                <td align="right" style="width: 40%;">
                    <h3>{{ setting('general.company_name') }}</h3>
                    <address>
                        {!! nl2br(setting('general.company_address')) !!}
                        @if (setting('general.company_phone'))
                        {{ setting('general.company_phone') }}<br>
                        @endif
                        {{ setting('general.company_email') }}
                    </address>
                </td>
            </tr>
        </table>
    </div>


    <br/>

    <div class="invoice">
        <h3>Invoice specification #{{ $invoice->invoice_number }}</h3>
        <table width="100%">
            <thead>
                <tr>
                    <th>{{ trans('general.description') }}</th>
                    <th class="text-center">{{ trans('invoices.quantity') }}</th>
                    <th class="text-right">{{ trans('invoices.price') }}</th>
                    <th class="text-right">{{ trans('invoices.total') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $item)
                <tr>
                    <td>
                        {{ isset($item->description)?$item->description:$item->name }}
                    </td>
                    <td class="text-center">{{ $item->quantity }}</td>
                    <td class="text-right">@money($item->price, $invoice->currency_code, true)</td>
                    <td class="text-right">@money($item->total, $invoice->currency_code, true)</td>
                </tr>
                @endforeach
            </tbody>

            <tfoot>
                 @foreach($invoice->totals as $total)
                    @if($total->code != 'total')
                    <tr >
                        <th colspan="3">{{ trans($total['name']) }}:</th>
                        <td>@money($total->amount, $invoice->currency_code, true)</td>
                    </tr>
                    @else
                    @if ($invoice->paid)
                    <tr class="text-success" >
                        <th colspan="3">{{ trans('invoices.paid') }}:</th>
                        <td>- @money($invoice->paid, $invoice->currency_code, true)</td>
                    </tr>
                    @endif
                    <tr > 
                        <th colspan="3">{{ trans($total['name']) }}:</th>
                        <td class="text-right">@money($total->amount - $invoice->paid, $invoice->currency_code, true)</td>
                    </tr>
                    @endif
                @endforeach
            </tfoot>
        </table>
    </div>

    <div class="information" style="position: absolute; bottom: 0;">
        <table width="100%">
            <tr>
                <td align="left" style="width: 50%;">
                    &copy; {{ date('Y') }} {{ config('app.url') }} - All rights reserved.
                </td>
                <td align="right" style="width: 50%;">
                  Thanks For 
                </td>
            </tr>

        </table>
    </div>
</body>
</html>
