@extends('layouts.default')

@section('title', trans('general.title.edit', ['type' => trans_choice('general.invoices', 1)]))
@section('new_button')
<a href="{{ url('incomes/invoices ')}} " class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.invoices', 1) . ' List' }} </a>

<a href="{{ url('incomes/invoices/' . $invoice->id) }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">remove_red_eye</i>View Invoice</a>

<a href="{{ url('incomes/invoices/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Invoices"><i class="material-icons left">add</i> {{ trans_choice('general.invoices', 2) }}</a>
@endsection
@section('content')
<style>
    .custom-control.overflow-checkbox .overflow-control-indicator {
    position: absolute;
    top: 2px !important;
    left: 0;
  }
    .attachment{position:relative;}
    #download-attachment{position:absolute;top:-40px;left:315px;}
    .custom-controls-stacked {position:relative;top:25px;}
    </style>
    <!-- Default box -->
        {!! Form::model($invoice, ['method' => 'PATCH', 'files' => true, 'url' => ['incomes/invoices', $invoice->id], 'role' => 'form']) !!}
    <div class="row m-0">
        <h3 class="mb-3">Customer Info</h3>
    </div>
    <div class="card">

        <div class="row">
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="form-group required {{ $errors->has('customer_id') ? 'has-error' : ''}}">
                        <small>{{ trans_choice('general.customers', 1) }}</small>
                        <select id="customer_id" name="customer_id" data-live-search="true"  class="selectpicker" placeholder ="{{ trans('general.form.select.field', ['field' => trans_choice('general.customers', 1)])}}" required> 
                              @include('accounts.common.subloop', ['name' => trans('general.form.select.field', ['field' => 'Customers'])  ,'customer_id' => $invoice->customer_id ,'customers' => $customers ])     
                        </select>
                    {!! $errors->first('customer_id', '<p class="help-block">:message</p>') !!}
                </div>
            </div>

           {{--  {{ Form::selectGroup('customer_id', trans_choice('general.customers', 1), 'user', $customers, config('general.customers')) }} --}}

           {{--  {{ Form::textGroup('customer_email', trans('general.email'), 'envelope', [], $invoice->customer_email ) }} --}}
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="form-group ">
                    <input class="form-control" value="{{ $invoice->customer_email }}" placeholder="Enter Email" name="customer_email" id="customer_email" type="text"> 
                    <label for="customer_email" class="control-label">Email</label>
                    <span class="form-controlBrd"></span>
                    
                    <div class="help-block">
                        <div class="custom-controls-stacked d-block">
                            <label class="custom-control overflow-checkbox" >
                            <input type="checkbox" name="sendlater" id="sendlater" value="1" class="overflow-control-input">
                            <span class="overflow-control-indicator"></span> <span class="overflow-control-description"> Send Later</span><a href="#" onclick="createAnotherEmail();" > Cc <span id="cc_count" style="display: none"></span>/Bcc <span id="bcc_count" style="display: none"></span></a > </label>
                        </div> 

                        {{-- 
                        <a href="#" onclick="createAnotherEmail();" > Cc <span id="cc_count"  style="display: none"></span>/Bcc <span id="bcc_count" style="display: none"></span></a> --}}
                        <input type="hidden" value="{{ $invoice->cc_email }}" name="cc_email" id="cc_email">
                        <input type="hidden" value="{{ $invoice->bcc_email }}" name="bcc_email" id="bcc_email">
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="form-group  required {{ $errors->has('net_term') ? 'has-error' : ''}}">
                    <small> {{ trans_choice('general.net_term', 1) }} </small>
                {!! Form::select('net_term',$terms, $invoice->net_term, array_merge(['id'=>'net_term','class' => 'selectpicker','data-live-search'=>'true','placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1), 'value' => $invoice->net_term])])) !!}
                {!! $errors->first('net_term', '<p class="help-block">:message</p>') !!}
                </div>
            </div>

            <div class="col-md-3">
                {{ Form::textGroup('invoice_number', trans('invoices.invoice_number'), null) }}
            </div>

            {{ Form::hidden('currency_code' ,setting('general.default_currency'),['id' => 'currency_code']) }} 
            
            <div class="col-md-3">
                {{ Form::textGroup('invoiced_at', trans('invoices.invoice_date'), Date::parse($invoice->invoiced_at)->format(env('APP_FIELD_DATE')), ['id' => 'invoiced_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
            </div>    

            <div class="col-md-3">
                {{ Form::textGroup('due_at', trans('invoices.due_date'), Date::parse($invoice->due_at)->format(env('APP_FIELD_DATE')), ['id' => 'due_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
            </div>
        </div>
        <div class="row">
           <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="form-groupTextArea">
                    <textarea class="form-ControlTextArea"  rows="3" name="address" cols="50" id="address">{{ $invoice->customer_address }}</textarea>
                    <label for="address" class="form-label">{{trans('general.billingaddress')}}</label>
                    <span class="form-controlBrd"></span>
                </div>
            </div>

            <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="form-groupTextArea">
                {{ Form::textarea('shipping_address', null ,['class'=>'form-ControlTextArea',  'id'=> 'shipping_address' ,'rows' => 3]) }}
                    <label for="shipping_address" class="form-label">Shipping Address</label>
                    <span class="form-controlBrd"></span>
                </div>
            </div>
        </div>
   </div>

    {{-- Timesheet Display --}}
    <div id="time_card" ></div>

    <div class="row m-0">
        <h3 class="mb-3 mt-3"> Items </h3>
        
        <div class="form-group">
            <table class="table table-bordered tabl-input table-striped" id="items">
                <thead>
                    <tr style="background-color: #f9f9f9;">
                        <th width="5%">{{ trans('general.actions') }}</th>
                        <th width="25%">{{ trans('general.name') }}</th>
                        <th width="20%">{{ trans('general.description') }}</th>
                        <th width="15%">{{ trans('invoices.quantity') }}</th>
                        <th width="20%">{{ trans('invoices.price') }}</th>
                        <th width="15%">{{ trans('invoices.total') }}</th>
                    </tr>
                </thead>
                <tbody>

                   
               @php 
                    function productservice1($elements, $prefix = '' , $item_id) {
                        foreach ($elements as $k=> $element) { 
                            @endphp
                            <option value="{{ $element['id'] }}" 
                            {{ ( $item_id == $element['id'] )?'selected':'' }}>
                                {{ $prefix . $element['name'] }} 
                                @if (isset($element['children']))
                                    @php productservice1($element['children'], $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $item_id);
                                    @endphp
                                @endif
                            </option>
                        @php  } 
                    }
                @endphp
                <?php $item_row = 0; ?>
                @forelse($invoice->items as $item)
                    <tr id="item-row-{{ $item_row }}">
                        <td style="vertical-align: middle;">
                            <button type="button" onclick="$('#item-row-{{ $item_row }}').remove(); totalItem();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>
                        </td>
                        <td>
                        <select onchange="autoItem({{ $item_row }})" id="item-id-{{ $item_row }}" class="selectpicker" data-live-search="true" name="item[{{ $item_row }}][item_id]" tabindex="-1" aria-hidden="true">
                             <option>{{ trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) }}</option>
                            <?php echo  productservice1($items , $prefix = '', $item->item_id ); ?>
                        </select>

                        <input class="form-control"   value="{{$item->name}}"  name="item[{{ $item_row }}][name]" type="hidden" id="item-name-{{ $item_row }}">
                        </td>
                        <td>
                            <div class="form-group">
                                <input class="form-control" required="required" name="item[{{ $item_row }}][description]" value="{{ $item->description }}" type="text" id="item-description-{{ $item_row }}">
                                <label class="form-label">{{  trans('general.description') }} </label>
                                <span class="form-controlBrd"></span>
                            </div>
                            
                        </td>
                        <td>
                            <div class="form-group">
                            <input value="{{ $item->quantity }}" class="form-control" required="required" name="item[{{ $item_row }}][quantity]" type="text" id="item-quantity-{{ $item_row }}">
                            <label class="form-label">Quantity</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                            <input value="{{ $item->price }}" class="form-control" required="required" name="item[{{ $item_row }}][price]" type="text" id="item-price-{{ $item_row }}">
                            <label class="form-label">Price</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td style="vertical-align: middle;">
                            <span id="item-total-{{ $item_row }}">@money($item->total, $invoice->currency_code, true)</span>
                        </td>
                    </tr>
                    <?php $item_row++; ?>
                
                @empty 
                    <tr id="item-row-{{ $item_row }}">
                        <td style="vertical-align: middle;">
                            <button type="button" onclick="$(this).tooltip('destroy'); $('#item-row-{{ $item_row }}').remove(); totalItem();" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>
                        </td>
                        <td>
                        <select onchange="autoItem({{ $item_row }})" id="item-id-{{ $item_row }}" required="required" class="selectpicker" data-live-search="true" name="item[{{ $item_row }}][item_id]" tabindex="-1" aria-hidden="true">
                            @include('accounts.common.subitem',['name' => trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]),'items'=> $items ])
                        </select>

                        <input class="form-control" name="item[{{ $item_row }}][name]" type="hidden" id="item-name-{{ $item_row }}">
                        </td>
                        <td>
                            <div class="form-group">
                                <input class="form-control" required="required" name="item[{{ $item_row }}][description]" type="text" id="item-description-{{ $item_row }}">
                                <label class="form-label">{{  trans('general.description') }} </label>
                                <span class="form-controlBrd"></span>
                            </div>
                            
                        </td>
                        <td>
                            <div class="form-group">
                            <input class="form-control" required="required" name="item[{{ $item_row }}][quantity]" type="text" id="item-quantity-{{ $item_row }}">
                            <label class="form-label">Quantity</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td>
                            <div class="form-group">
                            <input class="form-control" required="required" name="item[{{ $item_row }}][price]" type="text" id="item-price-{{ $item_row }}">
                            <label class="form-label">Price</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </td>
                        <td style="vertical-align: middle;">
                            <span id="item-total-{{ $item_row }}">0</span>
                        </td>
                    </tr>
                @endforelse
                    <?php $item_row++; ?>
                    <tr id="addItem">
                        <td><button type="button" onclick="addItem();" data-toggle="tooltip" title="{{ trans('general.add') }}" class="btn btn-xs  btn-outline-info btn-circle-iconic btn34" data-original-title="{{ trans('general.add') }}"><i class="material-icons">add </i></button></td>
                        <td colspan="5"></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan="5"><strong>{{ trans('invoices.sub_total') }}</strong></td>
                        <td><span id="sub-total">0</span></td>
                    </tr>
                    <tr>
                        <td class="text-right" colspan="5"><strong>{{ trans('invoices.total') }}</strong></td>
                        <td><span id="grand-total">0</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
   
       
    {{ Form::fileGroup('attachment', trans('general.attachment')) }}
            @if($invoice->attachment)
                <span class="attachment">
                    <a href="{{ url('uploads/' . $invoice->attachment->id . '/download') }}">
                        <span id="download-attachment" class="text-primary">
                            <i class="fa fa-file-{{ $invoice->attachment->aggregate_type }}-o"></i> {{ $invoice->attachment->basename }}
                        </span>
                    </a>
                </span>
            @endif
    <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6 mt-2">
            {{ Form::textareaGroup('notes', trans_choice('general.notes', 2)) }}
        </div>

        <div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
            {{ Form::saveButton('Update incomes/invoices') }}
        </div>
    </div>
       
     <!-- /.box-footer -->
     
        {!! Form::close() !!}

    <div id='productandservice_dropdown' style="display: none">
       <?php echo productservice1($items , $prefix = '', 0 );?>
    </div>
@include('includes.datepicker')
<script type="text/javascript">
    var item_row = '{{ $item_row }}';

    function addItem() {
        html  = '<tr id="item-row-' + item_row + '">';
        html += '  <td style="vertical-align: middle;">';
        html += '      <button type="button" onclick="$(\'#item-row-' + item_row + '\').remove(); totalItem();" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete</i></button>';
        html += '  </td>';
        
        html += '  <td>';
        html += '<select class="selectpicker" data-live-search="true" required="required" onchange="autoItem('+ item_row +')" name="item[' + item_row + '][item_id]"  id="item-id-' + item_row + '">';
        html += '<option selected="selected" value="">{{ trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) }}</option>';

        html += $('#productandservice_dropdown').html();
        
        html += '</select>';
        html += '<input class="form-control"  name="item['+ item_row +'][name]"        type="hidden" id="item-name-'+ item_row + '">';
        html += '<input class="form-control"   name="item['+ item_row +'][chartid]" type="hidden" id="item-chartid-'+item_row +'">';
        html += '  </td>';
        html +=' <td>';
        html += '<div class="form-group">';
        html += '<input class="form-control" required="required" name="item[{{ $item_row }}][description]" type="text" id="item-description-{{ $item_row }}">';
        html +=  '<label class="form-label">{{  trans('general.description') }} </label>';
        html += '<span class="form-controlBrd"></span>'
        html += '</div></td>';
        html += '  <td>';
        html += '<div class="form-group"><input class="form-control" required="required" name="item[' + item_row + '][quantity]" type="text" id="item-quantity-' + item_row + '"><label class="form-label">Quantity</label> <span class="form-controlBrd"></span></div>';
        html += '  </td>';
        html += '  <td>';
        html += '<div class="form-group"><input class="form-control" required="required" name="item[' + item_row + '][price]" type="text" id="item-price-' + item_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
        html += '  </td>';
        html += '  <td style="vertical-align: middle;">';
        html += '      <span id="item-total-' + item_row + '">0</span>';
        html += '  </td>';

        $('#items tbody #addItem').before(html);
        
        $('#item-id-'+ item_row).selectpicker('refresh');
        item_row++;
    }
    var autocomplete_path = "{{ url('items/items/autocompletebill') }}";
        function autoItem (id){
            var item_id = $("#item-id-"+id).val();
            var currency_code = $('#currency_code').val();
            
            $.ajax({
                url: autocomplete_path,
                type: 'GET',
                dataType: 'JSON',
                data: 'query=' + item_id + '&type=invoice&currency_code=' + currency_code,
                success: function(data) {

                    $('#item-name-'+id).val(data.name);
                    $('#item-quantity-' + id).val('1');
                    $('#item-price-' + id).val(data.sale_price);
                    $('#item-chartid-' +id).val(data.income_account);
                    $('#item-total-' + id).html(data.total);
                    totalItem();
                }
            });
        }

    $(document).ready(function(){
        totalItem();

        $('#net_term').on('change',function(){
            var term_id = $(this).val();
            var invoiced_at = $('#invoiced_at').val().replace(/-/g,'/');
            $.ajax({
                type: 'GET',
                dataType: 'JSON',
                url : '{{ url('netterms/get_netterms/') }}' +'/'+term_id,
                success:function(data){
                    var dt = new Date(invoiced_at);
                    if(data.term_days == 0){
                        var netterm = data.term_days;
                    }else{
                        var netterm = (data.term_days - 1);
                    }
                    var dt = new Date(invoiced_at);
                    dt.setDate(dt.getDate() + +netterm); //console.log(dt);
                    var date = gj.core.formatDate(dt,'{{ $date_format }}');
                    $("#due_at").val(date);
                },
                error:function(error){
                    console.log(error);
                }
            });
        });

        var cc_email = $('#cc_email').val();
        var bcc_email = $('#bcc_email').val();

        var cc =  $('#cc_email').val().split(',');
        var bcc = $('#bcc_email').val().split(',');

        if (cc_email){
            $('#cc_count').html('(' + cc.length + ')').show();
        } 

        if (bcc_email){
            $('#bcc_count').html('(' + bcc.length + ')').show();
        }

        //Date picker
        $('#invoiced_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
        $('#invoiced_at').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: true
        });

        $('#due_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
        $('#due_at').datepicker({
            format: 'yyyy-mm-dd',
            todayHighlight: true,
            minDate: $('#invoiced_at').val(),
        });

        $('#invoiced_at').on('change',function(){
            var invoiced_at = $(this).val();
            var term_id = $('#net_term').val();
            if(term_id){
                $.ajax({
                    type: 'GET',
                    dataType: 'JSON',
                    url : '{{ url('netterms/get_netterms/') }}' +'/'+term_id,
                    success:function(data){
                        
                        if(data.term_days == 0){
                            var netterm = data.term_days;
                        }else{
                            var netterm = (data.term_days - 1);
                        }
                        var dt = new Date(invoiced_at);
                        dt.setDate(dt.getDate() + +netterm); //console.log(dt);
                        var date = gj.core.formatDate(dt,'yyyy-mm-dd');
                        $("#due_at").datepicker("destroy");
                        $("#due_at").addClass('form-control has-value');
                        $('#due_at').datepicker({
                            format: 'yyyy-mm-dd',
                            minDate: invoiced_at,
                            autoclose: true
                        });
                        $("#due_at").val(date);
                    },
                    error:function(error){
                        console.log(error);
                    }
                });
            }
        });

        @if($invoice->attachment)
            attachment_html  = '<span class="attachment">';
            attachment_html += '    <a href="{{ url('uploads/' . $invoice->attachment->id . '/download') }}">';
            attachment_html += '        <span id="download-attachment" class="text-primary">';
            attachment_html += '            <i class="fa fa-file-{{ $invoice->attachment->aggregate_type }}-o"></i> {{ $invoice->attachment->basename }}';
            attachment_html += '        </span>';
            attachment_html += '    </a>';
            attachment_html += '    {!! Form::open(['id' => 'attachment-' . $invoice->attachment->id, 'method' => 'DELETE', 'url' => [url('uploads/' . $invoice->attachment->id)], 'style' => 'display:inline']) !!}';
            attachment_html += '    <a id="remove-attachment" href="javascript:void();">';
            attachment_html += '        <span class="text-danger"><i class="fa fa fa-times"></i></span>';
            attachment_html += '    </a>';
            attachment_html += '    {!! Form::close() !!}';
            attachment_html += '</span>';

            $('.fancy-file .fake-file').append(attachment_html);

            $(document).on('click', '#remove-attachment', function (e) {
                confirmDelete("#attachment-{!! $invoice->attachment->id !!}", "{!! trans('general.attachment') !!}", "{!! trans('general.delete_confirm', ['name' => '<strong>' . $invoice->attachment->basename . '</strong>', 'type' => strtolower(trans('general.attachment'))]) !!}", "{!! trans('general.cancel') !!}", "{!! trans('general.delete')  !!}");
            });
        @endif

        var autocomplete_path = "{{ url('items/items/autocomplete') }}";

        $(document).on('click', '.form-control.typeahead', function() {
            input_id = $(this).attr('id').split('-');

            item_id = parseInt(input_id[input_id.length-1]);

            $(this).typeahead({
                minLength: 3,
                displayText:function (data) {
                    return data.name;
                },
                source: function (query, process) {
                    $.ajax({
                        url: autocomplete_path,
                        type: 'GET',
                        dataType: 'JSON',
                        data: 'query=' + query + '&type=invoice&currency_code=' + $('#currency_code').val(),
                        success: function(data) {
                            return process(data);
                        }
                    });
                },
                afterSelect: function (data) {
                    $('#item-id-' + item_id).val(data.item_id);
                    $('#item-quantity-' + item_id).val('1');
                    $('#item-price-' + item_id).val(data.sale_price);

                    $('#item-total-' + item_id).html(data.total);

                    totalItem();
                }
            });
        });

        $(document).on('change', '#currency_code, #items tbody select', function(){
            totalItem();
        });

        $(document).on('keyup', '#items tbody .form-control', function(){
            totalItem();
        });

        $(document).on('change', '#customer_id', function (e) {
            autocompletecustomer($(this).val());
            showtimecard($(this).val());
            
        });


        

    });
    function showtimecard(customer_id){
        $('#time_card').html('');
        $.ajax({
            url :'{{ url('payrole/timecard') }}'+'/'+customer_id,
            success:function(data){
                if(data){


                    html = '<h3 class="btn btn-info btn-Rcircle-iconic waves-effect waves-light mt-3 mb-3">Time Cards</h3><div class="View-TimeSheet"><table class="table table-bordered View-TimeSheet" id="sum_table"> <thead> <tr> <th>Summary <small>Month-Year</small> </th>';
                        for(i=1;i<32;i++ ){
                        html +=   '<th class="tablemiddel">'+i+'</th>';
                        } 
                    html +=  '</tr> </thead>';

                    html += '<tbody class="scheduleTable">';
                    $.each(data,function(i,value){
                        html +='<tr> <td class="new_event_class" rowspan="2"> <span class="SchTbtmBrd"> <span class="label label-default view_event">'+moment(value.month_value+'-10-'+value.year_value).format('MMM-YYYY') +'</span></span> </td>';
                            for(j=1 ;j < 32 ; j++ ){
                                var present_day = "day"+j;
                                if(value[present_day] !== null && typeof(value[present_day]) !== 'undefined'){
                                    parse_value = $.parseJSON(value[present_day]);
                                    html += '<td>'+ parse_value.WH +'</td>';
                                }else{ html += '<td>-</td>'; }
                            } 
                        html +='<tr>  </td>';
                            for(j=1 ;j < 32 ; j++ ){
                                var present_day = "day"+j;
                                if(value[present_day] !== null && typeof(value[present_day]) !== 'undefined'){
                                    parse_value = $.parseJSON(value[present_day]);
                                    html += '<td>'+ parse_value.OT +'</td>';
                                }else{ html += '<td>-</td>'; }
                            }
                        

                    });

                    html +=  '</tbody> </table></div>';

                    $('#time_card').append(html);


                }

            },
            error:function(){

            }
        });
    }

        function createAnotherEmail() {
        $('#modal-another-email').remove();

        var cc_email = $('#cc_email').val();
        var bcc_email = $('#bcc_email').val();

        modal  = '<div class="modal fade" id="modal-another-email" style="display: none;">';
        modal += '  <div class="modal-dialog  modal-lg">';
        modal += '      <div class="modal-content">';
        modal += '          <div class="modal-body">';
        modal += '              {!! Form::open(['id' => 'form-another-email', 'role' => 'form']) !!}';
        modal += '              <div class="row">';

        modal += '                  <div class="form-group col-md-6 required">';
        modal += '                      <label for="name" class="control-label">CC</label>';
        modal += '                      <div class="input-group">';
        modal += '                          <div class="input-group-addon"><i class="fa fa-id-card-o"></i></div>';
        modal += '                          <input class="form-control" placeholder="Email (Separate emails with a comma)" required="required" name="cc"  type="email" id="cc" value='+ cc_email +'>';
        modal += '                      </div>';
        modal += '                  </div>';

        modal += '                  <div class="form-group col-md-6 ">';
        modal += '                      <label for="name" class="control-label">BCC</label>';
        modal += '                      <div class="input-group">';
        modal += '                          <div class="input-group-addon"><i class="fa fa-id-card-o"></i></div>';
        modal += '                          <input class="form-control" placeholder="Email (Separate emails with a comma)"  name="bcc" type="text"   id="bcc" value='+ bcc_email +'>';
        modal += '                      </div>';
        modal += '                  </div>';

        modal += '              </div>';
        modal += '              {!! Form::close() !!}';
        modal += '          </div>';
        modal += '          <div class="modal-footer">';
        modal += '              <div class="pull-left">';
        modal += '              {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-another-email', 'class' => 'btn btn-success']) !!}';
        modal += '              <button type="button" class="btn btn-default" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>';
        modal += '              </div>';
        modal += '          </div>';
        modal += '      </div>';
        modal += '  </div>';
        modal += '</div>';

        $('body').append(modal);
        $('#modal-another-email').modal('show');
    }

    $(document).on('click', '#button-another-email', function(e){
        $('#modal-another-email .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');
            var cc = $('#cc').val();
            var bcc = $('#bcc').val();

            var cc_count = $('#cc').val().split(',');
            var bcc_count = $('#bcc').val().split(',');
            

        if (cc ){
            $('#cc_email').val(cc);
            $('#cc_count').html( '(' + cc_count.length + ')').show();
            $(".form-group").removeClass("has-error");
            $(".help-block").remove();   
            $('#modal-another-email').modal('hide');
        } 
        if (bcc){
            $('#bcc_email').val(bcc);
            $('#bcc_count').html( '(' + bcc_count.length + ')').show();
            $(".form-group").removeClass("has-error");
            $(".help-block").remove();
            $('#modal-another-email').modal('hide');
        }
    });

    function format(input) {
        var date = new Date(input);
        return [
            date.getFullYear(),
            ("0" + (date.getMonth()+1)).slice(-2),
            ("0" + date.getDate()).slice(-2)
        ].join('-');
    }

    function autocompletecustomer(customer_id){
        $.ajax({
                type: 'GET',
                dataType: 'JSON',
                data: 'customer_id=' +customer_id,
                url : '{{ url('incomes/customers/autocompletecustomer') }}',
                success:function(data){
                    $('#select2-customer_id-container').html(data.full_details.original.full_name);
                    $('#net_term').val(data.customer.net_term);
                    // This event Select2 Stylesheet
                    $('#net_term').trigger("change");
                    $('#customer_email').val(data.customer.customer_email);
                    $('#address').val(data.customer.address);
                    $('#shipping_address').val(data.customer.shipping_address);
                    //var dt = new Date();
                    //dt.setDate(dt.getDate() + +data.customer.terms.term_days);
                    //$("#due_at").datepicker('setDate', dt);
                    
                    if(data.customer.cc_email){
                        $('#cc_email').val(data.customer.cc_email);
                        $('#cc_count').html( '(' + '1' + ')').show();
                        
                        
                    }else{
                            $('#cc_email').val();
                        $('#cc_count').hide();
                    }
                    if(data.customer.bill_to==='parent'){
                        $('#customer_invoice_parent_id').val(data.parent_id);
                    }else{
                        $('#customer_invoice_parent_id').val(data.customer.id);
                    }
                },
                error:function(error){
                    console.log(error);
                }
            });
    }

    function totalItem() {
        $.ajax({
            url: '{{ url("items/items/totalItem") }}',
            type: 'POST',
            dataType: 'JSON',
            data: $('#currency_code, #items input[type=\'text\'],#items input[type=\'hidden\'], #items textarea, #items select'),
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            success: function(data) {
                if (data) {
                    $.each( data.items, function( key, value ) {
                        $('#item-total-' + key).html(value);
                    });

                    $('#sub-total').html(data.sub_total);
                    /*$('#tax-total').html(data.tax_total);*/
                    $('#grand-total').html(data.grand_total);
                }
            }
        });
    }
</script>
@endsection
