@extends('layouts.default')
@section('title', 'New Invoice')
<style>
	.card-DboardStats {
	width: 110px !important;
	min-height: 30px !important;
	margin: 0px !important;
	padding: 5px 0px 0px 5px !important;
	}
	.custom-control {display:inline-block !important; min-height:0 !important;padding-left:1.2rem !important;}
	.custom-control.overflow-checkbox .overflow-control-indicator {
	position: absolute;
	left: 0px !important;
	top:2px !important;
	cursor:pointer;
	}
	#timesheetdetails .custom-control.overflow-checkbox .overflow-control-indicator {
	top:10px !important;
	}
</style>
@section('new_button')
<a href="{{ url('incomes/invoices ')}} " class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.invoices', 1) . ' List' }} </a>
@endsection
@section('content')
<!-- Default box -->
{!! Form::open(['url' => 'incomes/invoices', 'files' => true, 'role' => 'form']) !!}
<div class="row m-0">
	<h3 class="mb-3">Customer Info</h3>
</div>
<div class="card">
	<div class="row">
		<div class="col-lg-3 col-md-4 col-sm-4 {{ $errors->has('customer_id') ? 'has-error' : ''}}">
			<div class="row">
				<div class="col-lg-10 col-md-10 col-sm-10 pr-0">
					<div class="add-cust">
						<small> Customer</small>
						<select id="customer_id" name="customer_id"  class="selectpicker"tabindex="-98" data-live-search="true" required>
						@include('accounts.common.subloop', ['name' => trans('general.form.select.field', ['field' => 'Customers'])])     
						</select>
						{!! $errors->first('customer_id', '
						<p class="help-block">:message</p>
						') !!}
					</div>
				</div>
				<div class="col-lg-2 col-md-2 col-sm-2 pr-0">
					<div class="add-bttn pr-0">
						<button type="button" data-toggle="modal"  data-target="#modal-create-customer" id="modal-create-customer_button"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;">add </i></button>
					</div>
				</div>
			</div>
		</div>
		{!!   Form::hidden('customer_invoice_parent_id',null,['id' => 'customer_invoice_parent_id'])   !!}
		<div class="col-lg-3 col-md-4 col-sm-6">
			<div class="form-group">
				<input class="form-control"  name="customer_email" id="customer_email" type="text">
				<label for="customer_email" class="form-label">Email</label>
				<span class="form-controlBrd"></span>
				<div class="help-block">
					<div class="custom-controls-stacked d-block" style="position: absolute; top: 50px;left: 0;">
						<label class="custom-control overflow-checkbox" >
						<input type="checkbox" name="sendlater" id="sendlater" value="1" class="overflow-control-input">
						<span class="overflow-control-indicator" style="top:2px;"></span> <span class="overflow-control-description"> Send Later</span><a href="#"  data-toggle="modal" data-target="#modal-another-email" > Cc <span id="cc_count" style="display: none"></span>/Bcc <span id="bcc_count" style="display: none"></span></a>  </label>
					</div>
					<input type="hidden" name="cc_email" id="cc_email">
					<input type="hidden" name="bcc_email" id="bcc_email">
				</div>
			</div>
		</div>
		{{--  {{ Form::textGroup('customer_email', trans('general.email'), 'envelope', []) }} --}}
		{!! Form::hidden('currency_code', setting('general.default_currency') , ['id' => 'currency_code']) !!}

		<div class="col-lg-3 col-md-4 col-sm-6  {{ $errors->has('net_term') ? 'has-error' : ''}}">
			<div class="row">
				<div class="col-md-10 pr-0">
					<div class="add-cust">
						<small>Terms</small>
						{!! Form::select('net_term', $terms,null, array_merge(['id'=>'net_term','class' => 'selectpicker', 'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)]),'required','data-live-search'=>'true' ] )) !!}  
						{!! $errors->first('net_term', '
						<p class="help-block">:message</p>
						') !!}       
					</div>
				</div>
				<div class="col-md-2 pl-0 pr-0">
					<div class="add-bttn">
						<button type="button" data-toggle="modal" id="modal-create-term-button" data-target="#modal-create-term"   class="btn btn-xs btn-primary" data-original-title="Add"><i class="material-icons" style="font-size:14px;padding:0px;">add </i></button>
					</div>
				</div>
			</div>
		</div>

		<div class="col-md-3">
			{{ Form::textGroup('invoice_number', trans('invoices.invoice_number'), $number, ['required' => 'required']) }}
		</div>
		<div class="col-md-3">
			{{ Form::textGroup('invoiced_at', trans('invoices.invoice_date'), date('Y-m-d'), ['id' => 'invoiced_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }} 
		</div>
		<div class="col-md-3">
			{{ Form::textGroup('due_at', 'Due at', date('Y-m-d'), ['id' => 'due_at', 'class' => 'form-control', 'data-inputmask' => '\'alias\': \'yyyy-mm-dd\'']) }}
		</div>
	</div>
	<div class="row">
		<div class="col-lg-6 col-md-6 col-sm-6">
			<div class="form-groupTextArea">
				<textarea class="form-ControlTextArea"  rows="3" name="address" cols="50" id="address"></textarea>
				<label for="address" class="form-label">{{trans('general.billingaddress')}}</label>
				<span class="form-controlBrd"></span>
			</div>
		</div>
		<div class="col-lg-6 col-md-6 col-sm-6">
			<div class="form-groupTextArea">
				{{ Form::textarea('shipping_address', null ,['class'=>'form-ControlTextArea shipping_address' , 'id'=> 'shipping_address' ,'rows' => 3]) }}
				<label for="shipping_address" class="form-label">Shipping Address</label>
				<span class="form-controlBrd"></span>
			</div>
		</div>
	</div>
</div>
<input type="hidden" id="customer_timesheet">
{{-- Timesheet Display --}}
<div id="time_card" >
</div>
{{-- Timesheet Hours  Display --}}
<div id="timesheetdetails" >
</div>
<div class="clearfix"></div>
<div class="">
	<h3 class="mt-3 mb-3">Items</h3>
	<div class="">
		<table class="table table-bordered tabl-input table-striped" id="items">
			<thead>
				<tr style="background-color: #f9f9f9;">
					<th width="5%">{{ trans('general.actions') }}</th>
					<th width="25%">{{ trans('general.name') }}</th>
					<th width="25%">{{ trans('general.description') }}</th>
					<th width="15%">{{ trans('invoices.quantity') }}</th>
					<th width="15%">{{ trans('invoices.price') }}</th>
					<th width="15%">{{ trans('invoices.total') }}</th>
				</tr>
			</thead>
			<tbody>
				<?php $item_row = 0; ?>
				<tr id="item-row-{{ $item_row }}">
					<td>
						<button type="button" onclick="$('#item-row-{{ $item_row }}').remove(); totalItem(); items_refresh({{ $item_row }});" data-toggle="tooltip" title="{{ trans('general.delete') }}"  class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons" >delete </i></button>
					</td>
					<td >
						<select onchange="autoItem({{ $item_row }})" id="item-id-{{ $item_row }}" required="required" class="selectpicker" name="item[{{ $item_row }}][item_id]"  data-live-search="true" >
						@include('accounts.common.subitem',['name' => trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) ])
						</select>
						<input class="form-control"   name="item[{{ $item_row }}][name]" type="hidden" id="item-name-{{ $item_row }}">
						<input class="form-control"   name="item[{{ $item_row }}][chartid]" type="hidden" id="item-chartid-{{ $item_row }}">
					</td>
					<td>
						<div class="form-group">
							<input class="form-control" required="required" name="item[{{ $item_row }}][description]" type="text" id="item-description-{{ $item_row }}">
							<label class="form-label">{{  trans('general.description') }} <span class="RED-Star">*</span> </label>
							<span class="form-controlBrd"></span>
						</div>
					</td>
					<td>
						<div class="form-group">
							<input class="form-control" required="required" name="item[{{ $item_row }}][quantity]" type="text" id="item-quantity-{{ $item_row }}">
							<label class="form-label">Quantity</label>
							<span class="form-controlBrd"></span>
						</div>
					</td>
					<td>
						<div class="form-group">
							<input class="form-control price"  required="required" name="item[{{ $item_row }}][price]" type="text" id="item-price-{{ $item_row }}">
							<label class="form-label">Price</label>
							<span class="form-controlBrd"></span>
						</div>
					</td>
					<td>
						<span id="item-total-{{ $item_row }}">0</span>
					</td>
				</tr>
				<?php $item_row++; ?>
				<tr id="addItem">
					<td><button type="button" onclick="addItem();" data-toggle="tooltip" title="{{ trans('general.add') }}" class="btn btn-xs  btn-outline-info btn-circle-iconic btn34" data-original-title="{{ trans('general.add') }}"><i class="material-icons">add </i></button></td>
					<td class="text-right" colspan="5"></td>
				</tr>
				<tr>
					<td class="text-right" colspan="5"><strong>{{ trans('invoices.sub_total') }}</strong></td>
					<td class="text-right"><span id="sub-total">0</span></td>
				</tr>
				<tr>
					<td class="text-right" colspan="5"><strong>{{ trans('invoices.total') }}</strong></td>
					<td class="text-right"><span id="grand-total">0</span></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
{{ Form::fileGroup('attachment', trans('general.attachment')) }}
<div class="row">
	<div class="col-lg-6 col-md-6 col-sm-6 mt-2">
		{{ Form::textareaGroup('notes', trans_choice('general.notes', 2)) }}
	</div>
	<div class="col-lg-6 col-md-6 col-sm-6 mrg-top-5">
		<div class="form-group no-margin text-right">
			<button class="btn mr-3 btn-default waves-effect waves-gray" id="reset_invoice" type="reset"> Reset</button>
			<a href="{{ url('incomes/invoices') }}" class="btn mr-3 btn-default waves-effect waves-gray">Cancel</a>
			<button type="submit" class="btn btn-primary waves-effect waves-light">Save</button>
		</div>
	</div>
	{{--  {{ Form::saveButtons('incomes/invoices') }} --}}
</div>
<!-- /.box-footer -->
{!! Form::close() !!}
</div>
<!-- Create Customer Model -->
<div class="modal fade" id="modal-create-customer"  >
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ trans('general.title.new', ['type' => trans_choice('general.customers', 1)]) }}</h4>
			</div>
			<div class="modal-body">
				{!! Form::open(['id' => 'form-create-customer', 'role' => 'form']) !!}
				<div class="row">
					<div class="col-md-6">
						<div class="form-group  required">
							<input class="form-control"  required name="name" type="text" id="name">
							<label class="form-label">{{ trans('general.name') }}</label>
							<span class="form-controlBrd"></span>
							<div class="help-block with-errors"></div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group">
							<input class="form-control" required name="customer_email" type="text" id="email">
							<label for="email" class="form-label">{{ trans('general.email') }}</label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group required">
							<small>{{  trans_choice('general.net_term', 1) }} </small>
							{!! Form::select('net_term', $terms, null, array_merge(['class' => 'selectpicker net_term','id'=>'net_term_model','data-live-search'=>'true' ,'placeholder' => trans('general.form.select.field', ['field' => trans_choice('general.net_term', 1)])])) !!}
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group ">
							<input class="form-control"  name="phone" id="phone" type="text">
							<label for="phone" class="form-label">Phone</label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group ">
							<div class="custom-controls-stacked d-block">
								<label class="custom-control overflow-checkbox" >
								<input type="checkbox"  name="subcustomer" id="subcustomer" value="1" class="overflow-control-input">
								<span class="overflow-control-indicator"></span> <small >  Is sub-customer</small> </label>
							</div>
							<select id="customer_id_save" name="customer_id_save"  class="selectpicker"  data-live-search="true" disabled="disabled">
								<option value="" selected="">- Select Sub Customer -</option>
								<?php echo subcustomertree($customers , $prefix = ''); ?>
							</select>
						</div>
					</div>
					@php 
					function subcustomertree($elements, $prefix = '') {
					foreach ($elements as $k=> $element) { 
					@endphp
					<option value="{{ $element['id'] }}">
						{{ $prefix . $element['name'] }} 
						@if (isset($element['children']))
						@php subcustomertree($element['children'], $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
						@endphp
						@endif
					</option>
					@php  } 
					}
					@endphp
					<div class="col-md-6">
						<div class="form-group ">
							<small>Bill To</small>
							{!! Form::select('bill_to', ['parent' => 'Bill With Parent' ,'customer' => 'Bill With Customer'], null, array_merge(['class' => 'selectpicker','id'=>'bill_to','disabled'=>'disabled'])) !!}
						</div>
					</div>
					{!! Form::hidden('enabled', '1', []) !!}
					{!! Form::hidden('currency_code', setting('general.default_currency') , ['id' =>'currency_code']) !!}
					<div class="col-md-6">
						<div class="form-groupTextArea ">
							<textarea class="form-ControlTextArea" rows="3" name="address" cols="50" id="address1"></textarea>
							<label for="address" class="form-label">{{ trans('general.billingaddress') }}</label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-groupTextArea  ">
							{!!  Form::textarea('shipping_address', null ,['class'=>'form-ControlTextArea shipping_address', 'id'=> 'shipping_address_customer' ,'rows' => 3]) !!}
							<label for="shipping_address" class="form-label">Shipping Address</label>
							<span class="form-controlBrd"></span>
							<div class="help-block with-errors">
								<div class="custom-controls-stacked d-block">
									<label class="custom-control overflow-checkbox" >
									<input type="checkbox" name="same_as_billing" id="same_as_billingvalue"value="1" class="overflow-control-input">
									<span class="overflow-control-indicator"></span> <span class="overflow-control-description"> Same as billing address </span> </label>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			{!! Form::close() !!}
			<div class="modal-footer">
				<div class="pull-left">
					<button type="button" id="close-modal-create-customer" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"> <span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
					{!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-customer', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
				</div>
			</div>
		</div>
	</div>
</div>
<!-- Create Net Term Model -->
<div class="modal fade" id="modal-create-term" >
	<div class="modal-dialog ">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">{{ trans('general.title.new', ['type' => trans_choice('general.net_term', 1)]) }}</h4>
			</div>
			<div class="modal-body">
				{!! Form::open(['id' => 'form-create-term', 'role' => 'form']) !!}
				<div class="row">
					<div class="col-md-6 ">
						<div class="form-group required">      
							<input class="form-control" required name="name" type="text" id="name">
							<label for="name" class="form-label">{{ trans('general.name') }}</label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
					<div class="col-md-6 required">
						<div class="form-group ">
							<input class="form-control" required name="term_days" type="text" id="term_days">
							<label for="name" class="form-label">Due in fixed number of days</label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
				</div>
				{!! Form::close() !!}
			</div>
			<div class="modal-footer">
				<div class="pull-left">
					<button type="button" id="close-modal-create-term" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
					{!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-create-term', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
				</div>
			</div>
		</div>
	</div>
</div>
{{-- Another Mail Model --}}
<div class="modal fade" id="modal-another-email" >
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">CC/BCC Email (Separate emails with a comma)</h4>
			</div>
			<div class="modal-body">
				{!! Form::open(['id' => 'form-another-email', 'role' => 'form']) !!}
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<input class="form-control"  required="required" name="cc"  type="email" id="cc" value=''>
							<label for="name" class="form-label">CC</label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
					<div class="col-md-6 ">
						<div class="form-group">
							<input class="form-control"   name="bcc" type="text"   id="bcc" value=''>
							<label for="name" class="form-label">BCC</label>
							<span class="form-controlBrd"></span>
						</div>
					</div>
				</div>
				{!! Form::close() !!}
			</div>
			<div class="modal-footer">
				<div class="pull-left">
					<button type="button" id="close-modal-create-email" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
					{!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-another-email', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
				</div>
			</div>
		</div>
	</div>
</div>
@include('includes.datepicker')
@php 
function productservice1($elements, $prefix = '' , $item_id) {
	foreach ($elements as $k=> $element) { 
@endphp
		<option value="{{ $element['id'] }}" 
		{{ ( $item_id == $element['id'] )?'selected':'' }}>
		{{ $prefix . $element['name'] }} 
		@if (isset($element['children']))
@php 
		productservice1($element['children'], $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $item_id);
@endphp
		@endif
		</option>
@php  
	} 
}
@endphp
<div id='productandservice_dropdown' style="display: none">
<?php echo productservice1($items , $prefix = '', 0 );?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-3-typeahead/4.0.1/bootstrap3-typeahead.min.js"></script>
<script type="text/javascript">
	var item_row = '{{ $item_row }}';
	
	function addItem() {
	    html  = '<tr id="item-row-' + item_row + '">';
	    html += '  <td  style="vertical-align: middle;">';
	    html += '      <button type="button" onclick="$(\'#item-row-' + item_row + '\').remove(); totalItem(); items_refresh('+ item_row + ');" data-toggle="tooltip" title="{{ trans('general.delete') }}" class="btn btn-xs  btn-outline-danger btn-circle-iconic btn34"><i class="material-icons">delete </i></button>';
	    html += '  </td>';
	
	    html += '  <td>';
	    html += '<select class="selectpicker" onchange="autoItem('+ item_row +')" name="item[' + item_row + '][item_id]" required="required" id="item-id-' + item_row + '"  data-live-search="true">';
	     html += '<option selected="selected" value="">{{ trans('general.form.select.field', ['field' => trans_choice('general.items', 1)]) }}</option>';
	
	    html += $('#productandservice_dropdown').html();
	    html += '</select>';
	    html += '<input class="form-control"  name="item['+ item_row +'][name]"        type="hidden" id="item-name-'+ item_row + '">';
	    html += '<input class="form-control"   name="item['+ item_row +'][chartid]" type="hidden" id="item-chartid-'+item_row +'">';
	    html += '  </td>';
	    html +=' <td>';
	    html += '<div class="form-group">';
	    html += '<input class="form-control" required="required" name="item[{{ $item_row }}][description]" type="text" id="item-description-{{ $item_row }}">';
	    html +=  '<label class="form-label">{{  trans('general.description') }} <span class="RED-Star">*</span> </label>';
	    html += '<span class="form-controlBrd"></span>'
	    html += '</div></td>';
	    html += '  <td>';
	    html += ' <div class="form-group"><input class="form-control" required="required" name="item[' + item_row + '][quantity]" type="text" id="item-quantity-' + item_row + '"><label class="form-label">Quantity</label> <span class="form-controlBrd"></span></div>';
	    html += '  </td>';
	    html += '  <td>';
	    html += '<div class="form-group"><input class="form-control" required="required" name="item[' + item_row + '][price]" type="text" id="item-price-' + item_row + '"><label class="form-label">Price</label> <span class="form-controlBrd"></span></div>';
	    html += '  </td>';
	    html += '  <td style="vertical-align: middle;">';
	    html += '      <span id="item-total-' + item_row + '">0</span>';
	    html += '  </td></tr>';
	
	    $('#items tbody #addItem').before(html);
	
	    $('#item-id-'+ item_row).selectpicker('refresh');
	
	    item_row++;
	}

	var autocomplete_path = "{{ url('items/items/autocompletebill') }}";

	function autoItem (id){	   
	    var item_id = $("#item-id-"+id).val();
	    //var item_name = $("#item-id-"+id).text();
	    $.ajax({
	        url: autocomplete_path,
	        type: 'GET',
	        dataType: 'JSON',
	        data: 'query=' + item_id + '&type=invoice&currency_code=' + $('#currency_code').val(),
	        success: function(data) {
	            var quantity = $('#item-quantity-' + id).val();
	            $('#item-name-'+id).val(data.name);
	            $('#item-quantity-' + id).val('1');
	            $('#item-price-' + id).val(data.sale_price);
	            $('#item-chartid-' +id).val(data.income_account);
	            $('#item-total-' + id).html(data.total);
	            totalItem(); 
	        }
	    });
	    var employee_id = $('#customer_timesheet').val();
	    
	    if(employee_id != "0" && employee_id != ''){
	        $('#timesheetdetails').html('');
	        $('#item-approvedays-'+id).remove();
	        var items_array = '<option>- Select Products and Services (Items) -</option>';
	        $('table#items > tbody > tr').not(':last').each(function(){
	            if($(this).attr('id')){
	            var present_id = $(this).attr('id').split('-')[2];
	                if(present_id){ 
	                    if( present_id == id){ var select = 'selected' } else { select = ''};
	                    var present_item_name = $("#item-id-"+present_id).find('option:selected').text();
	                    items_array += '<option value="'+present_id+'" '+select+'>'+present_item_name+'</option>';
	                };
	            }
	        });
	        $('#timesheetdetails').html('<div id="span-loader"><span class="span-loader text-center"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="height:100px"></span></div>');
	        $.ajax({
	            type:'GET',
	            dataType :'JSON',
	            url:'{{ url('payrole/timesheetdetails') }}'+'/'+employee_id,
	            success:function(result){
	                if(result){
	                    var Year_Months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
	                    var array_convert =  [];
	                    $("input[name='approved_days_array[]']").each(function(){
	                        value = this.value.split(',');
	                        if(value.length > 0){
	                            $.each(value,function(i,v){
	                                array_convert.push(v);
	                            });
	                        }else{
	                            array_convert.push(this.value);
	                        }
	                    });  
	
	                    html = '<h3 class="mt-3 mb-3">TIME SHEET</h3> {!! Form::open(['id' => 'form-create-timesheet', 'role' => 'form']) !!}<div> <div class="pmd-tabs pmd-tabs-bg horizantTabs"> <ul role="tablist" class="nav nav-tabs secondarySubMeu inner-submenu" id="myTab">'; 
	
	                    for (i=0; i<12; i++) {
	                        if((i+1) <= moment().format("M")){
	                        if(moment().format("M") == (i+1) ){
	                            var active_class = "active"; }
	                        else{var active_class = ''; }
	                      html += '<li class="nav-item"> <a class="nav-link waves-effect waves-gray '+active_class +'" data-toggle="tab" href="#timesheet_tab_'+ (i+1) +'" role="tab">'+Year_Months[i]+'</a> </li>';
	                         }
	                    } 
	                    html += '</ul> </div>';
	
	                    html += '<div class="pmd-card-body horizantTabsBodyContainer"> <div class="tab-content">'; 
	                    
	                    $.each(result,function(main_index,data){	                        
	                        if(moment().format("M") == main_index){
	                            var active_class = "active";
	                        }else{var active_class = ''; }
	                        /* Regular Hours Start*/
	                        html += '<div class="tab-pane tab-margin '+active_class+'" id="timesheet_tab_'+main_index+'"><table class="table table-bordered tabl-input table-striped" id="regular_hours"> <thead> <tr> <th width="20%" >Weeks</th> <th width="10%">Monday</th> <th width="10%">Tuesday</th> <th width="10%">Wednesday</th> <th width="10%">Thursday</th> <th width="10%">Friday</th> <th width="10%">Saturday</th> <th width="10%">Sunday</th> <th width="10%">Total</th> </tr> </thead><tbody><input type="hidden" value="{{ csrf_token() }}" name="_token"><input type="hidden" value="'+id+'"  id="item_id"  name="item_id">';
	                        html += '<tr> <td colspan="9" class="text-left"><label class="timesheet-title"> REGULAR HOURS</label></td></tr>';
	                        $.each(data,function(index,value){
	                            var approved_days = $.parseJSON(value.approved_days); 
	                            html += '<tr id="reg_'+index+'">  <th  class="text-center">'+moment().year(value.year_value).week(value.week_value).startOf('isoWeek').format("DD-MM-YYYY")+' - '+moment().year(value.year_value).week(value.week_value).endOf('isoWeek').format("DD-MM-YYYY")+'</th>';
	                            if(value.monday !== null && typeof(value.monday) !== 'undefined'){ 
	                                var monday = $.parseJSON(value.monday);
	                                let id =  'monday_'+value.id;
	                                if(array_convert.length > 0  && monday.WH != 0 && approved_days.monday != 'approved' && ($.inArray(id,array_convert) !== -1)){ 
	                                    html += timesheet_html(monday.WH,id,value.year_value,value.week_value,"Monday",'checked');
	                                }else if(monday.WH != 0 && approved_days.monday != 'approved'){ 
	                                    html += timesheet_html(monday.WH,id,value.year_value,value.week_value,"Monday",'');
	                                }else if(monday.WH != 0 && approved_days.monday == 'approved'){ 
	                                    html += timesheet_html(monday.WH,id,value.year_value,value.week_value,"Monday",'checked');
	                                }else {
	                                    html += '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.tuesday !== null && typeof(value.tuesday) !== 'undefined'){ 
	                                var tuesday = $.parseJSON(value.tuesday); 
	                                var id =  'tuesday_'+value.id;
	                                if(array_convert.length > 0 && tuesday.WH != 0 && approved_days.tuesday != 'approved' && ($.inArray(id,array_convert) !== -1) ){
	                                    html += timesheet_html(tuesday.WH,id,value.year_value,value.week_value,"Tuesday",'checked'); 
	                                }else if(tuesday.WH != 0 &&  approved_days.monday != 'approved'){
	                                    html += timesheet_html(tuesday.WH,id,value.year_value,value.week_value,"Tuesday",'');
	                                }else if(tuesday.WH != 0 &&  approved_days.monday == 'approved'){
	                                    html += timesheet_html(tuesday.WH,id,value.year_value,value.week_value,"Tuesday",'checked');
	                                }else {
	                                    html+= '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.wednesday !== null && typeof(value.wednesday) !== 'undefined'){ 
	                                var wednesday = $.parseJSON(value.wednesday);
	                                var id =  'wednesday_'+value.id;
	                                if(wednesday.WH != 0 && array_convert.length > 0 && ($.inArray(id,array_convert) !== -1) && approved_days.wednesday != 'approved'){
	                                  html += timesheet_html(wednesday.WH,id,value.year_value,value.week_value,"Wednesday",'checked');
	                                }else if(wednesday.WH != 0 && approved_days.wednesday != 'approved' ){
	                                    html += timesheet_html(wednesday.WH,id,value.year_value,value.week_value,"Wednesday",'');
	                                }else if(wednesday.WH != 0 && approved_days.wednesday == 'approved' ){
	                                    html += timesheet_html(wednesday.WH,id,value.year_value,value.week_value,"Wednesday",'checked');
	                                }else {
	                                    html+= '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.thursday !== null && typeof(value.thursday) !== 'undefined'){ 
	                                var thursday = $.parseJSON(value.thursday);
	                                var id =  'thursday_'+value.id;
	                                if(thursday.WH != 0 && approved_days.thursday != 'approved' && array_convert.length > 0 && ($.inArray(id,array_convert) !== -1)){
	                                    html += timesheet_html(thursday.WH,id,value.year_value,value.week_value,"Thursday",'checked');
	                                }else if(thursday.WH != 0 && approved_days.thursday != 'approved' ){
	                                    html += timesheet_html(thursday.WH,id,value.year_value,value.week_value,"Thursday",'');
	                                }else if(thursday.WH != 0 && approved_days.thursday == 'approved' ){
	                                    html += timesheet_html(thursday.WH,id,value.year_value,value.week_value,"Thursday",'checked');
	                                }else {
	                                     html+= '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.friday !== null && typeof(value.friday) !== 'undefined'){ 
	                                var friday = $.parseJSON(value.friday);
	                                var id =  'friday_'+value.id;
	                                if(friday.WH != 0 && approved_days.friday != 'approved' && array_convert.length >= 0 && ($.inArray(id,array_convert) !== -1)){ 
	                                    html += timesheet_html(friday.WH,id,value.year_value,value.week_value,"Friday",'checked');
	                                }else if(friday.WH != 0 && approved_days.friday != 'approved' ){ 
	                                    html += timesheet_html(friday.WH,id,value.year_value,value.week_value,"Friday",'');
	                                }else if(friday.WH != 0 && approved_days.friday == 'approved' ){ 
	                                    html += timesheet_html(friday.WH,id,value.year_value,value.week_value,"Friday",'checked');
	                                }else{ 
	                                      html+= '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.saturday !== null && typeof(value.saturday) !== 'undefined'){ 
	                                var saturday = $.parseJSON(value.saturday);
	                                var id =  'saturday_'+value.id;
	                                if(saturday.WH !=0 && approved_days.saturday != 'approved' && array_convert.length > 0 && $.inArray(id,array_convert) !== -1){
	                                        html += timesheet_html(saturday.WH,id,value.year_value,value.week_value,"Saturday",'checked');
	                                }else if(saturday.WH !=0 && approved_days.saturday != 'approved'){
	                                    html += timesheet_html(saturday.WH,id,value.year_value,value.week_value,"Saturday",'');
	                                }else if(saturday.WH !=0 && approved_days.saturday == 'approved'){
	                                    html += timesheet_html(saturday.WH,id,value.year_value,value.week_value,"Saturday",'checked');
	                                }else {
	                                     html+= '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.sunday !== null && typeof(value.sunday) !== 'undefined'){ 
	                                var sunday = $.parseJSON(value.sunday);
	                                var id =  'sunday_'+value.id;
	                                if(sunday.WH !=0 && approved_days.sunday != 'approved' && array_convert.length >=0 && ($.inArray(id,array_convert) !== -1)){
	                                    html += timesheet_html(sunday.WH,id,value.year_value,value.week_value,"Sunday",'checked');
	                                }else if(sunday.WH !=0 && approved_days.sunday != 'approved' ){ 
	                                    html += timesheet_html(sunday.WH,id,value.year_value,value.week_value,"Sunday",'');
	                                }else if(sunday.WH !=0 && approved_days.sunday == 'approved' ){ 
	                                    html += timesheet_html(sunday.WH,id,value.year_value,value.week_value,"Sunday",'checked');
	                                }else{
	                                    html+= '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }
	                           html += ' <td width="8%">0</td> </tr>';
	                        });
	                        html += '<tr> <td colspan="9" class="text-left"><label class="timesheet-title"> OT HOURS</label></td></tr>';
	
	                        $.each(data,function(index,value){ 
	                            var approved_daysot = $.parseJSON(value.approved_daysot);
	                            html += '<tr id="ot_'+index+'"> <th  class="text-center">'+moment().year(value.year_value).week(value.week_value).startOf('isoWeek').format("DD-MM-YYYY")+'To'+moment().year(value.year_value).week(value.week_value).endOf('isoWeek').format("DD-MM-YYYY")+'</th>';
	                            if(value.monday !== null && typeof(value.monday) !== 'undefined'){ 
	                                var monday = $.parseJSON(value.monday);
	                                let id =  'monday_ot_'+value.id;
	                                if(array_convert.length > 0  && monday.OT != 0 && approved_daysot.mondayot != 'approved' && ($.inArray(id,array_convert) !== -1)){ 
	                                    html += timesheet_html_ot(monday.OT,id,value.year_value,value.week_value,"Monday",'checked');
	                                }else if(monday.OT != 0 && approved_daysot.mondayot != 'approved'){ 
	                                    html += timesheet_html_ot(monday.OT,id,value.year_value,value.week_value,"Monday",'');
	                                }else if(monday.OT != 0 && approved_daysot.mondayot == 'approved'){ 
	                                    html += timesheet_html_ot(monday.OT,id,value.year_value,value.week_value,"Monday",'checked');
	                                }else {
	                                    html += '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.tuesday !== null && typeof(value.tuesday) !== 'undefined'){ 
	                                var tuesday = $.parseJSON(value.tuesday); 
	                                let id =  'tuesday_ot_'+value.id;
	                                if(array_convert.length > 0 && tuesday.OT != 0 && approved_daysot.tuesdayot != 'approved' && ($.inArray(id,array_convert) !== -1) ){
	                                    html += timesheet_html_ot(tuesday.OT,id,value.year_value,value.week_value,"Tuesday",'checked'); 
	                                }else if(tuesday.OT != 0 &&  approved_daysot.tuesdayot != 'approved'){
	                                    html += timesheet_html_ot(tuesday.OT,id,value.year_value,value.week_value,"Tuesday",'');
	                                }else if(tuesday.OT != 0 &&  approved_daysot.tuesdayot == 'approved'){
	                                    html += timesheet_html_ot(tuesday.OT,id,value.year_value,value.week_value,"Tuesday",'checked');
	                                }else {
	                                    html += '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.wednesday !== null && typeof(value.wednesday) !== 'undefined'){ 
	                                var wednesday = $.parseJSON(value.wednesday);
	                                let id =  'wednesday_ot_'+value.id;
	                                if(wednesday.OT != 0 && array_convert.length > 0 && ($.inArray(id,array_convert) !== -1) && approved_daysot.wednesdayot != 'approved'){
	                                  html += timesheet_html_ot(wednesday.OT,id,value.year_value,value.week_value,"Wednesday",'checked');
	                                }else if(wednesday.OT != 0 && approved_daysot.wednesdayot != 'approved' ){
	                                    html += timesheet_html_ot(wednesday.OT,id,value.year_value,value.week_value,"Wednesday",'');
	                                }else if(wednesday.OT != 0 && approved_daysot.wednesdayot == 'approved' ){
	                                    html += timesheet_html_ot(wednesday.OT,id,value.year_value,value.week_value,"Wednesday",'checked');
	                                }else {
	                                    html += timesheet_html_ot(wednesday.OT,id,value.year_value,value.week_value,"Wednesday",'checked');
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.thursday !== null && typeof(value.thursday) !== 'undefined'){ 
	                                var thursday = $.parseJSON(value.thursday);
	                                let id =  'thursday_ot_'+value.id;
	                                if(thursday.OT != 0 && approved_daysot.thursdayot != 'approved' && array_convert.length > 0 && ($.inArray(id,array_convert) !== -1)){
	                                    html += timesheet_html_ot(thursday.OT,id,value.year_value,value.week_value,"Thursday",'checked');
	                                }else if(thursday.OT != 0 && approved_daysot.thursdayot != 'approved' ){
	                                    html += timesheet_html_ot(thursday.OT,id,value.year_value,value.week_value,"Thursday",'');
	                                }else if(thursday.OT != 0 && approved_daysot.thursdayot == 'approved' ){
	                                    html += timesheet_html_ot(thursday.OT,id,value.year_value,value.week_value,"Thursday",'checked');
	                                }else {
	                                    html += '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.friday !== null && typeof(value.friday) !== 'undefined'){ 
	                                var friday = $.parseJSON(value.friday);
	                                let id =  'friday_ot_'+value.id;
	                                if(friday.OT != 0 && approved_daysot.fridayot != 'approved' && array_convert.length >= 0 && ($.inArray(id,array_convert) !== -1)){ 
	                                    html += timesheet_html_ot(friday.OT,id,value.year_value,value.week_value,"Friday",'checked');
	                                }else if(friday.OT != 0 && approved_daysot.fridayot != 'approved' ){ 
	                                    html += timesheet_html_ot(friday.OT,id,value.year_value,value.week_value,"Friday",'');
	                                }else if(friday.OT != 0 && approved_daysot.fridayot == 'approved' ){ 
	                                    html += timesheet_html_ot(friday.OT,id,value.year_value,value.week_value,"Friday",'checked');
	                                }else{ 
	                                    html += '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.saturday !== null && typeof(value.saturday) !== 'undefined'){ 
	                                    var saturday = $.parseJSON(value.saturday);
	                                    let id =  'saturday_ot_'+value.id;
	                                if(saturday.OT !=0 && approved_daysot.saturdayot != 'approved' && array_convert.length > 0 && $.inArray(id,array_convert) !== -1){
	                                        html += timesheet_html_ot(saturday.OT,id,value.year_value,value.week_value,"Saturday",'checked');
	                                }else if(saturday.OT !=0 && approved_daysot.saturdayot != 'approved'){
	                                    html += timesheet_html_ot(saturday.OT,id,value.year_value,value.week_value,"Saturday",'');
	                                }else if(saturday.OT !=0 && approved_daysot.saturdayot == 'approved'){
	                                    html += timesheet_html_ot(saturday.OT,id,value.year_value,value.week_value,"Saturday",'checked');
	                                }else {
	                                    html += '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }if(value.sunday !== null && typeof(value.sunday) !== 'undefined'){ 
	                                    var sunday = $.parseJSON(value.sunday);
	                                    let id =  'sunday_ot_'+value.id;
	                                if(sunday.OT !=0 && approved_daysot.sundayot != 'approved' && array_convert.length >=0 && ($.inArray(id,array_convert) !== -1)){
	                                    html += timesheet_html_ot(sunday.OT,id,value.year_value,value.week_value,"Sunday",'checked');
	                                }else if(sunday.OT !=0 &&approved_daysot.sundayot != 'approved' ){ 
	                                    html += timesheet_html_ot(sunday.OT,id,value.year_value,value.week_value,"Sunday",'');
	                                }else if(sunday.OT !=0 && approved_daysot.sundayot == 'approved' ){ 
	                                    html += timesheet_html_ot(sunday.OT,id,value.year_value,value.week_value,"Sunday",'checked');
	                                }else{
	                                    html += '<td>  - </td>';
	                                }
	                            }else{
	                                html+= '<td>  - </td>';
	                            }
	                           html += ' <td width="8%">0</td> </tr>';
	                        });
	
	                        html  += '</tbody> </table></div>';    
	                    });    
	                    html += '<div class="row "><div class="col-md-6"></div> <div class="col-md-3 pull-left" id="reg_hours"><small> Select Item <span class="RED-Star"> * </span> </small><select class="selectpicker" data-live-search="true"  id="reg_hours_select">'+items_array+'</select></div><div class="col-md-3"><div class="pull-right"> <button type="button" id="close-modal-timesheet" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"><span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button> {!! Form::button('Add', ['type' => 'button', 'id' =>'button-create-timesheet', 'class' => 'btn btn-primary waves-effect waves-light']) !!}</div></div></div>{!! Form::close() !!}';
	
	                    html +=  '</div></div> </div>';
	                   
	                    $('#timesheetdetails').append(html);
	                    $('.selectpicker').selectpicker('refresh'); 
	                    $('#span-loader').remove();
	
	                    // $("input[name^='approvetimesheet[]']").on('change',function(){	
	                    //     //Do Staff	
	                    // });
	                }
	            }
	        });
	    }
	}	
	
	$(document).ready(function(){
		// On change Net Terms
	    $('#net_term').on('change',function(){
	        var term_id = $(this).val();
	        var invoiced_at = $('#invoiced_at').val().replace(/-/g,'/'); 
			
	        if(term_id){
	            $.ajax({
	                type: 'GET',
	                dataType: 'JSON',
	                url : '{{ url('netterms/get_netterms/') }}' +'/'+term_id,
	                success:function(data){	                 
	                    if(data.term_days == 0) {
	                        var netterm = data.term_days;
	                    } else {
	                        var netterm = (data.term_days - 1);
	                    }
	                    var dt = new Date(invoiced_at);
	                    dt.setDate(dt.getDate() + +netterm); //console.log(dt);
	                    var date = gj.core.formatDate(dt, 'yyyy-mm-dd');
	                    $("#due_at").val(date);	
	                },
	                error:function(error){
	                    console.log(error);
	                }
	            });
	        }
	    });
		
		// On change Sub Customer
	    $('#subcustomer').on('change',function(){
	        if(this.checked){
	            $('#customer_id_save').removeAttr('disabled');
	            $('#bill_to').removeAttr('disabled');
	        }else{
	            $('#customer_id_save').attr('disabled','disabled');
	            $('#bill_to').attr('disabled','disabled');
	        };
	        $('#customer_id_save').selectpicker('refresh');
	        $('#bill_to').selectpicker('refresh');
	    });

		$('#invoiced_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
		$('#invoiced_at').datepicker({
			format: 'yyyy-mm-dd',
			todayHighlight: true,
			clearBtn: true
		});

		$('#due_at').inputmask('yyyy-mm-dd', { placeholder: 'yyyy-mm-dd' });
		$('#due_at').datepicker({
			format: 'yyyy-mm-dd',
			todayHighlight: true,
			clearBtn: true,
			minDate: $('#invoiced_at').val(),
		});
	    
	    $('#invoiced_at').on('change',function(){
	        var invoiced_at = $(this).val();
	        var term_id = $('#net_term').val();
	        if(term_id){
	            $.ajax({
	                type: 'GET',
	                dataType: 'JSON',
	                url : '{{ url('netterms/get_netterms/') }}' +'/'+term_id,
	                success:function(data){	                 
	                    if(data.term_days == 0){
	                        var netterm = data.term_days;
	                    }else{
	                        var netterm = (data.term_days - 1);
	                    }
	                    var dt = new Date(invoiced_at);
	                    dt.setDate(dt.getDate() + +netterm); //console.log(dt);
	                    var date = gj.core.formatDate(dt,'{{ $date_format }}');
	                    $("#due_at").datepicker("destroy");
	                    $("#due_at").addClass('form-control has-value');
	                    $('#due_at').datepicker({
	                        format: '{{ $date_format }}',
	                        minDate: invoiced_at,
	                        autoclose: true
	                    });
	                    $("#due_at").val(date);
	                },
	                error:function(error){
	                    console.log(error);
	                }
	            });
	        }	
	    });	
	
	    $(document).on('click','#reset_invoice',function(){
	        $("input[name='approved_days_array[]']").each(function(){ }).remove(); 
	        $("input[name='approved_days_hours[]']").each(function(){ }).remove();
	        $('#timesheetdetails').html(''); 
	    });	
	
	    $(document).on('change', '#currency_code, #items tbody select', function(){
	        totalItem();
	    });
	
	    $(document).on('keyup', '#items tbody .form-control', function(){
	        totalItem();
	    });
	
	    var customer_id = $('#customer_id').val();
	    if(customer_id != '' ){
	        autocompletecustomer(customer_id);
	    }
	    $('#customer_id').on('change',function(){
	        var val = $(this).val();
	        if(val && val !== 'add_new_customer') {
	            autocompletecustomer(val);
	            showtimecard(val);
	        }else{
	            $('#modal-create-customer_button').trigger('click');
	        }
	    });
	
	    $('#same_as_billingvalue').change(function(){
	        var c = this.checked;
	        $('#shipping_address_customer').prop('disabled', c);
	        if(c){ 
	            $('#shipping_address_customer').val($('#address1').val());
	            $('#shipping_address_customer').addClass('has-value');
	        }else{
	             $('#shipping_address_customer').val('');
	               $('#shipping_address_customer').removeClass('has-value');
	        }
	    });
	});
	
	// $(document).on('change','#same_as_billingvalue',function(e){
	//     alert();
	// });
	
	$(document).on('click', '#button-create-customer', function (e) {
	    $('#modal-create-customer .modal-header').before('<div id="span-loader"><span class="span-loader text-center"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style=" height:100px"></span></div>');
	
	    $.ajax({
	        url: '{{ url("incomes/customers/customer") }}',
	        type: 'POST',
	        dataType: 'JSON',
	        data: $("#form-create-customer").serialize(),
	        beforeSend: function () {
	            $(".form-group").removeClass("has-error");
	            $(".help-block").remove();
	        },
	        success: function(data) {
	            autocompletecustomer(data.id);
	            $('#span-loader').remove();
	            $('#close-modal-create-customer').trigger('click');
	            $("#customer_id").append('<option value="' + data.id + '" selected="selected">' + data.name + '</option>');
	
	            $("#customer_id").selectpicker('refresh');
	        },
	        error: function(error, textStatus, errorThrown) {
	            console.log(error);
	            $('#span-loader').remove();
	
	            if (error.responseJSON.customer_email) {
	                $("input[name='customer_email']").parent().parent().addClass('has-error');
	                $("input[name='customer_email']").parent().after('<p class="help-block">' + error.responseJSON.customer_email + '</p>');
	            }
	
	            if (error.responseJSON.currency_code) {
	                $("select[name='currency_code']").parent().parent().addClass('has-error');
	                $("select[name='currency_code']").parent().after('<p class="help-block">' + error.responseJSON.currency_code + '</p>');
	            }
	        }
	    });
	});
	
	$(document).on('click', '#button-create-timesheet', function (e) { 
	
	    swal({
	        title: "Are you sure?",
	        text: "If you want Add  these Hours To Item",
	        icon: "warning", 
	        buttons: ["Cancel", "Add"],
	        dangerMode: true,
	    }).then((swal_response) => {
	      //swal(`The returned value is: ${safddsdfsdf}`);
	        if (swal_response) {
	        $('#timesheetdetails').before('<div id="span-loader"><span class="span-loader text-center"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="height:100px"></span></div>');
	
	        let item_id =  $('#reg_hours_select').val();
	        var previous_added_days = $('#item-approvedays-'+item_id).val();
	        var previous_added_hours = parseFloat($('#item-approvehours-'+item_id).val()) || 0;
	        var approved_days = [];
	        var value  = 0;
	        let html  = '';
	        let approved_days_html  = '';
	        approved_days.push(previous_added_days);
	        $("input[name='approvetimesheet[]']").each(function(){
	            if(this.checked && !this.disabled){
	                approved_days.push(this.id);
	                var id = this.id;
	                value += parseFloat($(this).val());
	                value += previous_added_hours;
	                $('#'+id).closest("tr").remove();
	            }
	        }); 
	        $('#item-approvedays-'+item_id).remove();
	        $('#item-approvehours-'+item_id).remove()
	         approved_days_html =  '<input class="form-control" name="approved_days_array[]" id="item-approvedays-'+item_id+'" type="hidden"   value="'+approved_days+'"><input class="form-control" name="approved_days_hours[]" id="item-approvehours-'+item_id+'" type="hidden" value="'+value+'">';
	        $('#item-row-'+item_id).append(approved_days_html);
	        $('#item-quantity-'+item_id).val(value);
	        $('#span-loader').remove();
	        $('#timesheetdetails').html('');
	        swal( value + " Hours Added");
	        totalItem();
	    } else {
	        swal("No Hours Added");
	      }
	    });
	});
	
	
	$(document).on('change','#timesheet_check_all',function(){
	    $("input[name='approvetimesheet[]']").prop('checked',this.checked); 
	});
	
	$(document).on('click', '#button-create-term', function (e) {
	    $('#modal-create-term .modal-header').before('<div id="span-loader"><span class="span-loader text-center"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style=" height:100px"></span></div>');
	
	    $.ajax({
	        url: '{{ url("/netterms/terms") }}',
	        type: 'POST',
	        dataType: 'JSON',
	        data: $("#form-create-term").serialize(),
	        beforeSend: function () {
	            $(".form-group").removeClass("has-error");
	            $(".help-block").remove();
	        },
	        success: function(data) {
	            $('#span-loader').remove();
	            $('#close-modal-create-term').trigger('click');
	            $("#net_term").append('<option value="' + data.id + '" selected="selected">' + data.name + '</option>');
	            $("#net_term").selectpicker('refresh');
	        },
	        error: function(error, textStatus, errorThrown) {
	            $('#span-loader').remove();
	        }
	    });
	});
	
	$(document).on('click', '#button-another-email', function(e){
	    $('#modal-another-email .modal-header').before('<div id="span-loader"><span class="span-loader text-center"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="height:100px"></span></div>');
	        var cc = $('#cc').val();
	        var bcc = $('#bcc').val();
	
	        var cc_count = $('#cc').val().split(',');
	        var bcc_count = $('#bcc').val().split(',');
	    
	
	        if (cc ){
	            $('#cc_email').val(cc);
	            $('#cc_count').html( '(' + cc_count.length + ')').show();
	            $(".form-group").removeClass("has-error");
	            $(".help-block").remove();   
	        } 
	        if (bcc){
	            $('#bcc_email').val(bcc);
	            $('#bcc_count').html( '(' + bcc_count.length + ')').show();
	            $(".form-group").removeClass("has-error");
	            $(".help-block").remove();
	        }
	        $('#close-modal-create-email').trigger('click');
	        $('#span-loader').remove();
	});
	
	function autocompletecustomer(customer_id){
	    $('#timesheetdetails').html('');
	    $.ajax({
	            type: 'GET',
	            dataType: 'JSON',
	            data: 'customer_id=' +customer_id,
	            url : '{{ url('incomes/customers/autocompletecustomer') }}',
	            success:function(data){
	               $('#select2-customer_id-container').html(data.full_details.original.full_name);
	               $('#net_term').val(data.customer.net_term);
	               $('#net_term').selectpicker('refresh');
	               // This event Select2 Stylesheet
	               $('#net_term').trigger("change");
	               $('#customer_email').val(data.customer.customer_email).addClass('has-value');
	               $('#address').val(data.customer.address).addClass('has-value');
	               $('#shipping_address').val(data.customer.shipping_address).addClass('has-value');
	               if(data.customer.consultant){
	                $('#customer_timesheet').val(data.customer.consultant);                     
	               }else{
	                $('#customer_timesheet').val('0');                     
	               }
	                if(data.customer.cc_email){
	                    $('#cc_email').val(data.customer.cc_email);
	                    $('#cc_count').html( '(' + '1' + ')').show();
	                }else{
	                    $('#cc_email').val();
	                    $('#cc_count').hide();
	                }
	                if(data.customer.bill_to==='parent'){
	                    $('#customer_invoice_parent_id').val(data.parent_id);
	                }else{
	                    $('#customer_invoice_parent_id').val(data.customer.id);
	                }
	            },
	            error:function(error){
	                console.log(error);
	            }
	        });
	}	
	
	function showtimecard(customer_id){
	    $('#time_card').html('');
	    var Year_Months = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
	    $.ajax({
	        url :'{{ url('payrole/timecard') }}'+'/'+customer_id,
	        success:function(data){
	            if(data){
	                var total_wh = 0.0;
	                var total_ot = 0.0;
	
	               html = '<h3 class="mt-3 mb-3">Time Cards</h3><div class="View-TimeSheet" style="height: 300px; overflow: auto; overflow-y: scroll;"><table class="table table-bordered " id="sum_table"> <thead> <tr> <th style="width:15%;">Summary <small>Month-Year</small> </th><th>Hours</th>';
	                   for(i=1;i<32;i++ ){
	                    html +=   '<th class="tablemiddel">'+i+'</th>';
	                   } 
	                html +=  '<th>Total</th></tr> </thead>';
	
	                html += '<tbody class="scheduleTable">';
	               
	                $.each(data,function(i,value){ 
	                    html +=' <td class="new_event_class" rowspan="2"> <span class="SchTbtmBrd"> <span class="label label-default view_event">'+ Year_Months[(value.month_value - 1)] +'-'+value.year_value +'</span></span> </td>';
	                     html +=' <td> REG </td>';
	
	                        for(j=1 ;j < 32 ; j++ ){
	                            var present_day = "day"+j;
	                            if(value[present_day] !== null && typeof(value[present_day]) !== 'undefined'){
	                                parse_value = $.parseJSON(value[present_day]);
	                             html += '<td>'+ addZeroes(parse_value.WH) +'</td>';
	                             total_wh += +addZeroes(parse_value.WH);
	                            }else{ html += '<td>-</td>'; }
	                        } 
	                    html += '<td>'+total_wh+'</td></tr>';
	                    html +='<tr>  </td>';
	                    html +=' <td> OT </td>';
	                        for(j=1 ;j < 32 ; j++ ){
	                            var present_day = "day"+j;
	                            if(value[present_day] !== null && typeof(value[present_day]) !== 'undefined'){
	                                parse_value = $.parseJSON(value[present_day]);
	                            html += '<td>'+ addZeroes(parse_value.OT) +'</td>';
	                            total_ot += +addZeroes(parse_value.OT);
	                            }else{ html += '<td>-</td>'; }
	                        }
	                    html += '<td>'+total_ot+'</td></tr>';
	
	                });
	
	                html +=  '</tbody> </table></div>';
	
	                $('#time_card').append(html);
	
	
	            }
	
	        },
	        error:function(){
	
	        }
	    });
	}
	
	$(document).ajaxStart(function(){
	    $("#wait").css("display", "block");
	});
	$(document).ajaxComplete(function(){
	    $("#wait").css("display", "none");
	});	
	
	function timesheet_html(hours,id,year_value,week_value,precentday,type){
	    if (type === 'checked') {  disable = 'disabled' } else{  disable = ''}
	    return '<td width="12%"> <div class="card-DboardStats flex-column  text-center"> <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="'+id+'" value="'+hours+'" class="overflow-control-input" '+type+' '+ disable +'> <span class="overflow-control-indicator '+ disable +'" ></span> <span class="overflow-control-description"></span>   <span class="inv-text">'+moment().day(precentday).isoWeek(week_value).year(year_value).format("YYYY-MM-DD")+'</span><span class="inv-amount">'+ addZeroes(hours)+' Hrs</span> </label></div> </td>';
	}   
	function timesheet_html_ot(hours,id,year_value,week_value,precentday,type){
	    if (type === 'checked') {  disable = 'disabled' } else{  disable = ''}
	    return '<td width="12%"> <div class="card-DboardStats flex-column  text-center"> <label class="custom-control overflow-checkbox"> <input type="checkbox" name="approvetimesheet[]" id="'+id+'" value="'+hours+'" class="overflow-control-input" '+type+' '+ disable +'> <span class="overflow-control-indicator '+ disable +'" ></span> <span class="overflow-control-description"></span>  <span class="inv-text">'+moment().day(precentday).isoWeek(week_value).year(year_value).format("YYYY-MM-DD")+'</span><span class="inv-amount">'+ addZeroes(hours)+' Hrs</span></label>  </div> </td>';
	} 
	function items_refresh(id){
	
	    $('#reg_hours_select option[value='+id+']').remove();
	    // $('#ot_hours_select option[value='+id+']').remove();
	
	    $('#reg_hours_select').selectpicker('refresh');
	    // $('#ot_hours_select').selectpicker('refresh');
	
	   // $("#select_id option[value='foo']").remove();
	
	}  
	       
	function totalItem() {
	    $.ajax({
	        url: '{{ url("items/items/totalItem") }}',
	        type: 'POST',
	        dataType: 'JSON',
	        data: $('#currency_code, #items input[type=\'text\'],#items input[type=\'hidden\'], #items textarea, #items select'),
	        headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
	        success: function(data) {
	            if (data) {
	                $.each( data.items, function( key, value ) {
	                    $('#item-total-' + key).html(value);
	                });
	
	                $('#sub-total').html(data.sub_total);
	                $('#grand-total').html(data.grand_total);
	            }
	        }
	    });
	}
	
	function format(input) {
	    var date = new Date(input);
	    return [
	       date.getFullYear(),
	       ("0" + (date.getMonth()+1)).slice(-2),
	       ("0" + date.getDate()).slice(-2)
	    ].join('-');
	}
	
	function checkForInput(element) {
	  // element is passed to the function ^
	  
	  const $label = $(element).siblings('label');
	
	  if ($(element).val().length > 0) {
	    $(element).addClass('has-value');
	  } else {
	    $(element).removeClass('has-value');
	  }
	}
	
	// The lines below are executed on page load
	$('input.form-control').each(function() {
	  checkForInput(this);
	});
	
	// The lines below (inside) are executed on change & keyup
	$('input.form-control').on('change keyup', function() {
	  checkForInput(this);  
	});
	
	$(document).on('change','input[type="checkbox"]',function(){
	    var $tr = $(this).closest('tr');
	    var tot = 0;
	    $('input[type="checkbox"]', $tr).each(function(){
	        if(this.checked && !this.disabled){
	            tot += Number($(this).val()) || 0; 
	        }
	    });
	    $('td:last', $tr).html(tot);
	});
	
	 /* Add  Zeros To Numbers*/
	function addZeroes( num ) {
	    var value = Number(num);
	    var res = num.split(".");
	    if(res.length > 1) {
	        value = value.toFixed(2);
	    }
	    return value
	}
	
</script>
@endsection