@extends('layouts.default')

@section('title', $customer_name->original['full_name'])

@section('new_button')
<a href="{{ url('incomes/customers/collectioncenter/'.$customer->id) }}" class="btn  mr-2 btn-default btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left rotate90deg">
last_page
</i>{{ trans('customers.collection_center') }}</a>
<a href="{{ url('incomes/customers')}}" class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">view_list</i>{{ trans_choice('general.customers', 1) . ' List'}} </a>

<a href="{{ url('incomes/customers/' . $customer->id .'/edit')}}"
    class="btn btn-info btn-height btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left">edit</i>Edit</a>

<a href="{{ url('incomes/customers/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Customers"><i class="material-icons left">add</i>{{ trans_choice('general.customers', 1)}} </a>


@endsection
<style>
    .card-DboardStats-CountNum {
    font-size: 14px !important;
   }
   .card-DboardStats {height:135px;position:relative;}
   .badge-info{position:absolute;top:4px;left:11%;}
    </style>

@section('content')
    <div class="card">
       
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6">   
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">{{ trans('auth.profile') }}</h3>
                    </div>
                <div class="box-body box-profile">
                    <ul class="list-group list-group-unbordered">
                        <li class="list-group-item">
                            <b>{{ trans('general.email') }}</b> 
                            <a class="pull-right">{{ isset($customer->customer_email)?$customer->customer_email:'N/A' }}</a>
                        </li>
                        <li class="list-group-item">
                            <b>{{ trans('general.phone') }}</b> <a class="pull-right">{{ isset($customer->phone)?$customer->phone:'N/A' }}</a>
                        </li>
                        <li class="list-group-item">
                            <b>{{ trans('general.website') }}</b> <a class="pull-right">{{ isset($customer->website)?$customer->website:'N/A' }}</a>
                        </li>
                         <li class="list-group-item">
                            <b>{{ trans('general.address') }}</b> <a class="pull-right">{{ $customer->address }}</a>
                        </li> 
                    </ul>
                </div>
            </div>

           
        </div>

     
           <div class="col-lg-6 col-md-6 col-sm-6">
             <div class="box-header with-border">
                        <h3 class="mrgn-top-3"> </h3>
                    </div>
            <div class="card-DboardStats flex-column">
               <h5>Invoices <span class="badge badge-info">{{ $counts['invoices'] }}</span></h5>
               <div class="width100P d-flex">
                    <div class="icon60">
                       <span class="icon24 icon-invoice"></span>
                    </div>
                    <div class="card-DboardStats-Count">
                        <div class="row">
                            <div class="col-md-4">
                                <a href="#">
                                    <div class="card-DboardStats-CountNum">@money($amounts['paid'], setting('general.default_currency'), true)                                   
                                    </div>
                                </a>
                                <p>{{ trans('general.paid') }}</p>
                            </div>   
                            <div class="col-md-4"> 
                                 <a href="#">
                                    <div class="card-DboardStats-CountNum">@money($amounts['open'], setting('general.default_currency'), true)
                                    </div>
                                </a>
                                <p>{{ trans('dashboard.open_invoices') }}</p>
                            </div>
                            <div class="col-md-4"> 
                                <a href="#">
                                    <div class="card-DboardStats-CountNum">@money($amounts['overdue'], setting('general.default_currency'), true)</div>
                                </a>
                                <p>{{ trans('dashboard.overdue_invoices') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
            <div class="">
                <div class="">
                    <h3 class="">{{ trans_choice('general.transactions', 2) }}</h3>
                </div>
                
                <table class="table " id="tbl-transactions">
                    <thead>
                    <tr>
                        <th>{{ trans('general.date') }}</th>
                        <th>{{ trans('general.amount') }}</th> 
                        <th>{{ trans('general.type') }}</th>
                        <th>{{ trans_choice('general.numbers',1) }}</th>
                        <th>{{ trans_choice('general.status', 1) }}</th>
                        <th>{{ trans_choice('general.actions', 1) }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($transactions as $item)
                        <tr>
                            <td >{{ isset($item['date'])?Date::parse($item['date'])->format($date_format):'' }}</td>
                            <td >@money($item['amount'],'USD',true)</td>
                            <td >{{ $item['type'] }}</td>
                            <td >{{ $item['number'] }}</td>
                            <td >{{ $item['status'] }}</td>
                            @php $id = explode('-',$item['id']); @endphp
                            @if($id[0] == 'i' && $item['status'] != 'paid')
                                <td ><a href="{{ url('incomes/customers/receivepayment') }}/{{ $item['customer_id'] }}/{{ $id[1] }}"></a></td>
                            @elseif($id[0] == 'i' && $item['status'] == 'paid')
                                <td class="mount-space"><a href="{{ url('incomes/invoices/'.$id[1].'/print' ) }}"> Print</a></td>
                            @else
                                 <td ></td>
                            @endif
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
       

@endsection
