@extends('layouts.default')
@section('title',trans('customers.collection_center').  ' For ' .$customer_full_details->original['full_name'] )
@section('content')
<!-- Default box -->

<div class="pmd-card-body horizantTabsBodyContainer">
    <ul class="nav nav-tabs" id="myTab">
        <li class="nav-item"><a href="#almostdue" class="nav-link waves-effect waves-gray active" data-toggle="tab" aria-expanded="false">Almost Due</a></li>
        <li class="nav-item"><a href="#overdue" data-toggle="tab" class="nav-link waves-effect waves-gray"  aria-expanded="true">Over Due</a></li>
    </ul>
	<div class="pmd-card-body horizantTabsBodyContainer">
	    <div class="tab-content">
			
			<div class="tab-pane tab-margin active" id="almostdue">
				 <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6">
                <form action="{{ url('/incomes/customers/collectioncenter/'.$id) }}" id="changeForm">
                
                 	{{ Form::textGroup('almost_due_at', 'Date', 'calendar',['id' => 'almost_due_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => ''],Date::now()->format($date_format) ,'col-md-3') }}
                </form>
                </div>
            </div>
			<div class="row">
				<div class="col-lg-10 col-md-10 col-sm-10">
				<div class="row">
					<div class="col-lg-4 col-md-4 col-sm-4"><strong>Customer Name</strong></div>
					<div class="col-lg-2 col-md-2 col-sm-2"><strong>Balance </strong></div>
					<div class="col-lg-2 col-md-2 col-sm-2"><strong>Days Almost Due</strong></div>
					<div class="col-lg-2 col-md-2 col-sm-2"><strong>PHONE</strong></div>
					<div class="col-lg-2 col-md-2 col-sm-2"><strong>Notes/Warnings</strong></div>
				</div>
			</div>
			<div class="col-lg-2 col-md-2 col-sm-2">
				<a href="#"><strong>Send Email</strong></a>
			</div>
		</div>

			
				@foreach($customer_almostdue as $customer_list)
	    			@if(!($customer_list->invoices->isEmpty()))
					<div class="col-lg-10 col-md-10 col-sm-10">
						<div class="box box-success">
						    <div class="box-body" style="padding: 0px; border: 1px solid #e6ecff;">
	        						<div class="row" style="background-color: #e6ecff;margin:0px">
	        							<div class="col-lg-4 col-md-4 col-sm-4">{{ $customer_list->invoices[0]->customer_name_with_parent }}
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2" style="color: red">{{ $customer_list->invoicesum }}</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2">
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2">
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2" align="center" style="cursor: pointer;"><a href=" {{  url('incomes/customers/'.$customer_list->invoices[0]->customer_id) }} "><i class="fa fa-envelope"></i></a> / <a href=" {{  url('incomes/customers/'.$customer_list->invoices[0]->customer_id) }} "><i class="fa fa-book"></i></a> 
	        							</div>
	        						</div>
	        					@foreach ($customer_list->invoices as $invoice)

	        						@php

	    							$from_date = Carbon::parse($invoice->due_at);
	    							
	    							$tenth = strtotime("+10 day");
									$tenthday =  date('Y-m-d',$tenth);
									$tenthday = Carbon::parse($tenthday);
	    							$overDueDays = $from_date->diffInDays($tenthday);

	        						$paid_payment =	App\Models\Accounts\Income\Invoice::with('payments_total')->where('id',$invoice->id)->first();

	        						if (!($paid_payment->payments_total->isEmpty())){ 
	        						$balance_payment = $invoice->amount - $paid_payment->payments_total[0]->paid_amount;
	        						
	        						}else{
	        							$balance_payment = $invoice->amount;
	        							
	        						}

	        						@endphp

	        						<div class="row " style="margin-top:10px; ">
	        							<div class="col-lg-4 col-md-4 col-sm-4">Invoice #{{ $invoice->invoice_number }}
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2">@money($balance_payment,'USD',true)
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2">{{ $overDueDays }}
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2">{{ $invoice->customer_phone }}
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2">
	        							</div>
	        						</div>
	        					@endforeach
	        				</div>
						</div>
					</div>
					<div class="col-lg-2 col-md-2 col-sm-2">
					</div>	          					
	    			@endif
				@endforeach
				
				
			</div>
			<div class="tab-pane tab-margin " id="overdue">
				<div class="row">
                    <div class="col-lg-6 col-md-6 col-sm-6">
                        <form action="{{ url('/incomes/customers/collectioncenter') }}" id="changeForm">
                
                        {{ Form::textGroup('almost_due_at', 'Date', 'calendar',['id' => 'almost_due_at', 'class' => 'form-control', 'required' => 'required', 'data-inputmask' => '\'alias\': \'yyyy/mm/dd\'', 'data-mask' => '', 'onchange'=>'$("#changeForm").submit()'],Date::now()->format($date_format) ,'col-md-3') }}
                        </form>
                    </div>
                </div>
			<div class="row">
				<div class="col-lg-10 col-md-10 col-sm-10">
				    <div class="row">
					    <div class="col-lg-4 col-md-4 col-sm-4"><strong>Customer Name</strong></div>
					    <div class="col-lg-2 col-md-2 col-sm-2"><strong>Balance </strong></div>
					    <div class="col-lg-2 col-md-2 col-sm-2"><strong>Days Over Due</strong></div>
					    <div class="col-lg-2 col-md-2 col-sm-2"><strong>PHONE</strong></div>
					    <div class="col-lg-2 col-md-2 col-sm-2"><strong>Notes/Warnings</strong></div>
				    </div>
			    </div>
			    <div class="col-lg-2 col-md-2 col-sm-2"><a href="#"><strong>Send Email</strong></a>
			    </div>
		    </div>
				@foreach($customers as $k => $customer)
	    			@if(!($customer->invoices->isEmpty()))
					<div class="col-lg-10 col-md-10 col-sm-10" >
						<div class="box box-success">
						    <div class="box-body" style="padding: 0px; border: 1px solid #e6ecff;">
	        					<div class="row" style="background-color: #e6ecff;margin:0px">
	    							<div class="col-lg-4 col-md-4 col-sm-4">{{ $customer->invoices[0]->customer_name_with_parent }}
	    								
	    							</div>
	    							<div class="col-lg-2 col-md-2 col-sm-2" id="balance_amount{{ $k }}" style="color: red">@money($customer->invoicesum, 'USD', true)
	    							</div>
	    							<div class="col-lg-2 col-md-2 col-sm-2">
	    							</div>
	    							<div class="col-lg-2 col-md-2 col-sm-2">
	    							</div>
	    							<div class="col-lg-2 col-md-2 col-sm-2" align="center" style="cursor: pointer;"> <a href="{{  url('incomes/customers/'.$customer->invoices[0]->customer_id) }}"><i class="fa fa-envelope"></i></a> / <a href="{{  url('incomes/customers/'.$customer->invoices[0]->customer_id) }}"><i class="fa fa-book"></i></a>
	    							</div>
	        					</div>
	        					@foreach ($customer->invoices as $invoice)
	        						@php

	        							$from_date = Carbon::parse($invoice->due_at);
	        							$to_date = Carbon::now();
	        							$overDueDays = $from_date->diffInDays($to_date);

	        						$paid_payment =	App\Models\Accounts\Income\Invoice::with('payments_total')->where('id',$invoice->id)->first();

	        						if (!($paid_payment->payments_total->isEmpty())){ 
	        						$balance_payment = $invoice->amount - $paid_payment->payments_total[0]->paid_amount;
	        						
	        						}else{
	        							$balance_payment = $invoice->amount;
	        							
	        						}

	        						@endphp
	        						<div class="row " style="margin-top:10px; ">
	        							<div class="col-lg-4 col-md-4 col-sm-4">Invoice #{{ $invoice->invoice_number }}
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2" id="invoice_amount{{ $k }}">@money($balance_payment,'USD',true) </div>
	        							<div class="col-lg-2 col-md-2 col-sm-2" >{{ $overDueDays }}
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2">{{ isset($invoice->customer_phone)?$invoice->customer_phone:'' }}
	        							</div>
	        							<div class="col-lg-2 col-md-2 col-sm-2">
	        							</div>
	        						</div>
	        					@endforeach
	        				</div>
						</div>
					</div>	            					
	    			@endif
				@endforeach
			</div>
	    </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
	$(document).ready(function(){
		 //Date picker
            $('#almost_due_at').datepicker({
                format: '{{ $date_format }}',
                autoclose: true
            });

	});
	
</script>
@endpush