@extends('layouts.default')
@section('title', trans_choice('general.customers', 2))

@section('header-links')
    @include('accounts.incomes.header')
@endsection

@section('new_button')
<div class="searchBox mr-2">
   {!! Form::text('search', request('search'), ['id'=>'tableSearch','class' => 'form-control input-filter input-sm', 'placeholder' => trans('general.search_placeholder')]) !!}
    <span class="search-icn"><i class="material-icons">search</i></span>
    <span class="form-controlBrd"></span>
</div>
<a href="{{ url('common/import/incomes/customers') }}" class="btn  mr-2 btn-default btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left rotate90deg">
last_page
</i>{{ trans('import.import') }}</a>

<a href="{{ url('incomes/customers/collectioncenter') }}" class="btn  mr-2 btn-default btn-Rcircle-iconic waves-effect waves-light"><i class="material-icons left rotate90deg">
last_page
</i>{{ trans('customers.collection_center') }}</a>

<a href="{{ url('incomes/customers/create') }}" class="btn btn-info btn-Rcircle-iconic waves-effect waves-light" data-toggle="tooltip" title="Create Customers"><i class="material-icons left">add</i>{{ trans_choice('general.customers', 1)}} </a>
@endsection


@section('content')
<!-- Default box -->
<div class="box box-success">
    <div class="">
        <div class="wid100-Hidden" style="min-height:400px;">
            <table class="table table-show table-striped table-hover table-bordered table-filter" id="tbl-customers">              
                <thead>
                    <tr>                        
                        <th>{{ trans('general.name') }}</th>
                        <th>{{ trans('general.email') }}</th>
                        <th>{{ trans('general.phone') }}</th>
                        <th>{{ trans('general.totalamount') }}</th>
                        <th>{{ trans('general.paidamount') }}</th>
                        <th>{{ trans_choice('general.balance',2) }}</th>
                        <th>{{ trans_choice('general.statuses', 1) }}</th>
                        <th>{{ trans('general.actions') }}</th>
                        <th>&nbsp;</th>
                    </tr>
                </thead>
                <tbody> 
                     @include('accounts.common.subtable')                     
                </tbody>
            </table>
        </div>
    </div>
    
    {{-- <input type="hidden" id="page" value="1" />
    <input type="hidden" id="max_page" value="{{ ceil($items->count() / 25) }}" /> --}}

    <div class="modal fade" id="modal-reminder-email"  >
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                  <h4 class="modal-title">{{ trans('invoices.email_reminder')}} <span id="customer_name"></span></h4>
                </div>
                <div class="modal-body">
                {!! Form::open(['id' => 'form-reminder-email', 'role' => 'form']) !!}
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input class="form-control" required="required" name="customer_email" value="" type="text" id="customer_email">
                                <label for="name" class="form-label">{{ trans('general.email') }}</label>
                                <span class="form-controlBrd"></span>
                            </div>
                        </div>
                        <div class=" col-md-6 ">
                            <div class="form-group  required ">
                                <input class="form-control" required="required" name="subject" value="Reminder: Invoice [Invoice No.] " type="text" id="subject">
                                <label for="name" class="form-label">{{ trans('invoices.subject') }}</label>
                                <span class="form-controlBrd"></span>
                                
                            </div>
                        </div>
                        <div class="col-md-6" id="cc_email_div'+invoice_id+'" style="display:none">
                            <div class="form-group  required ">
                                <input class="form-control" required="required" name="cc_email" value="" type="text" id="cc_email">
                                <label for="name" class="form-label">CC</label>
                                <span class="form-controlBrd"></span>
                                
                            </div>
                        </div>
                        <div class="col-md-6" id="bcc_email_div'+invoice_id+'" style="display:none">
                            <div class="form-group  required ">
                                <input class="form-control" required="required" name="bcc_email" value="" type="text" id="bcc_email">
                                <label for="name" class="form-label">BCC</label>
                                <span class="form-controlBrd"></span>
                                
                            </div>
                        </div>
                        
                          <input type="hidden" name="invoice_id" id="invoice_id" value="">
                        <div class="col-md-12">
                          <div class="form-groupTextArea">
                            <textarea class="form-ControlTextArea" placeholder="Enter Message" rows="3" name="message" cols="50" id="message">Dear , \nHere\'s your invoice! &nbsp We appreciate your prompt payment.\nThanks for your business! </textarea>
                            <label for="name" class="control-label">Message</label>
                            <span class="form-controlBrd"></span>
                          </div>
                        </div>
                    </div>
                {!! Form::close() !!}
                </div>
                <div class="modal-footer">
                    <div class="pull-left">
                      <button type="button" id="close-modal-create-customer" class="btn mr-3 btn-default waves-effect waves-gray" data-dismiss="modal"> <span class="fa fa-times-circle"></span> &nbsp;{{ trans('general.cancel') }}</button>
                      {!! Form::button('<span class="fa fa-save"></span> &nbsp;' . trans('general.save'), ['type' => 'button', 'id' =>'button-reminder-email', 'class' => 'btn btn-primary waves-effect waves-light']) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- /.box -->
<script type="text/javascript">
    function EmailReminder(customer_id) {
        var button = '<button type="button" data-toggle="modal" data-target="#modal-reminder-email" id="hiddenbutton"> </button>'; 
        $("body").append(button);
        $('#hiddenbutton').trigger('click');
        $("#hiddenbutton").remove();
        $('#customer_name').html($('#customer_name'+customer_id).val());
        $('#customer_email').val($('#customer_email'+customer_id).val());
        $('#customer_email').addClass('has-value')
    }
    
    $(document).on('click', '#button-reminder-email', function (e) {
        $('#modal-reminder-email .modal-header').before('<div id="span-loader"><span class="span-loader"><img src="{{ url('acs/custom/images/loader.gif') }}" class="span-loader-img"  style="position:relative;top:150px;left:180px; height:100px"></span></div>');

        var customer_id = $("#form-reminder-email input[name=customer_id]").val();
            
        $.ajax({
            url: '{{ url("incomes/invoices/") }}'+ '/'+ customer_id +'/email',
            type: 'GET',
            dataType: 'JSON',
            data: $("#form-reminder-email").serialize(),
            beforeSend: function () {
                $(".form-group").removeClass("has-error");
                $(".help-block").remove();
            },
            success: function(data) {
                $('#span-loader').remove();

                if (data['success']) {
                        $('#modal-reminder-email .modal-body').before('<div class="alert alert-success">' + data['message'] + '</div>');
                        $('div.alert-success').delay(3000).fadeOut(350);
                        $('#modal-reminder-email').modal('hide');
                }
                
            },
            error: function(error, textStatus, errorThrown) {
                $('#span-loader').remove();
                console.log(error);
            }
        });
    });

    //Ajax call to get your new Customer
    function getTableData(current_page){
        $.ajax({
            type: "GET",
            url: "{{ url('incomes/customers?page=') }}"+current_page, // whatever your URL is
            beforeSend: function(){ //This is your loading message ADD AN ID
                $('#tbl-customers').append('<div class="spinner"> <span class="">Loading...</span> </div>');
            },
            complete: function(){ //remove the loading message
            $('.spinner').remove();
            },
            success: function(html) { // success! YAY!! Add HTML to content container
                $('#tbl-customers').append(html);
            }
        });
    }
</script>
@endsection

